/*
 * Decompiled with CFR 0.152.
 */
package util.jsf;

import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.UIColumn;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIData;
import javax.faces.component.UIInput;
import javax.faces.component.UISelectItems;
import javax.faces.component.UISelectMany;
import javax.faces.component.UISelectOne;
import javax.faces.component.html.HtmlOutputText;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.event.ActionListener;
import javax.faces.event.MethodExpressionValueChangeListener;
import javax.faces.event.ValueChangeEvent;
import javax.faces.event.ValueChangeListener;
import javax.faces.model.SelectItem;
import util.jsf.IType;
import util.jsf.Types;
import util.jsf.UtilitesJSFException;
import util.reflection.ClassHelper;

public class ComponentFactory {
    public static final String SIZE = "size";
    private static final String CONVERTER = "converter";
    protected UIComponentBase component = null;
    protected String value = null;
    protected Class<?> valueType = null;
    Class<? extends UIComponentBase> type = null;
    Class<? extends Converter> converter = null;

    private ComponentFactory(Class<? extends UIComponentBase> type, Class<? extends Converter> converter) {
        this.type = type;
        this.converter = converter;
        try {
            this.component = this.type.newInstance();
            if (this.converter != null) {
                this.setConverter(this.converter.newInstance());
            }
        }
        catch (InstantiationException ex) {
            throw new UtilitesJSFException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new UtilitesJSFException(ex);
        }
    }

    public static ComponentFactory getInstance(String componentName) {
        return new ComponentFactory(ClassHelper.getClass(componentName), null);
    }

    public static ComponentFactory getInstance(IType componentType) {
        ComponentFactory instance = new ComponentFactory(componentType.getComponent(), componentType.getClassConverter());
        if (componentType.equals(Types.HTML)) {
            ((HtmlOutputText)instance.component).setEscape(false);
        } else if (componentType.equals(Types.HTML_BR)) {
            ((HtmlOutputText)instance.component).setEscape(false);
            ((HtmlOutputText)instance.component).setValue((Object)"<BR/>");
        }
        return instance;
    }

    public UIComponentBase createComponent() {
        return this.component;
    }

    public ComponentFactory setId(String id) {
        this.component.setId(id.replace(".", "_").replace("(", "").replace(")", ""));
        return this;
    }

    public ComponentFactory setParent(UIComponentBase parent) {
        if (parent != null) {
            if (parent instanceof UIData && !(this.component instanceof UIColumn)) {
                ComponentFactory.getInstance(Types.COLUMN).setId(this.component.getId() + "_auto_column").setParent(parent).addChildren(this.component);
            } else {
                parent.getChildren().add(this.component);
            }
        }
        return this;
    }

    public ComponentFactory setBinding(String binding) {
        ValueExpression ve = ComponentFactory.createValueExpression(binding, this.component.getClass());
        this.component.setValueExpression("binding", ve);
        return this;
    }

    public ComponentFactory setRendered(String rendered) {
        if (rendered != null && !rendered.isEmpty()) {
            ValueExpression ve = ComponentFactory.createValueExpression(rendered, Boolean.class);
            this.component.setValueExpression("rendered", ve);
        }
        return this;
    }

    public ComponentFactory setStyleClass(String styleClass) {
        this.component.getAttributes().put("styleClass", styleClass);
        return this;
    }

    public ComponentFactory setValue(String value) {
        if (value != null) {
            this.value = value;
            if (this.isEL(value)) {
                if (this.valueType == null) {
                    this.valueType = Object.class;
                }
                ValueExpression ve = ComponentFactory.createValueExpression(value, this.valueType);
                this.component.setValueExpression("value", ve);
            } else {
                this.component.getAttributes().put("value", value);
            }
        }
        return this;
    }

    public ComponentFactory setValueChangeListener(String value) {
        Class[] args = new Class[]{ValueChangeEvent.class};
        Application app = FacesContext.getCurrentInstance().getApplication();
        ExpressionFactory ef = app.getExpressionFactory();
        ELContext elc = FacesContext.getCurrentInstance().getELContext();
        MethodExpression mb = ef.createMethodExpression(elc, value, null, args);
        MethodExpressionValueChangeListener vcl = new MethodExpressionValueChangeListener(mb);
        ((UIInput)this.component).addValueChangeListener((ValueChangeListener)vcl);
        return this;
    }

    public ComponentFactory setConverter(Converter converter) {
        if (converter == null) {
            if (this.component.getAttributes().containsKey(CONVERTER)) {
                this.component.getAttributes().remove(CONVERTER);
            }
        } else {
            this.component.getAttributes().put(CONVERTER, converter);
        }
        return this;
    }

    public ComponentFactory setRequired(Boolean required) {
        this.component.getAttributes().put("required", required);
        return this;
    }

    public ComponentFactory setSize(Integer size) {
        return this.set(SIZE, size);
    }

    public ComponentFactory setDisabled(String disabled) {
        if (disabled != null && !disabled.isEmpty()) {
            ValueExpression ve = ComponentFactory.createValueExpression(disabled, Boolean.class);
            this.component.setValueExpression("disabled", ve);
        }
        return this;
    }

    public ComponentFactory setHint(String hint) {
        if (hint != null && !hint.isEmpty()) {
            this.set("title", hint);
        }
        return this;
    }

    public ComponentFactory setValueType(Class<?> valueType) {
        this.valueType = valueType;
        if (this.value != null) {
            this.setValue(this.value);
        }
        return this;
    }

    public ComponentFactory setReadOnly(String readOnly) {
        if (readOnly != null) {
            ValueExpression ve = ComponentFactory.createValueExpression(readOnly, Boolean.class);
            this.component.setValueExpression("readonly", ve);
        }
        return this;
    }

    public ComponentFactory setAction(String action) {
        if (action != null) {
            MethodExpression ae = ComponentFactory.createMethodExpression(action, Void.TYPE);
            if (this.component instanceof UICommand) {
                ((UICommand)this.component).setActionExpression(ae);
            } else {
                UICommand uiCommand = (UICommand)ComponentFactory.getInstance(Types.COMMAND).setId(this.component.getId() + "_action").set("event", "onclick").set("oncomplete", "true").set("reRender", this.component.getAttributes().get("reRender")).setParent(this.component).createComponent();
                uiCommand.setActionExpression(ae);
            }
        }
        return this;
    }

    public ComponentFactory setImmediate(boolean immediate) {
        if (this.component instanceof UICommand) {
            ((UICommand)this.component).setImmediate(immediate);
        }
        return this;
    }

    public ComponentFactory setHeader(UIComponentBase header) {
        if (header != null) {
            this.component.getFacets().put(Facets.HEADER.toString(), header);
        }
        return this;
    }

    public ComponentFactory setHeader(String title) {
        if (title != null && !title.isEmpty()) {
            UIComponentBase header = ComponentFactory.getInstance(Types.LABEL).setValue(title).createComponent();
            this.component.getFacets().put(Facets.HEADER.toString(), header);
        }
        return this;
    }

    public ComponentFactory setFacet(String facetName, UIComponentBase compFacet) {
        if (compFacet != null) {
            this.component.getFacets().put(facetName, compFacet);
        }
        return this;
    }

    public ComponentFactory setBody(UIComponentBase body) {
        if (body != null) {
            this.component.getChildren().add(body);
        }
        return this;
    }

    public ComponentFactory setFooter(UIComponentBase footer) {
        if (footer != null) {
            this.component.getFacets().put(Facets.FOOTER.toString(), footer);
        }
        return this;
    }

    public ComponentFactory setImage(String value, String alternativeText) {
        this.component.getAttributes().put("image", value);
        this.component.getAttributes().put("alt", alternativeText);
        return this;
    }

    public ComponentFactory setItems(List<SelectItem> values) {
        UISelectItems items = new UISelectItems();
        items.setValue(values);
        this.component.getChildren().add(items);
        return this;
    }

    public ComponentFactory set(Map<String, Object> attributes) {
        if (attributes != null && attributes.size() > 0) {
            for (String key : attributes.keySet()) {
                this.set(key, attributes.get(key));
            }
        }
        return this;
    }

    public ComponentFactory set(String attributeName, Object value) {
        if (value == null || value.toString().isEmpty()) {
            if (this.component.getAttributes().containsKey(attributeName)) {
                this.component.getAttributes().remove(attributeName);
            }
        } else if (this.isEL(value.toString())) {
            ValueExpression ve = ComponentFactory.createValueExpression(value.toString(), Object.class);
            this.component.setValueExpression(attributeName, ve);
        } else {
            this.component.getAttributes().put(attributeName, value);
        }
        return this;
    }

    public ComponentFactory addChildren(UIComponentBase children) {
        if (children != null) {
            if (this.component instanceof UICommand && children instanceof ActionListener) {
                ((UICommand)this.component).addActionListener((ActionListener)children);
            }
            this.component.getChildren().add(children);
        }
        return this;
    }

    public ComponentFactory addChildrens(List<UIComponentBase> childrens) {
        if (childrens != null) {
            for (UIComponentBase children : childrens) {
                this.addChildren(children);
            }
        }
        return this;
    }

    public ComponentFactory addActionListener(ActionListener listener) {
        if (listener != null) {
            if (this.component instanceof UICommand) {
                ((UICommand)this.component).addActionListener(listener);
            } else {
                for (UIComponent comp : this.component.getChildren()) {
                    if (!(comp instanceof UICommand)) continue;
                    ((UICommand)comp).addActionListener(listener);
                    break;
                }
            }
        }
        return this;
    }

    public boolean hasSelectItems() {
        return this.component instanceof UISelectMany || this.component instanceof UISelectOne;
    }

    public static ValueExpression createValueExpression(String valueExpression, Class<?> returnType) {
        ValueExpression vExpression = null;
        if (valueExpression != null && !valueExpression.isEmpty()) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ExpressionFactory ef = facesContext.getApplication().getExpressionFactory();
            vExpression = ef.createValueExpression(facesContext.getELContext(), valueExpression, returnType);
        }
        return vExpression;
    }

    public static MethodExpression createMethodExpression(String actionExpression, Class<?> returnType) {
        MethodExpression mExpression = null;
        if (actionExpression != null && !actionExpression.isEmpty()) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ExpressionFactory ef = facesContext.getApplication().getExpressionFactory();
            mExpression = ef.createMethodExpression(facesContext.getELContext(), actionExpression, returnType, new Class[0]);
        }
        return mExpression;
    }

    private boolean isEL(String expression) {
        return expression.contains("#{") && expression.contains("}");
    }

    private static enum Facets {
        HEADER{

            public String toString() {
                return "header";
            }
        }
        ,
        FOOTER{

            public String toString() {
                return "footer";
            }
        };

    }
}

