/*
 * Decompiled with CFR 0.152.
 */
package util.jsf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import util.convert.I18N;
import util.jsf.IMessage;

public class MessageHelper
implements IMessage,
Serializable {
    private static MessageHelper instance;

    private MessageHelper() {
    }

    public static MessageHelper getInstance() {
        if (instance == null) {
            instance = new MessageHelper();
        }
        return instance;
    }

    public Collection<FacesMessage> getAllMessages() {
        ArrayList<FacesMessage> list = new ArrayList<FacesMessage>();
        FacesContext context = FacesContext.getCurrentInstance();
        Iterator messages = context.getMessages();
        while (messages.hasNext()) {
            FacesMessage msg = (FacesMessage)messages.next();
            list.add(new FacesMessage(msg.getSeverity(), msg.getDetail(), msg.getDetail()){

                public String toString() {
                    return this.getSeverity().toString().toLowerCase().split(" ")[0];
                }
            });
        }
        return list;
    }

    public Collection<FacesMessage> getGlobalMessages() {
        HashSet<FacesMessage> list = new HashSet<FacesMessage>();
        FacesContext context = FacesContext.getCurrentInstance();
        Iterator messages = context.getMessages();
        while (messages.hasNext()) {
            FacesMessage msg = (FacesMessage)messages.next();
            if (msg.getSummary() == null) continue;
            list.add(new FacesMessage(msg.getSeverity(), msg.getSummary(), msg.getDetail()){

                public String toString() {
                    return this.getSeverity().toString().toLowerCase().split(" ")[0];
                }

                public boolean equals(Object obj) {
                    if (obj == null) {
                        return false;
                    }
                    if (((Object)((Object)this)).getClass() != obj.getClass()) {
                        return false;
                    }
                    FacesMessage other = (FacesMessage)obj;
                    return this.getSummary().equals(other.getSummary()) || this.getSummary() != null && this.getSummary().equals(other.getSummary());
                }

                public int hashCode() {
                    int hash = 7;
                    hash = 29 * hash + (this.getSummary() != null ? this.getSummary().hashCode() : 0);
                    return hash;
                }
            });
        }
        return list;
    }

    @Override
    public void addErrorMessage(String componetId, String key, String defaultMessage, Object ... args) {
        this.addMessage(FacesMessage.SEVERITY_ERROR, componetId, key, defaultMessage, args);
    }

    @Override
    public void addInfoMessage(String componetId, String key, String defaultMessage, Object ... args) {
        this.addMessage(FacesMessage.SEVERITY_INFO, componetId, key, defaultMessage, args);
    }

    @Override
    public void addWarnMessage(String componetId, String key, String defaultMessage, Object ... args) {
        this.addMessage(FacesMessage.SEVERITY_WARN, componetId, key, defaultMessage, args);
    }

    @Override
    public void addFatalMessage(String componetId, String key, String defaultMessage, Object ... args) {
        this.addMessage(FacesMessage.SEVERITY_FATAL, componetId, key, defaultMessage, args);
    }

    @Override
    public void addExceptionMessage(Exception ex, Object ... args) {
        this.addExceptionMessage(null, ex, args);
    }

    @Override
    public void addExceptionMessage(String componetId, Exception ex, Object ... args) {
        String cause = ex.getCause() == null ? ex.getClass().getName() : ex.getCause().toString();
        String errorMessage = ex.getCause() == null ? ex.getMessage() : ex.getCause().getMessage();
        this.addErrorMessage(componetId, ex.getClass().getName(), errorMessage, args);
    }

    protected void addMessage(FacesMessage.Severity severity, String componetId, String key, String defaultMessage, Object ... args) {
        FacesMessage[] messages;
        FacesContext context = FacesContext.getCurrentInstance();
        for (FacesMessage message : messages = this.createMessage(severity, componetId, key, defaultMessage, args)) {
            context.addMessage(componetId, message);
        }
    }

    protected FacesMessage[] createMessage(FacesMessage.Severity severity, String componetId, String key, String defaultMessage, Object ... args) {
        String[] splitMessages;
        LinkedList<FacesMessage> messages = new LinkedList<FacesMessage>();
        String fullMessage = defaultMessage;
        if (key != null && !key.equals("")) {
            fullMessage = I18N.getMessage(key, defaultMessage, args);
        }
        for (String message : splitMessages = fullMessage.split("\n")) {
            FacesMessage facesMessage = new FacesMessage();
            facesMessage.setSeverity(severity);
            if (componetId == null) {
                facesMessage.setSummary(message);
            } else {
                facesMessage.setDetail(message);
            }
            messages.add(facesMessage);
        }
        return messages.toArray(new FacesMessage[0]);
    }
}

