/*
 * Decompiled with CFR 0.152.
 */
package util.jsf.phaseListeners;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.servlet.http.HttpServletRequest;

public class PostRedirectGetListener
implements PhaseListener {
    private static final String SAVED_VIEW_ROOT_ID = "PostRedirectGetListener.savedViewRoot";
    private static final String ALL_FACES_MESSAGES_ID = "PostRedirectGetListener.allFacesMessages";
    private static final String ALL_UIINPUT_VALUES_ID = "PostRedirectGetListener.allUIInputValues";

    public PhaseId getPhaseId() {
        return PhaseId.RENDER_RESPONSE;
    }

    public void beforePhase(PhaseEvent event) {
        FacesContext facesContext = event.getFacesContext();
        HttpServletRequest request = (HttpServletRequest)facesContext.getExternalContext().getRequest();
        if ("POST".equals(request.getMethod())) {
            PostRedirectGetListener.saveViewRoot(facesContext);
            PostRedirectGetListener.saveFacesMessages(facesContext);
            PostRedirectGetListener.saveUIInputValues(facesContext);
            PostRedirectGetListener.redirect(facesContext, PostRedirectGetListener.resolveActionURL(facesContext));
        } else {
            PostRedirectGetListener.restoreViewRoot(facesContext);
            PostRedirectGetListener.restoreFacesMessages(facesContext);
            PostRedirectGetListener.restoreUIInputValues(facesContext);
        }
    }

    public void afterPhase(PhaseEvent event) {
    }

    private static void saveViewRoot(FacesContext facesContext) {
        UIViewRoot savedViewRoot = facesContext.getViewRoot();
        facesContext.getExternalContext().getSessionMap().put(SAVED_VIEW_ROOT_ID, savedViewRoot);
    }

    private static void saveFacesMessages(FacesContext facesContext) {
        LinkedHashMap allFacesMessages = new LinkedHashMap();
        facesContext.getExternalContext().getSessionMap().put(ALL_FACES_MESSAGES_ID, allFacesMessages);
        Iterator clientIdsWithMessages = facesContext.getClientIdsWithMessages();
        while (clientIdsWithMessages.hasNext()) {
            String clientIdWithMessage = (String)clientIdsWithMessages.next();
            ArrayList clientFacesMessages = new ArrayList();
            allFacesMessages.put(clientIdWithMessage, clientFacesMessages);
            Iterator facesMessages = facesContext.getMessages(clientIdWithMessage);
            while (facesMessages.hasNext()) {
                clientFacesMessages.add(facesMessages.next());
            }
        }
    }

    private static void saveUIInputValues(FacesContext facesContext) {
        HashMap<String, Object> allUIInputValues = new HashMap<String, Object>();
        facesContext.getExternalContext().getSessionMap().put(ALL_UIINPUT_VALUES_ID, allUIInputValues);
        PostRedirectGetListener.saveUIInputValues(facesContext, facesContext.getViewRoot().getChildren(), allUIInputValues);
    }

    private static void saveUIInputValues(FacesContext facesContext, List<UIComponent> components, Map<String, Object> allUIInputValues) {
        for (UIComponent component : components) {
            if (component instanceof UIInput) {
                UIInput input = (UIInput)component;
                allUIInputValues.put(input.getClientId(facesContext), input.getValue());
            }
            PostRedirectGetListener.saveUIInputValues(facesContext, component.getChildren(), allUIInputValues);
        }
    }

    private static String resolveActionURL(FacesContext facesContext) {
        return facesContext.getApplication().getViewHandler().getActionURL(facesContext, facesContext.getViewRoot().getViewId());
    }

    private static void redirect(FacesContext facesContext, String url) {
        try {
            facesContext.getExternalContext().redirect(url);
        }
        catch (IOException e) {
            throw new FacesException("Cannot redirect to " + url + " due to IO exception.", (Throwable)e);
        }
    }

    private static void restoreViewRoot(FacesContext facesContext) {
        UIViewRoot savedViewRoot = (UIViewRoot)facesContext.getExternalContext().getSessionMap().remove(SAVED_VIEW_ROOT_ID);
        if (savedViewRoot != null) {
            facesContext.setViewRoot(savedViewRoot);
        }
    }

    private static void restoreFacesMessages(FacesContext facesContext) {
        Map allFacesMessages = (Map)facesContext.getExternalContext().getSessionMap().remove(ALL_FACES_MESSAGES_ID);
        if (allFacesMessages != null) {
            for (String clientId : allFacesMessages.keySet()) {
                List allClientFacesMessages = (List)allFacesMessages.get(clientId);
                for (FacesMessage clientFacesMessage : allClientFacesMessages) {
                    facesContext.addMessage(clientId, clientFacesMessage);
                }
            }
        }
    }

    private static void restoreUIInputValues(FacesContext facesContext) {
        Map allUIInputValues = (Map)facesContext.getExternalContext().getSessionMap().remove(ALL_UIINPUT_VALUES_ID);
        if (allUIInputValues != null) {
            for (String clientId : allUIInputValues.keySet()) {
                UIInput input = (UIInput)facesContext.getViewRoot().findComponent(clientId);
                input.setValue(allUIInputValues.get(clientId));
            }
        }
    }
}

