/*
 * Decompiled with CFR 0.152.
 */
package util.jsf.phaseListeners;

import java.util.Iterator;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.servlet.http.HttpServletRequest;
import util.convert.I18N;

public class ValidationFacesMessageListener
implements PhaseListener {
    private static final String BACK_GROUND_COLOR = "background:#fcc";
    private static final String CURRENT_FOCUS_ATTRIBUTE = "currentFocus";

    public PhaseId getPhaseId() {
        return PhaseId.RENDER_RESPONSE;
    }

    public void beforePhase(PhaseEvent event) {
        FacesContext fc = event.getFacesContext();
        UIViewRoot root = fc.getViewRoot();
        Iterator clientIds = fc.getClientIdsWithMessages();
        this.resetColor(root.getChildren());
        while (clientIds.hasNext()) {
            String clientId = (String)clientIds.next();
            if (clientId == null) continue;
            UIComponent uiComponent = root.findComponent(clientId);
            Iterator messages = fc.getMessages(clientId);
            while (messages.hasNext()) {
                FacesMessage fm = (FacesMessage)messages.next();
                String labelKey = "field_" + uiComponent.getId() + "_label";
                String labelText = I18N.getMessage(labelKey, "Erro", new Object[0]);
                String separator = labelText.endsWith(":") ? " " : ": ";
                String prefix = labelText + separator;
                if (fm.getSummary().startsWith(prefix)) continue;
                fm.setSummary(prefix + fm.getSummary());
            }
            uiComponent.getAttributes().put("style", BACK_GROUND_COLOR);
            this.focus(fc, uiComponent);
        }
    }

    private void focus(FacesContext fc, UIComponent uiComponent) {
        HttpServletRequest request = (HttpServletRequest)fc.getExternalContext().getRequest();
        if (request.getAttribute(CURRENT_FOCUS_ATTRIBUTE) == null) {
            request.setAttribute(CURRENT_FOCUS_ATTRIBUTE, (Object)uiComponent.getId());
        }
    }

    private void resetColor(List children) {
        for (UIComponent uiComponent : children) {
            if (this.isErrorBackground(uiComponent)) {
                uiComponent.getAttributes().remove("style");
            }
            this.resetColor(uiComponent.getChildren());
        }
    }

    private boolean isErrorBackground(UIComponent uiComponent) {
        if (!(uiComponent instanceof UIInput)) {
            return false;
        }
        return BACK_GROUND_COLOR.equals(uiComponent.getAttributes().get("style"));
    }

    public void afterPhase(PhaseEvent e) {
    }
}

