/*
 * Decompiled with CFR 0.152.
 */
package util.reflection;

import java.lang.reflect.Field;
import java.util.Locale;
import util.reflection.ReflectionException;

public final class ClassHelper {
    private ClassHelper() {
    }

    public static Class getClass(Object object) {
        Class<?> clazz;
        if (object == null) {
            throw new IllegalArgumentException("N\u00e3o pode-se retornar classe para tipo null");
        }
        if (object instanceof Class) {
            clazz = (Class<?>)object;
        } else if (object instanceof String) {
            try {
                clazz = Class.forName(object.toString());
            }
            catch (ClassNotFoundException ex) {
                throw new ReflectionException("N\u00e3o foi poss\u00edvel encontrar a classe " + object.toString(), ex);
            }
        } else {
            clazz = object.getClass();
        }
        return ClassHelper.checkForCGLIB(clazz);
    }

    private static Class checkForCGLIB(Class type) {
        if (type.getName().contains("CGLIB")) {
            return type.getSuperclass();
        }
        return type;
    }

    public static Field getField(Class clazz, String propertyName) {
        Field field = null;
        String name = propertyName.substring(propertyName.lastIndexOf(".") + 1);
        Exception exp = null;
        for (Class c = clazz; c != null; c = c.getSuperclass()) {
            try {
                field = c.getDeclaredField(name);
                break;
            }
            catch (Exception ex) {
                exp = ex;
                continue;
            }
        }
        if (field == null) {
            throw new ReflectionException("Propriedade <<" + name + ">> n\u00e3o ENCONTRADA na classe " + clazz, exp);
        }
        return field;
    }

    public static boolean isBasicProperty(Class type) {
        String typeName = type.getSimpleName().toLowerCase(Locale.getDefault());
        return typeName.startsWith("string") || typeName.startsWith("byte") || typeName.startsWith("short") || typeName.startsWith("int") || typeName.startsWith("long") || typeName.startsWith("double") || typeName.startsWith("float") || typeName.startsWith("date") || typeName.startsWith("calendar") || typeName.startsWith("bool") || typeName.startsWith("char") || typeName.equals("biginteger") || typeName.equals("enum") || typeName.equals("array");
    }

    public static boolean isNumber(Class<?> type) {
        return ClassHelper.isInteger(type) || ClassHelper.isDecimal(type);
    }

    public static boolean isInteger(Class<?> type) {
        String typeName = type.getSimpleName().toLowerCase(Locale.getDefault());
        return typeName.equals("byte") || typeName.equals("short") || typeName.equals("int") || typeName.equals("integer") || typeName.equals("long") || typeName.equals("biginteger");
    }

    public static boolean isDecimal(Class<?> type) {
        String typeName = type.getSimpleName().toLowerCase(Locale.getDefault());
        return typeName.equals("double") || typeName.equals("float") || typeName.equals("bigdecimal");
    }
}

