/*
 * Decompiled with CFR 0.152.
 */
package util.reflection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;
import util.reflection.ClassHelper;
import util.reflection.PropertyHelper;

public final class MethodHelper {
    private static final String PREFIX_IS = "is";
    private static final String PREFIX_GET = "get";
    private static final String PREFIX_SET = "set";
    protected static final String[] PREFIX_GETS = new String[]{"get", "is"};
    protected static final String[] PREFIXES_ALL = new String[]{"get", "set", "is"};

    private MethodHelper() {
    }

    public static Method getMethod(Object object, String methodName) {
        if (methodName.contains(".")) {
            object = PropertyHelper.getProperty(object, methodName.substring(0, methodName.lastIndexOf(".")));
            return MethodHelper.getMethod(object, methodName.substring(methodName.lastIndexOf(".") + 1).replace("()", ""));
        }
        for (Method method : MethodHelper.getMethods(object)) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        return null;
    }

    public static List<Method> getMethods(Object domainObject) {
        Class classModel = ClassHelper.getClass(domainObject);
        LinkedList classes = new LinkedList();
        LinkedList<Method> methods = new LinkedList<Method>();
        for (Class classe = classModel; classe != null; classe = classe.getSuperclass()) {
            classes.add(classe);
        }
        for (int i = classes.size() - 2; i >= 0; --i) {
            Class classe = (Class)classes.get(i);
            for (Method m : classe.getDeclaredMethods()) {
                if (!Modifier.isPublic(m.getModifiers()) || MethodHelper.isGetter(m) || MethodHelper.isSetter(m) || MethodHelper.isObjectMethod(m)) continue;
                methods.add(m);
            }
        }
        return methods;
    }

    public static List<Method> getAllMethods(Object domainObject) {
        Class classModel = ClassHelper.getClass(domainObject);
        LinkedList classes = new LinkedList();
        LinkedList<Method> methods = new LinkedList<Method>();
        for (Class classe = classModel; classe != null; classe = classe.getSuperclass()) {
            classes.add(classe);
        }
        for (int i = classes.size() - 2; i >= 0; --i) {
            Class classe = (Class)classes.get(i);
            for (Method m : classe.getDeclaredMethods()) {
                methods.add(m);
            }
        }
        return methods;
    }

    public static Object invoke(Object object, String methodName, Object ... args) {
        Method method = null;
        if (methodName.contains(".")) {
            object = PropertyHelper.getProperty(object, methodName.substring(0, methodName.lastIndexOf(".")));
            method = MethodHelper.getMethod(object, methodName.substring(methodName.lastIndexOf(".") + 1).replace("()", ""));
        } else {
            Class clazz = ClassHelper.getClass(object);
            method = MethodHelper.getMethod(clazz, methodName);
        }
        return MethodHelper.invoke(object, method, args);
    }

    private static Object invoke(Object object, Method method, Object ... args) {
        if (object == null) {
            throw new IllegalArgumentException("Cannot invoke a method on a null instance");
        }
        if (method == null) {
            throw new IllegalArgumentException("Cannot invoke a null method");
        }
        if (args == null) {
            throw new IllegalArgumentException("Cannot invoke a method with null parameters");
        }
        try {
            return method.invoke(object, args);
        }
        catch (IllegalAccessException ex) {
            throw new UnsupportedOperationException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new UnsupportedOperationException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new UnsupportedOperationException(ex.getCause());
        }
    }

    private static boolean isGetter(Method m) {
        if (!Modifier.isPublic(m.getModifiers()) || m.getParameterTypes().length != 0 || m.getReturnType().equals(Void.TYPE) || Modifier.isStatic(m.getModifiers()) || Modifier.isAbstract(m.getModifiers()) || Modifier.isVolatile(m.getModifiers()) || m.getDeclaringClass().equals(Object.class)) {
            return false;
        }
        if (m.getName().startsWith(PREFIX_GET) && m.getName().length() > PREFIX_GET.length()) {
            return true;
        }
        return m.getName().startsWith(PREFIX_IS) && m.getName().length() > PREFIX_IS.length() && (m.getReturnType().equals(Boolean.TYPE) || m.getReturnType().equals(Boolean.class));
    }

    private static boolean isSetter(Method m) {
        if (!Modifier.isPublic(m.getModifiers()) || m.getParameterTypes().length != 1 || !m.getReturnType().equals(Void.TYPE) || Modifier.isStatic(m.getModifiers()) || Modifier.isAbstract(m.getModifiers()) || Modifier.isVolatile(m.getModifiers()) || m.getDeclaringClass().equals(Object.class)) {
            return false;
        }
        return m.getName().startsWith(PREFIX_SET) && m.getName().length() > PREFIX_SET.length();
    }

    private static boolean isObjectMethod(Method m) {
        return m.getName().equals("equals") || m.getName().equals("getClass") || m.getName().equals("hashCode") || m.getName().equals("notify") || m.getName().equals("notifyAll") || m.getName().equals("toString") || m.getName().equals("wait") || m.getName().equals("compareTo");
    }
}

