/*
 * Decompiled with CFR 0.152.
 */
package util.reflection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import util.reflection.ClassHelper;
import util.reflection.MethodHelper;
import util.reflection.ReflectionException;

public class ObjectHelper {
    public static Object newInstance(Object object) {
        Object objReturn = null;
        Class clazz = ClassHelper.getClass(object);
        try {
            objReturn = clazz.newInstance();
        }
        catch (InstantiationException iex) {
            throw new ReflectionException("N\u00e3o foi poss\u00edvel criar a classe " + clazz.getCanonicalName(), iex);
        }
        catch (IllegalAccessException iaex) {
            throw new ReflectionException("N\u00e3o foi poss\u00edvel criar a classe " + clazz.getCanonicalName(), iaex);
        }
        return objReturn;
    }

    public static Object newAndPopulate(Object object, Map<String, Object> propertiesValues) {
        Object obj = ObjectHelper.newInstance(ClassHelper.getClass(object));
        ObjectHelper.apply(obj, propertiesValues);
        return obj;
    }

    public static Object apply(Object bean, Map<String, Object> properties) {
        try {
            BeanUtils.populate((Object)bean, properties);
        }
        catch (IllegalAccessException iaex) {
            throw new ReflectionException(iaex);
        }
        catch (InvocationTargetException itex) {
            throw new ReflectionException(itex);
        }
        for (String key : properties.keySet()) {
            Method m = MethodHelper.getMethod(bean, key);
            if (m == null) continue;
            return MethodHelper.invoke(bean, key, new Object[0]);
        }
        return null;
    }

    public static Map extract(Object bean) {
        try {
            return BeanUtils.describe((Object)bean);
        }
        catch (IllegalAccessException iaex) {
            throw new ReflectionException(iaex);
        }
        catch (InvocationTargetException itex) {
            throw new ReflectionException(itex);
        }
        catch (NoSuchMethodException nsmex) {
            throw new ReflectionException(nsmex);
        }
    }
}

