/*
 * Decompiled with CFR 0.152.
 */
package util.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.PropertyUtils;
import util.convert.StringUtil;
import util.reflection.ClassHelper;
import util.reflection.ReflectionException;

public class PropertyHelper {
    public static Object getProperty(Object bean, String propertyName) {
        if (bean == null) {
            throw new NullPointerException("Bean is null");
        }
        if (propertyName == null) {
            throw new NullPointerException("Property Name is null");
        }
        try {
            return PropertyUtils.getProperty((Object)bean, (String)propertyName);
        }
        catch (Exception ex) {
            throw new ReflectionException("N\u00e3o foi poss\u00edvel acessar a propriedade " + propertyName, ex);
        }
    }

    public static void setProperty(Object bean, String propertyName, Object value) {
        if (bean == null) {
            throw new NullPointerException("Bean is null");
        }
        if (propertyName == null) {
            throw new NullPointerException("Property Name is null");
        }
        Object newValue = null;
        try {
            Class clazz = PropertyUtils.getPropertyType((Object)bean, (String)propertyName);
            newValue = ConvertUtils.convert((String)value.toString(), (Class)clazz);
            PropertyUtils.setProperty((Object)bean, (String)propertyName, (Object)newValue);
        }
        catch (Exception ex) {
            throw new ReflectionException("N\u00e3o foi poss\u00edvel acessar a propriedade " + propertyName, ex);
        }
    }

    public static Type getPropertyGenericType(Class bean, String propertyName) {
        Type returnType = null;
        try {
            Field field = bean.getDeclaredField(StringUtil.lowerCaseFirstLetter(propertyName));
            ParameterizedType type = (ParameterizedType)field.getGenericType();
            Type[] types = type.getActualTypeArguments();
            returnType = types[0];
        }
        catch (Exception ex) {
            throw new ReflectionException("N\u00e3o foi poss\u00edvel retornar o tipo da propriedade " + propertyName, ex);
        }
        return returnType;
    }

    public static Enum[] getEnumValues(Class bean, String propertyName) {
        Enum[] values = null;
        try {
            Object instance = ClassHelper.getClass(bean).newInstance();
            Class propertyType = PropertyUtils.getPropertyType(instance, (String)propertyName);
            values = (Enum[])propertyType.getMethod("values", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception ex) {
            throw new ReflectionException(ex);
        }
        return values;
    }
}

