/*
 * Decompiled with CFR 0.152.
 */
package br.eti.clairton.repository.http;

import br.eti.clairton.repository.Comparator;
import br.eti.clairton.repository.Comparators;
import br.eti.clairton.repository.Order;
import br.eti.clairton.repository.Predicate;
import br.eti.clairton.repository.http.AttributeBuilder;
import br.eti.clairton.repository.http.Page;
import br.eti.clairton.repository.http.Record;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.Type;

@Dependent
public class QueryParser {
    private static final Logger logger = Logger.getLogger(QueryParser.class.getSimpleName());
    private final List<String> query = Arrays.asList("sort", "page", "per_page", "direction");
    private final AttributeBuilder builder;

    @Deprecated
    protected QueryParser() {
        this(null);
    }

    @Inject
    public QueryParser(AttributeBuilder builder) {
        this.builder = builder;
    }

    public Collection<Predicate> parse(Map<String, String[]> params, Class<?> modelType) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        String ids = this.idsKey(modelType);
        String id = this.idKey(modelType);
        if (params.containsKey(ids)) {
            String[] values = params.containsKey(id) ? (String[])Stream.concat(Arrays.stream((Object[])params.get(id)), Arrays.stream((Object[])params.get(ids))).toArray(String[]::new) : params.get(ids);
            params.put(id, values);
            params.remove(ids);
        }
        Set<String> keys = params.keySet();
        for (String field : keys) {
            if (this.query.contains(field) || "format".equals(field)) continue;
            Attribute<?, ?>[] attrs = this.builder.with(modelType, field);
            if (attrs.length == 1 && attrs[0] == null) {
                logger.log(Level.WARNING, "Attribute {}#{} not found", new Object[]{modelType, field});
                continue;
            }
            String[] values = params.get(field);
            Collection<Predicate> predicate = this.to(attrs, values);
            predicates.addAll(predicate);
        }
        return predicates;
    }

    public List<Order> order(Map<String, String[]> params, Class<?> modelType) {
        ArrayList<Order> orders = new ArrayList<Order>();
        if (params == null) {
            return orders;
        }
        String[] sort = params.containsKey("direction") ? params.get("direction") : new String[]{"asc"};
        String[] orderBy = params.containsKey("sort") ? params.get("sort") : new String[]{this.idKey(modelType)};
        int j = orderBy.length;
        for (int i = 0; i < j; ++i) {
            Order.Direction type;
            String field = orderBy[i];
            Attribute<?, ?>[] attrs = this.builder.with(modelType, field);
            try {
                type = Order.Direction.byString((String)sort[i]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                type = Order.Direction.ASC;
            }
            Order order = new Order(type, attrs);
            orders.add(order);
        }
        return orders;
    }

    public Page paginate(Map<String, String[]> params, Class<?> modelType) {
        if (params == null) {
            return new Page(0, 0);
        }
        Integer page = params.containsKey("page") ? Integer.valueOf(params.get("page")[0]) : Integer.valueOf(0);
        Integer perPage = params.containsKey("per_page") ? Integer.valueOf(params.get("per_page")[0]) : Integer.valueOf(0);
        return new Page(page, perPage);
    }

    protected Record to(String value) {
        return Record.valueOf(value);
    }

    protected Record to(String[] values) {
        return Record.valueOf(values);
    }

    protected <T> Predicate to(Attribute<?, ?>[] attrs, String value) {
        Class javaType;
        Record record = this.to(value);
        Attribute<?, ?> attr = attrs[attrs.length - 1];
        if (attr.isCollection()) {
            PluralAttribute pa = (PluralAttribute)attr;
            Type type = pa.getElementType();
            javaType = type.getJavaType();
        } else {
            javaType = attr.getJavaType();
        }
        Object object = javaType.isEnum() ? this.parseEnum(record.value, javaType) : (javaType.isAssignableFrom(Boolean.class) ? this.parseBoolean(record.value) : (javaType.isAssignableFrom(LocalDate.class) ? this.parseLocalDate(record.value) : record.value.toString()));
        Comparator comparator = record.comparator;
        Predicate predicate = new Predicate(object, comparator, attrs);
        return predicate;
    }

    protected <T> Collection<Predicate> to(Attribute<?, ?>[] attrs, String[] value) {
        if (value.length > 1) {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            for (String s : value) {
                Predicate predicate = this.to(attrs, s);
                predicates.add(predicate);
            }
            if (predicates.stream().filter(p -> p.getComparator().equals(Comparators.EQUAL)).count() == Long.valueOf(predicates.size()).longValue()) {
                Attribute[] attributes = ((Predicate)predicates.get(0)).getAttributes();
                List values = predicates.stream().map(p -> p.getValue()).collect(Collectors.toList());
                Comparators comparator = Comparators.LIKE;
                Predicate predicate = new Predicate(values, (Comparator)comparator, attributes);
                return Arrays.asList(predicate);
            }
            return predicates;
        }
        Predicate predicate = this.to(attrs, value[0]);
        return Arrays.asList(predicate);
    }

    protected String idsKey(Class<?> modelType) {
        return "ids[]";
    }

    protected String idKey(Class<?> modelType) {
        return "id";
    }

    protected Boolean parseBoolean(Object object) {
        return Boolean.valueOf(object.toString());
    }

    protected LocalDate parseLocalDate(Object object) {
        String[] values = object.toString().split(this.dateSeparator());
        return LocalDate.of((int)Integer.valueOf(values[0]), Integer.valueOf(values[1]), (int)Integer.valueOf(values[2]));
    }

    protected String dateFormat() {
        return "yyyy-mm-dd";
    }

    protected String dateSeparator() {
        return "-";
    }

    protected Enum<?> parseEnum(Object object, Class type) {
        Object e = Enum.valueOf(type, object.toString());
        return (Enum)e;
    }
}

