/*
 * Decompiled with CFR 0.152.
 */
package br.eti.kinoshita.selenium;

import br.eti.kinoshita.selenium.SeleniumGuiceModule;
import br.eti.kinoshita.selenium.model.SeleniumScreenshot;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tap4j.ext.testng.TAPAttribute;
import org.tap4j.ext.testng.TestTAPReporter;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.AfterTest;
import org.testng.annotations.Guice;
import org.testng.annotations.Listeners;

@Listeners(value={TestTAPReporter.class})
@Guice(modules={SeleniumGuiceModule.class})
public abstract class SeleniumWebTest {
    protected static final Logger LOGGER = LoggerFactory.getLogger(SeleniumWebTest.class);
    @Inject
    protected WebDriver driver;
    @Inject
    protected Configuration configuration;

    @AfterTest(alwaysRun=true)
    public void tearDown() {
        if (this.driver != null) {
            LOGGER.info("Closing WebDriver...");
            try {
                this.driver.close();
                this.driver.quit();
                LOGGER.info("OK!");
            }
            catch (Throwable t) {
                LOGGER.warn(t.getMessage(), t);
            }
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void addScreenShot(ITestContext context, Method method, String description) {
        if (this.driver instanceof TakesScreenshot) {
            LOGGER.debug("Taking screenshot with driver " + this.driver.getTitle());
            File attachment = (File)((TakesScreenshot)this.driver).getScreenshotAs(OutputType.FILE);
            SeleniumScreenshot screenshot = new SeleniumScreenshot(attachment, description, "image/png", attachment.getName());
            this.addScreenShot(context, method, screenshot);
        } else {
            LOGGER.warn("Driver " + this.driver.getTitle() + " does not support taking screenshots. Use a different one please.");
        }
    }

    protected void addScreenShot(ITestContext context, Method method, SeleniumScreenshot screenshot) {
        TAPAttribute attr;
        Object o = context.getAttribute("Files");
        Map filesMap = null;
        filesMap = o == null ? new LinkedHashMap() : ((attr = (TAPAttribute)o).getMethod() != method ? new LinkedHashMap() : (Map)attr.getValue());
        LinkedHashMap<String, Object> fileMap = new LinkedHashMap<String, Object>();
        File file = screenshot.getFile();
        fileMap.put("File-Location", file.getAbsolutePath());
        fileMap.put("File-Title", screenshot.getTitle());
        fileMap.put("File-Description", screenshot.getDescription());
        fileMap.put("File-Size", file.length());
        fileMap.put("File-Name", file.getName());
        byte[] fileData = null;
        try {
            fileData = FileUtils.readFileToByteArray((File)file);
        }
        catch (IOException e) {
            Assert.fail((String)"Failed to read file to byte array.", (Throwable)e);
        }
        String content = Base64.encodeBase64String((byte[])fileData);
        fileMap.put("File-Content", content);
        fileMap.put("File-Type", screenshot.getFileType());
        filesMap.put(file.getAbsolutePath(), fileMap);
        TAPAttribute attribute = new TAPAttribute(method, filesMap);
        context.setAttribute("Files", (Object)attribute);
    }
}

