/*
 * Decompiled with CFR 0.152.
 */
package br.eti.kinoshita.testlinkjavaapi;

import br.eti.kinoshita.testlinkjavaapi.BaseService;
import br.eti.kinoshita.testlinkjavaapi.TestLinkAPIException;
import br.eti.kinoshita.testlinkjavaapi.model.Attachment;
import br.eti.kinoshita.testlinkjavaapi.model.Requirement;
import br.eti.kinoshita.testlinkjavaapi.model.TestLinkMethods;
import br.eti.kinoshita.testlinkjavaapi.model.TestLinkParams;
import br.eti.kinoshita.testlinkjavaapi.model.TestLinkResponseParams;
import br.eti.kinoshita.testlinkjavaapi.model.TestLinkTables;
import br.eti.kinoshita.testlinkjavaapi.util.Util;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.xmlrpc.XmlRpcException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RequirementService
extends BaseService {
    public RequirementService(String url, String devKey) throws MalformedURLException {
        super(url, devKey);
    }

    protected Attachment uploadRequirementAttachment(Integer requirementId, String title, String description, String fileName, String fileType, String content) throws TestLinkAPIException {
        Attachment attachment = null;
        Integer id = 0;
        attachment = new Attachment(id, requirementId, TestLinkTables.requirements.toString(), title, description, fileName, null, fileType, content);
        try {
            Map<String, Object> executionData = Util.getRequirementAttachmentMap(attachment);
            Object response = this.executeXmlRpcCall(TestLinkMethods.uploadRequirementAttachment.toString(), executionData);
            Map responseMap = (Map)response;
            id = Util.getInteger(responseMap, TestLinkResponseParams.id.toString());
            attachment.setId(id);
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error uploading attachment for requirement: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return attachment;
    }

    protected void assignRequirements(Integer testCaseId, Integer testProjectId, List<Requirement> requirements) throws TestLinkAPIException {
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.testCaseId.toString(), testCaseId);
            executionData.put(TestLinkParams.testProjectId.toString(), testProjectId);
            executionData.put(TestLinkParams.requirements.toString(), Util.getRequirementsGroupedByReqSpecMap(requirements));
            this.executeXmlRpcCall(TestLinkMethods.assignRequirements.toString(), executionData);
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error assigning requirement for test case: " + xmlrpcex.getMessage(), xmlrpcex);
        }
    }
}

