/*
 * Decompiled with CFR 0.152.
 */
package br.eti.kinoshita.testlinkjavaapi;

import br.eti.kinoshita.testlinkjavaapi.TestLinkAPIException;
import br.eti.kinoshita.testlinkjavaapi.model.TestLinkParams;
import br.eti.kinoshita.testlinkjavaapi.util.Util;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseService {
    private static final Integer FALSE_IN_PHP = 0;
    private String url;
    private String devKey;
    private XmlRpcClient xmlRpcClient;

    public BaseService(String url, String devKey) throws MalformedURLException {
        this.url = url;
        this.devKey = devKey;
        this.xmlRpcClient = new XmlRpcClient();
        XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
        config.setServerURL(new URL(this.url));
        config.setEnabledForExtensions(true);
        this.xmlRpcClient.setConfig((XmlRpcClientConfig)config);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDevKey() {
        return this.devKey;
    }

    public void setDevKey(String devKey) {
        this.devKey = devKey;
    }

    public Object executeXmlRpcCall(String methodName, Map<String, Object> executionData) throws XmlRpcException, TestLinkAPIException {
        ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>();
        if (executionData != null) {
            if (executionData.get(TestLinkParams.devKey.toString()) == null) {
                executionData.put(TestLinkParams.devKey.toString(), this.devKey);
            }
            params.add(executionData);
        }
        Object o = this.xmlRpcClient.execute(methodName, params);
        this.checkResponseError(o);
        return o;
    }

    protected void checkResponseError(Object response) throws TestLinkAPIException {
        if (response instanceof Object[]) {
            Object[] responseArray = (Object[])response;
            for (int i = 0; i < responseArray.length; ++i) {
                Object maybeAMap = responseArray[i];
                if (!(maybeAMap instanceof Map)) continue;
                Map errorMap = (Map)maybeAMap;
                Integer code = Util.getInteger(errorMap, "code");
                String message = Util.getString(errorMap, "message");
                if (code == null) continue;
                throw new TestLinkAPIException(code, message);
            }
        } else if (response instanceof Map) {
            Map errorMap = (Map)response;
            Integer statusOk = Util.getInteger(errorMap, "status_ok");
            String message = Util.getString(errorMap, "msg");
            if (statusOk != null && statusOk == FALSE_IN_PHP) {
                throw new TestLinkAPIException(statusOk, message);
            }
        }
    }
}

