/*
 * Decompiled with CFR 0.152.
 */
package br.eti.kinoshita.testlinkjavaapi;

import br.eti.kinoshita.testlinkjavaapi.BuildService;
import br.eti.kinoshita.testlinkjavaapi.MiscService;
import br.eti.kinoshita.testlinkjavaapi.ReqSpecService;
import br.eti.kinoshita.testlinkjavaapi.RequirementService;
import br.eti.kinoshita.testlinkjavaapi.TestCaseService;
import br.eti.kinoshita.testlinkjavaapi.TestLinkAPIException;
import br.eti.kinoshita.testlinkjavaapi.TestPlanService;
import br.eti.kinoshita.testlinkjavaapi.TestProjectService;
import br.eti.kinoshita.testlinkjavaapi.TestSuiteService;
import br.eti.kinoshita.testlinkjavaapi.model.Attachment;
import br.eti.kinoshita.testlinkjavaapi.model.Build;
import br.eti.kinoshita.testlinkjavaapi.model.CustomField;
import br.eti.kinoshita.testlinkjavaapi.model.Execution;
import br.eti.kinoshita.testlinkjavaapi.model.ExecutionStatus;
import br.eti.kinoshita.testlinkjavaapi.model.ExecutionType;
import br.eti.kinoshita.testlinkjavaapi.model.Platform;
import br.eti.kinoshita.testlinkjavaapi.model.ReportTCResultResponse;
import br.eti.kinoshita.testlinkjavaapi.model.Requirement;
import br.eti.kinoshita.testlinkjavaapi.model.ResponseDetails;
import br.eti.kinoshita.testlinkjavaapi.model.TestCase;
import br.eti.kinoshita.testlinkjavaapi.model.TestCaseStep;
import br.eti.kinoshita.testlinkjavaapi.model.TestImportance;
import br.eti.kinoshita.testlinkjavaapi.model.TestPlan;
import br.eti.kinoshita.testlinkjavaapi.model.TestProject;
import br.eti.kinoshita.testlinkjavaapi.model.TestSuite;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestLinkAPI {
    private String url;
    private String devKey;
    private final TestProjectService testProjectService;
    private final TestPlanService testPlanService;
    private final MiscService miscService;
    private final TestCaseService testCaseService;
    private final TestSuiteService testSuiteService;
    private final BuildService buildService;
    private final RequirementService requirementService;
    private final ReqSpecService reqSpecService;

    public TestLinkAPI(String url, String devKey) throws MalformedURLException {
        this.url = url;
        this.devKey = devKey;
        this.testProjectService = new TestProjectService(url, devKey);
        this.testPlanService = new TestPlanService(url, devKey);
        this.miscService = new MiscService(url, devKey);
        this.testCaseService = new TestCaseService(url, devKey);
        this.testSuiteService = new TestSuiteService(url, devKey);
        this.buildService = new BuildService(url, devKey);
        this.requirementService = new RequirementService(url, devKey);
        this.reqSpecService = new ReqSpecService(url, devKey);
    }

    public String getUrl() {
        return this.url;
    }

    public String getDevKey() {
        return this.devKey;
    }

    public String toString() {
        return "TestLinkAPI [url=" + this.url + ", devKey=" + this.devKey + "]";
    }

    public Boolean checkDevKey(String devKey) throws TestLinkAPIException {
        return this.miscService.checkDevKey(devKey);
    }

    public Boolean doesUserExist(String user) throws TestLinkAPIException {
        return this.miscService.doesUserExist(user);
    }

    public String ping() throws TestLinkAPIException {
        return this.sayHello();
    }

    public String sayHello() throws TestLinkAPIException {
        return this.miscService.sayHello();
    }

    public String about() throws TestLinkAPIException {
        return this.miscService.about();
    }

    public Boolean setTestMode(Boolean testMode) throws TestLinkAPIException {
        return this.miscService.setTestMode(testMode);
    }

    public String repeat(String str) throws TestLinkAPIException {
        return this.miscService.repeat(str);
    }

    public Attachment uploadAttachment(Integer fkId, String fkTable, String title, String description, String fileName, String fileType, String content) throws TestLinkAPIException {
        return this.miscService.uploadAttachment(fkId, fkTable, title, description, fileName, fileType, content);
    }

    public String[] getFullPath(Integer nodeId) throws TestLinkAPIException {
        return this.miscService.getFullPath(nodeId);
    }

    public Execution getLastExecutionResult(Integer testPlanId, Integer testCaseId, Integer testCaseExternalId) throws TestLinkAPIException {
        return this.miscService.getLastExecutionResult(testPlanId, testCaseId, testCaseExternalId);
    }

    public TestProject createTestProject(String testProjectName, String testProjectPrefix, String notes, Boolean enableRequirements, Boolean enableTestPriority, Boolean enableAutomation, Boolean enableInventory, Boolean isActive, Boolean isPublic) throws TestLinkAPIException {
        return this.testProjectService.createTestProject(testProjectName, testProjectPrefix, notes, enableRequirements, enableTestPriority, enableAutomation, enableInventory, isActive, isPublic);
    }

    public TestProject getTestProjectByName(String projectName) throws TestLinkAPIException {
        return this.testProjectService.getTestProjectByName(projectName);
    }

    public TestProject[] getProjects() throws TestLinkAPIException {
        return this.testProjectService.getProjects();
    }

    public TestPlan[] getProjectTestPlans(Integer projectId) throws TestLinkAPIException {
        return this.testProjectService.getProjectTestPlans(projectId);
    }

    public Attachment uploadTestProjectAttachment(Integer testProjectId, String title, String description, String fileName, String fileType, String content) throws TestLinkAPIException {
        return this.testProjectService.uploadTestProjectAttachment(testProjectId, title, description, fileName, fileType, content);
    }

    public TestPlan createTestPlan(String planName, String projectName, String notes, Boolean isActive, Boolean isPublic) throws TestLinkAPIException {
        return this.testPlanService.createTestPlan(planName, projectName, notes, isActive, isPublic);
    }

    public TestPlan getTestPlanByName(String planName, String projectName) throws TestLinkAPIException {
        return this.testPlanService.getTestPlanByName(planName, projectName);
    }

    public Platform[] getTestPlanPlatforms(Integer planId) throws TestLinkAPIException {
        return this.testPlanService.getTestPlanPlatforms(planId);
    }

    public Map<String, Object> getTotalsForTestPlan(Integer testPlanId) throws TestLinkAPIException {
        return this.testPlanService.getTotalsForTestPlan(testPlanId);
    }

    public Build createBuild(Integer testPlanId, String buildName, String buildNotes) throws TestLinkAPIException {
        return this.buildService.createBuild(testPlanId, buildName, buildNotes);
    }

    public Build[] getBuildsForTestPlan(Integer testPlanId) throws TestLinkAPIException {
        return this.buildService.getBuildsForTestPlan(testPlanId);
    }

    public Build getLatestBuildForTestPlan(Integer testPlanId) throws TestLinkAPIException {
        return this.buildService.getLatestBuildForTestPlan(testPlanId);
    }

    public TestSuite createTestSuite(Integer testProjectId, String name, String details, Integer parentId, Integer order, Boolean checkDuplicatedName, String actionOnDuplicatedName) throws TestLinkAPIException {
        return this.testSuiteService.createTestSuite(testProjectId, name, details, parentId, order, checkDuplicatedName, actionOnDuplicatedName);
    }

    public TestSuite[] getTestSuiteByID(List<Integer> testSuiteIds) throws TestLinkAPIException {
        return this.testSuiteService.getTestSuiteByID(testSuiteIds);
    }

    public Attachment uploadTestSuiteAttachment(Integer testSuiteId, String title, String description, String fileName, String fileType, String content) throws TestLinkAPIException {
        return this.testSuiteService.uploadTestSuiteAttachment(testSuiteId, title, description, fileName, fileType, content);
    }

    public TestSuite[] getTestSuitesForTestPlan(Integer testPlanId) throws TestLinkAPIException {
        return this.testSuiteService.getTestSuitesForTestPlan(testPlanId);
    }

    public TestSuite[] getTestSuitesForTestSuite(Integer testSuiteId) throws TestLinkAPIException {
        return this.testSuiteService.getTestSuitesForTestSuite(testSuiteId);
    }

    public TestSuite[] getFirstLevelTestSuitesForTestProject(Integer testProjectId) throws TestLinkAPIException {
        return this.testSuiteService.getFirstLevelTestSuitesForTestProject(testProjectId);
    }

    public TestCase createTestCase(String testCaseName, Integer testSuiteId, Integer testProjectId, String authorLogin, String summary, List<TestCaseStep> steps, String preconditions, TestImportance importance, ExecutionType execution, Integer order, Integer internalId, Boolean checkDuplicatedName, String actionOnDuplicatedName) throws TestLinkAPIException {
        return this.testCaseService.createTestCase(testCaseName, testSuiteId, testProjectId, authorLogin, summary, steps, preconditions, importance, execution, order, internalId, checkDuplicatedName, actionOnDuplicatedName);
    }

    public Integer addTestCaseToTestPlan(Integer testProjectId, Integer testPlanId, Integer testCaseId, Integer version, Integer platformId, Integer order, Integer urgency) throws TestLinkAPIException {
        return this.testCaseService.addTestCaseToTestPlan(testProjectId, testPlanId, testCaseId, version, platformId, order, urgency);
    }

    public TestCase[] getTestCasesForTestSuite(Integer testSuiteId, Boolean deep, String details) throws TestLinkAPIException {
        return this.testCaseService.getTestCasesForTestSuite(testSuiteId, deep, details);
    }

    public TestCase getTestCase(Integer testCaseId, Integer testCaseExternalId, Integer version) throws TestLinkAPIException {
        return this.testCaseService.getTestCase(testCaseId, testCaseExternalId, version);
    }

    public TestCase[] getTestCasesForTestPlan(Integer testPlanId, List<Integer> testCasesIds, Integer buildId, List<Integer> keywordsIds, String keywords, Boolean executed, List<Integer> assignedTo, String executeStatus, ExecutionType executionType, Boolean getStepInfo) throws TestLinkAPIException {
        return this.testCaseService.getTestCasesForTestPlan(testPlanId, testCasesIds, buildId, keywordsIds, keywords, executed, assignedTo, executeStatus, executionType, getStepInfo);
    }

    public Integer getTestCaseIDByName(String testCaseName, String testSuiteName, String testProjectName, String testCasePathName) throws TestLinkAPIException {
        return this.testCaseService.getTestCaseIDByName(testCaseName, testSuiteName, testProjectName, testCasePathName);
    }

    public Attachment uploadTestCaseAttachment(Integer testCaseId, String title, String description, String fileName, String fileType, String content) throws TestLinkAPIException {
        return this.testCaseService.uploadTestCaseAttachment(testCaseId, title, description, fileName, fileType, content);
    }

    public Attachment[] getTestCaseAttachments(Integer testCaseId, Integer testCaseExternalId) throws TestLinkAPIException {
        return this.testCaseService.getTestCaseAttachments(testCaseId, testCaseExternalId);
    }

    public Attachment uploadExecutionAttachment(Integer executionId, String title, String description, String fileName, String fileType, String content) throws TestLinkAPIException {
        return this.testCaseService.uploadExecutionAttachment(executionId, title, description, fileName, fileType, content);
    }

    public void deleteExecution(Integer executionId) throws TestLinkAPIException {
        this.testCaseService.deleteExecution(executionId);
    }

    public ReportTCResultResponse reportTCResult(Integer testCaseId, Integer testCaseExternalId, Integer testPlanId, ExecutionStatus status, Integer buildId, String buildName, String notes, Boolean guess, String bugId, Integer platformId, String platformName, Map<String, String> customFields, Boolean overwrite) throws TestLinkAPIException {
        return this.testCaseService.reportTCResult(testCaseId, testCaseExternalId, testPlanId, status, buildId, buildName, notes, guess, bugId, platformId, platformName, customFields, overwrite);
    }

    public ReportTCResultResponse setTestCaseExecutionResult(Integer testCaseId, Integer testCaseExternalId, Integer testPlanId, ExecutionStatus status, Integer buildId, String buildName, String notes, Boolean guess, String bugId, Integer platformId, String platformName, Map<String, String> customFields, Boolean overwrite) throws TestLinkAPIException {
        return this.testCaseService.reportTCResult(testCaseId, testCaseExternalId, testPlanId, status, buildId, buildName, notes, guess, bugId, platformId, platformName, customFields, overwrite);
    }

    public CustomField getTestCaseCustomFieldDesignValue(Integer testCaseId, Integer testCaseExternalId, Integer versionNumber, Integer testProjectId, String customFieldName, ResponseDetails details) throws TestLinkAPIException {
        return this.testCaseService.getTestCaseCustomFieldDesignValue(testCaseId, testCaseExternalId, versionNumber, testProjectId, customFieldName, details);
    }

    public Attachment uploadRequirementSpecificationAttachment(Integer reqSpecId, String title, String description, String fileName, String fileType, String content) throws TestLinkAPIException {
        return this.reqSpecService.uploadRequirementSpecificationAttachment(reqSpecId, title, description, fileName, fileType, content);
    }

    public Attachment uploadRequirementAttachment(Integer requirementId, String title, String description, String fileName, String fileType, String content) throws TestLinkAPIException {
        return this.requirementService.uploadRequirementAttachment(requirementId, title, description, fileName, fileType, content);
    }

    public void assignRequirements(Integer testCaseId, Integer testProjectId, List<Requirement> requirements) throws TestLinkAPIException {
        this.requirementService.assignRequirements(testCaseId, testProjectId, requirements);
    }
}

