/*
 * Decompiled with CFR 0.152.
 */
package br.eti.kinoshita.testlinkjavaapi.util;

import br.eti.kinoshita.testlinkjavaapi.model.Attachment;
import br.eti.kinoshita.testlinkjavaapi.model.Build;
import br.eti.kinoshita.testlinkjavaapi.model.CustomField;
import br.eti.kinoshita.testlinkjavaapi.model.Execution;
import br.eti.kinoshita.testlinkjavaapi.model.ExecutionStatus;
import br.eti.kinoshita.testlinkjavaapi.model.ExecutionType;
import br.eti.kinoshita.testlinkjavaapi.model.Platform;
import br.eti.kinoshita.testlinkjavaapi.model.ReportTCResultResponse;
import br.eti.kinoshita.testlinkjavaapi.model.Requirement;
import br.eti.kinoshita.testlinkjavaapi.model.TestCase;
import br.eti.kinoshita.testlinkjavaapi.model.TestCaseStep;
import br.eti.kinoshita.testlinkjavaapi.model.TestLinkParams;
import br.eti.kinoshita.testlinkjavaapi.model.TestLinkResponseParams;
import br.eti.kinoshita.testlinkjavaapi.model.TestPlan;
import br.eti.kinoshita.testlinkjavaapi.model.TestProject;
import br.eti.kinoshita.testlinkjavaapi.model.TestSuite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private Util() {
    }

    public static final Map<String, Object> getTestProjectMap(TestProject project) {
        HashMap<String, Object> executionData = new HashMap<String, Object>();
        executionData.put(TestLinkParams.testProjectName.toString(), project.getName());
        executionData.put(TestLinkParams.testCasePrefix.toString(), project.getPrefix());
        executionData.put(TestLinkParams.notes.toString(), project.getNotes());
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put(TestLinkParams.enableRequirements.toString(), project.isEnableRequirements());
        options.put(TestLinkParams.enableTestPriority.toString(), project.isEnableTestPriority());
        options.put(TestLinkParams.enableAutomation.toString(), project.isEnableAutomation());
        options.put(TestLinkParams.enableInventory.toString(), project.isEnableInventory());
        executionData.put(TestLinkParams.options.toString(), options);
        executionData.put(TestLinkParams.active.toString(), project.isActive());
        executionData.put(TestLinkParams.public_.toString(), project.isPublic());
        return executionData;
    }

    public static final TestProject getTestProject(Map<String, Object> map) {
        Integer id;
        Object o;
        TestProject testProject = null;
        if (map != null && map.size() > 0 && (o = map.get(TestLinkResponseParams.id.toString())) != null && (id = Integer.valueOf(Integer.parseInt(o.toString()))) > 0) {
            testProject = new TestProject();
            testProject.setId(id);
            testProject.setName(Util.getString(map, TestLinkResponseParams.name.toString()));
            testProject.setPrefix(Util.getString(map, TestLinkResponseParams.prefix.toString()));
            testProject.setNotes(Util.getString(map, TestLinkResponseParams.notes.toString()));
            Map optMap = (Map)map.get(TestLinkResponseParams.opt.toString());
            testProject.setEnableAutomation(Util.getBoolean(optMap, TestLinkResponseParams.automationEnabled.toString()));
            testProject.setEnableRequirements(Util.getBoolean(optMap, TestLinkResponseParams.requirementsEnabled.toString()));
            testProject.setEnableTestPriority(Util.getBoolean(optMap, TestLinkResponseParams.testPriorityEnabled.toString()));
            testProject.setEnableInventory(Util.getBoolean(optMap, TestLinkResponseParams.inventoryEnabled.toString()));
            testProject.setActive(Util.getBoolean(map, TestLinkResponseParams.active.toString()));
            testProject.setPublic(Util.getBoolean(map, TestLinkResponseParams.isPublic.toString()));
        }
        return testProject;
    }

    public static Boolean getBoolean(Map<String, Object> map, String key) {
        Boolean booleanObj = null;
        Integer integer = Util.getInteger(map, key);
        if (integer != null) {
            booleanObj = integer == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        return booleanObj;
    }

    public static final String getString(Map<String, Object> map, String key) {
        Object o;
        String string = null;
        if (map != null && map.size() > 0 && (o = map.get(key)) != null) {
            string = o.toString();
        }
        return string;
    }

    public static final Integer getInteger(Map<String, Object> map, String key) {
        Object o;
        Integer integer = null;
        if (map != null && map.size() > 0 && (o = map.get(key)) != null) {
            try {
                integer = Integer.parseInt(o.toString());
            }
            catch (NumberFormatException nfe) {
                integer = null;
            }
        }
        return integer;
    }

    public static final Map<String, Object> getTestPlanMap(TestPlan plan) {
        HashMap<String, Object> executionData = new HashMap<String, Object>();
        executionData.put(TestLinkParams.testPlanName.toString(), plan.getName());
        executionData.put(TestLinkParams.testProjectName.toString(), plan.getProjectName());
        executionData.put(TestLinkParams.notes.toString(), plan.getNotes());
        executionData.put(TestLinkParams.active.toString(), plan.isActive());
        executionData.put(TestLinkParams.public_.toString(), plan.isPublic());
        return executionData;
    }

    public static final TestPlan getTestPlan(Map<String, Object> map) {
        Integer id;
        Object o;
        TestPlan testPlan = null;
        if (map != null && map.size() > 0 && (o = map.get(TestLinkResponseParams.id.toString())) != null && (id = Integer.valueOf(Integer.parseInt(o.toString()))) > 0) {
            testPlan = new TestPlan();
            testPlan.setId(id);
            testPlan.setName(Util.getString(map, TestLinkResponseParams.name.toString()));
            testPlan.setProjectName(Util.getString(map, TestLinkResponseParams.projectName.toString()));
            testPlan.setNotes(Util.getString(map, TestLinkResponseParams.notes.toString()));
            testPlan.setActive(Util.getBoolean(map, TestLinkResponseParams.active.toString()));
            testPlan.setPublic(Util.getBoolean(map, TestLinkResponseParams.isPublic.toString()));
        }
        return testPlan;
    }

    public static final Platform getPlatform(Map<String, Object> map) {
        Integer id;
        Object o;
        Platform platform = null;
        if (map != null && map.size() > 0 && (o = map.get(TestLinkResponseParams.id.toString())) != null && (id = Integer.valueOf(Integer.parseInt(o.toString()))) > 0) {
            platform = new Platform();
            platform.setId(id);
            platform.setName(Util.getString(map, TestLinkResponseParams.name.toString()));
            platform.setNotes(Util.getString(map, TestLinkResponseParams.notes.toString()));
        }
        return platform;
    }

    public static final Map<String, Object> getTestCaseMap(TestCase testCase) {
        HashMap<String, Object> executionData = new HashMap<String, Object>();
        executionData.put(TestLinkParams.testCaseName.toString(), testCase.getName());
        executionData.put(TestLinkParams.testSuiteId.toString(), testCase.getTestSuiteId());
        executionData.put(TestLinkParams.testProjectId.toString(), testCase.getTestProjectId());
        executionData.put(TestLinkParams.authorLogin.toString(), testCase.getAuthorLogin());
        executionData.put(TestLinkParams.summary.toString(), testCase.getSummary());
        ArrayList<Map<String, Object>> steps = new ArrayList<Map<String, Object>>();
        List<TestCaseStep> testCaseSteps = testCase.getSteps();
        if (testCaseSteps != null && testCaseSteps.size() > 0) {
            for (TestCaseStep testCaseStep : testCaseSteps) {
                Map<String, Object> testCaseStepMap = Util.getTestCaseStepMap(testCaseStep);
                steps.add(testCaseStepMap);
            }
        }
        executionData.put(TestLinkParams.steps.toString(), steps);
        executionData.put(TestLinkParams.preconditions.toString(), testCase.getPreconditions());
        executionData.put(TestLinkParams.importance.toString(), Util.getStringValueOrNull((Object)testCase.getTestImportance()));
        executionData.put(TestLinkParams.execution.toString(), Util.getStringValueOrNull((Object)testCase.getExecutionType()));
        executionData.put(TestLinkParams.order.toString(), testCase.getOrder());
        executionData.put(TestLinkParams.internalId.toString(), testCase.getInternalId());
        executionData.put(TestLinkParams.checkDuplicatedName.toString(), testCase.getCheckDuplicatedName());
        executionData.put(TestLinkParams.actionOnDuplicatedName.toString(), testCase.getActionOnDuplicatedName());
        return executionData;
    }

    public static final Map<String, Object> getTestCaseStepMap(TestCaseStep testCaseStep) {
        HashMap<String, Object> executionData = new HashMap<String, Object>();
        executionData.put(TestLinkParams.stepNumber.toString(), testCaseStep.getNumber());
        executionData.put(TestLinkParams.actions.toString(), testCaseStep.getActions());
        executionData.put(TestLinkParams.expectedResults.toString(), testCaseStep.getExpectedResults());
        executionData.put(TestLinkParams.executionType.toString(), (Object)testCaseStep.getExecutionType());
        return executionData;
    }

    public static final Map<String, Object> getTestSuiteMap(TestSuite testSuite) {
        HashMap<String, Object> executionData = new HashMap<String, Object>();
        executionData.put(TestLinkParams.testSuiteName.toString(), testSuite.getName());
        executionData.put(TestLinkParams.testProjectId.toString(), testSuite.getTestProjectId());
        executionData.put(TestLinkParams.parentId.toString(), testSuite.getParentId());
        executionData.put(TestLinkParams.details.toString(), testSuite.getDetails());
        executionData.put(TestLinkParams.order.toString(), testSuite.getOrder());
        executionData.put(TestLinkParams.checkDuplicatedName.toString(), testSuite.getCheckDuplicatedName());
        executionData.put(TestLinkParams.actionOnDuplicatedName.toString(), testSuite.getActionOnDuplicatedName());
        return executionData;
    }

    public static final TestSuite getTestSuite(Map<String, Object> map) {
        Integer id;
        Object o;
        TestSuite testSuite = null;
        if (map != null && map.size() > 0 && (o = map.get(TestLinkResponseParams.id.toString())) != null && (id = Integer.valueOf(Integer.parseInt(o.toString()))) > 0) {
            testSuite = new TestSuite();
            testSuite.setId(id);
            testSuite.setDetails(Util.getString(map, TestLinkResponseParams.details.toString()));
            testSuite.setName(Util.getString(map, TestLinkResponseParams.name.toString()));
            testSuite.setParentId(Util.getInteger(map, TestLinkResponseParams.parentId.toString()));
            testSuite.setOrder(Util.getInteger(map, TestLinkResponseParams.order.toString()));
        }
        return testSuite;
    }

    public static final TestCase getTestCase(Map<String, Object> map) {
        Integer id;
        Object o;
        TestCase testCase = null;
        if (map != null && map.size() > 0 && (o = map.get(TestLinkResponseParams.id.toString())) != null && (id = Integer.valueOf(Integer.parseInt(o.toString()))) > 0) {
            testCase = new TestCase();
            testCase.setId(id);
            testCase.setVersionId(Util.getInteger(map, TestLinkResponseParams.testCaseVersionId.toString()));
            testCase.setVersion(Util.getInteger(map, TestLinkResponseParams.version.toString()));
            testCase.setPreconditions(Util.getString(map, TestLinkResponseParams.preconditions.toString()));
            testCase.setSummary(Util.getString(map, TestLinkResponseParams.summary.toString()));
            testCase.setParentId(Util.getInteger(map, TestLinkResponseParams.parentId.toString()));
            testCase.setOrder(Util.getInteger(map, TestLinkResponseParams.order.toString()));
            testCase.setName(Util.getString(map, TestLinkResponseParams.name.toString()));
            Integer executionTypeValue = Util.getInteger(map, TestLinkResponseParams.executionType.toString());
            ExecutionType execution = ExecutionType.getExecutionType(executionTypeValue);
            testCase.setExecutionType(execution);
        }
        return testCase;
    }

    public static Object[] getArray(Map<String, Object> map, String key) {
        Object o;
        Object[] array = null;
        if (map != null && map.size() > 0 && (o = map.get(key)) != null) {
            array = (Object[])o;
        }
        return array;
    }

    public static final Map<String, Object> getBuildMap(Build build) {
        HashMap<String, Object> executionData = new HashMap<String, Object>();
        executionData.put(TestLinkParams.testPlanId.toString(), build.getTestPlanId());
        executionData.put(TestLinkParams.buildName.toString(), build.getName());
        executionData.put(TestLinkParams.buildNotes.toString(), build.getNotes());
        return executionData;
    }

    public static final Map<String, Object> getAttachmentMap(Attachment attachment) {
        HashMap<String, Object> executionData = new HashMap<String, Object>();
        executionData.put(TestLinkParams.fkId.toString(), attachment.getFkId());
        executionData.put(TestLinkParams.fkTable.toString(), attachment.getFkTable());
        executionData.put(TestLinkParams.title.toString(), attachment.getTitle());
        executionData.put(TestLinkParams.description.toString(), attachment.getDescription());
        executionData.put(TestLinkParams.fileName.toString(), attachment.getFileName());
        executionData.put(TestLinkParams.fileType.toString(), attachment.getFileType());
        executionData.put(TestLinkParams.content.toString(), attachment.getContent());
        return executionData;
    }

    public static final Map<String, Object> getTestCaseAttachmentMap(Attachment attachment) {
        HashMap<String, Object> executionData = new HashMap<String, Object>();
        executionData.put(TestLinkParams.testCaseId.toString(), attachment.getFkId());
        executionData.put(TestLinkParams.fkTable.toString(), attachment.getFkTable());
        executionData.put(TestLinkParams.title.toString(), attachment.getTitle());
        executionData.put(TestLinkParams.description.toString(), attachment.getDescription());
        executionData.put(TestLinkParams.fileName.toString(), attachment.getFileName());
        executionData.put(TestLinkParams.fileType.toString(), attachment.getFileType());
        executionData.put(TestLinkParams.content.toString(), attachment.getContent());
        return executionData;
    }

    public static final Map<String, Object> getTestSuiteAttachmentMap(Attachment attachment) {
        HashMap<String, Object> executionData = new HashMap<String, Object>();
        executionData.put(TestLinkParams.testSuiteId.toString(), attachment.getFkId());
        executionData.put(TestLinkParams.fkTable.toString(), attachment.getFkTable());
        executionData.put(TestLinkParams.title.toString(), attachment.getTitle());
        executionData.put(TestLinkParams.description.toString(), attachment.getDescription());
        executionData.put(TestLinkParams.fileName.toString(), attachment.getFileName());
        executionData.put(TestLinkParams.fileType.toString(), attachment.getFileType());
        executionData.put(TestLinkParams.content.toString(), attachment.getContent());
        return executionData;
    }

    public static final Map<String, Object> getTestProjectAttachmentMap(Attachment attachment) {
        HashMap<String, Object> executionData = new HashMap<String, Object>();
        executionData.put(TestLinkParams.testProjectId.toString(), attachment.getFkId());
        executionData.put(TestLinkParams.fkTable.toString(), attachment.getFkTable());
        executionData.put(TestLinkParams.title.toString(), attachment.getTitle());
        executionData.put(TestLinkParams.description.toString(), attachment.getDescription());
        executionData.put(TestLinkParams.fileName.toString(), attachment.getFileName());
        executionData.put(TestLinkParams.fileType.toString(), attachment.getFileType());
        executionData.put(TestLinkParams.content.toString(), attachment.getContent());
        return executionData;
    }

    public static final Map<String, Object> getRequirementAttachmentMap(Attachment attachment) {
        HashMap<String, Object> executionData = new HashMap<String, Object>();
        executionData.put(TestLinkParams.requirementId.toString(), attachment.getFkId());
        executionData.put(TestLinkParams.fkTable.toString(), attachment.getFkTable());
        executionData.put(TestLinkParams.title.toString(), attachment.getTitle());
        executionData.put(TestLinkParams.description.toString(), attachment.getDescription());
        executionData.put(TestLinkParams.fileName.toString(), attachment.getFileName());
        executionData.put(TestLinkParams.fileType.toString(), attachment.getFileType());
        executionData.put(TestLinkParams.content.toString(), attachment.getContent());
        return executionData;
    }

    public static final Map<String, Object> getRequirementSpecificatoinAttachmentMap(Attachment attachment) {
        HashMap<String, Object> executionData = new HashMap<String, Object>();
        executionData.put(TestLinkParams.reqSpecId.toString(), attachment.getFkId());
        executionData.put(TestLinkParams.fkTable.toString(), attachment.getFkTable());
        executionData.put(TestLinkParams.title.toString(), attachment.getTitle());
        executionData.put(TestLinkParams.description.toString(), attachment.getDescription());
        executionData.put(TestLinkParams.fileName.toString(), attachment.getFileName());
        executionData.put(TestLinkParams.fileType.toString(), attachment.getFileType());
        executionData.put(TestLinkParams.content.toString(), attachment.getContent());
        return executionData;
    }

    public static final Map<String, Object> getExecutionAttachmentMap(Attachment attachment) {
        HashMap<String, Object> executionData = new HashMap<String, Object>();
        executionData.put(TestLinkParams.executionId.toString(), attachment.getFkId());
        executionData.put(TestLinkParams.title.toString(), attachment.getTitle());
        executionData.put(TestLinkParams.description.toString(), attachment.getDescription());
        executionData.put(TestLinkParams.fileName.toString(), attachment.getFileName());
        executionData.put(TestLinkParams.fileType.toString(), attachment.getFileType());
        executionData.put(TestLinkParams.content.toString(), attachment.getContent());
        return executionData;
    }

    public static final Attachment getAttachment(Map<String, Object> map) {
        Integer id;
        Object o;
        Attachment attachment = null;
        if (map != null && map.size() > 0 && (o = map.get(TestLinkResponseParams.id.toString())) != null && (id = Integer.valueOf(Integer.parseInt(o.toString()))) > 0) {
            attachment = new Attachment();
            attachment.setId(id);
            attachment.setFileName(Util.getString(map, TestLinkResponseParams.name.toString()));
            attachment.setFileType(Util.getString(map, TestLinkResponseParams.fileType.toString()));
            attachment.setTitle(Util.getString(map, TestLinkResponseParams.title.toString()));
            attachment.setContent(Util.getString(map, TestLinkResponseParams.content.toString()));
        }
        return attachment;
    }

    public static final List<Map<String, Object>> getRequirementsGroupedByReqSpecMap(List<Requirement> requirements) {
        ArrayList<Map<String, Object>> requirementsGroupedByReqSpecMap = new ArrayList<Map<String, Object>>();
        HashMap<Integer, ArrayList<Integer>> tempMap = new HashMap<Integer, ArrayList<Integer>>();
        for (Requirement requirement : requirements) {
            ArrayList<Integer> requirementsArray = (ArrayList<Integer>)tempMap.get(requirement.getReqSpecId());
            if (requirementsArray == null) {
                requirementsArray = new ArrayList<Integer>();
            }
            requirementsArray.add(requirement.getId());
            tempMap.put(requirement.getReqSpecId(), requirementsArray);
        }
        Set entrySet = tempMap.entrySet();
        for (Map.Entry entry : entrySet) {
            HashMap<String, Object> finalMap = new HashMap<String, Object>();
            finalMap.put("req_spec", entry.getKey());
            finalMap.put("requirements", entry.getValue());
            requirementsGroupedByReqSpecMap.add(finalMap);
        }
        return requirementsGroupedByReqSpecMap;
    }

    public static final Execution getExecution(Map<String, Object> map) {
        Integer id;
        Object o;
        Execution execution = null;
        if (map != null && map.size() > 0 && (o = map.get(TestLinkResponseParams.id.toString())) != null && (id = Integer.valueOf(Integer.parseInt(o.toString()))) > 0) {
            execution = new Execution();
            execution.setId(id);
            execution.setBuildId(Util.getInteger(map, TestLinkResponseParams.buildId.toString()));
            execution.setTesterId(Util.getInteger(map, TestLinkResponseParams.testerId.toString()));
            String statusText = Util.getString(map, TestLinkResponseParams.status.toString());
            ExecutionStatus status = ExecutionStatus.getExecutionStatus(statusText.charAt(0));
            execution.setStatus(status);
            execution.setTestPlanId(Util.getInteger(map, TestLinkResponseParams.testPlanId.toString()));
            execution.setTestCaseVersionId(Util.getInteger(map, TestLinkResponseParams.testCaseVersionId.toString()));
            execution.setTestCaseVersionNumber(Util.getInteger(map, TestLinkResponseParams.testcaseVersionNumber.toString()));
            Integer executionTypeText = Util.getInteger(map, TestLinkResponseParams.executionType.toString());
            ExecutionType executionType = ExecutionType.getExecutionType(executionTypeText);
            execution.setExecutionType(executionType);
            execution.setNotes(Util.getString(map, TestLinkResponseParams.notes.toString()));
        }
        return execution;
    }

    public static final Build getBuild(Map<String, Object> map) {
        Integer id;
        Object o;
        Build build = null;
        if (map != null && map.size() > 0 && (o = map.get(TestLinkResponseParams.id.toString())) != null && (id = Integer.valueOf(Integer.parseInt(o.toString()))) > 0) {
            build = new Build();
            build.setId(id);
            build.setName(Util.getString(map, TestLinkResponseParams.name.toString()));
            build.setNotes(Util.getString(map, TestLinkResponseParams.notes.toString()));
            build.setTestPlanId(Util.getInteger(map, TestLinkResponseParams.testPlanId.toString()));
            build.setName(Util.getString(map, TestLinkResponseParams.name.toString()));
        }
        return build;
    }

    public static final ReportTCResultResponse getReportTCResultResponse(Map<String, Object> map) {
        Integer id;
        Object o;
        ReportTCResultResponse reportTCResultResponse = null;
        if (map != null && map.size() > 0 && (o = map.get(TestLinkResponseParams.id.toString())) != null && (id = Integer.valueOf(Integer.parseInt(o.toString()))) > 0) {
            reportTCResultResponse = new ReportTCResultResponse();
            reportTCResultResponse.setExecutionId(id);
            reportTCResultResponse.setOperation(Util.getString(map, TestLinkResponseParams.operation.toString()));
            reportTCResultResponse.setOverwrite(Util.getBoolean(map, TestLinkResponseParams.overwrite.toString()));
            reportTCResultResponse.setStatus(Util.getBoolean(map, TestLinkResponseParams.status.toString()));
            reportTCResultResponse.setMessage(Util.getString(map, TestLinkResponseParams.message.toString()));
            reportTCResultResponse.setBugIDStatus(Util.getBoolean(map, TestLinkResponseParams.bugIDStatus.toString()));
            reportTCResultResponse.setCustomFieldStatus(Util.getBoolean(map, TestLinkResponseParams.customFieldStatus.toString()));
        }
        return reportTCResultResponse;
    }

    public static final CustomField getCustomField(Map<String, Object> map) {
        CustomField customField = null;
        if (map != null && map.size() > 0) {
            customField = new CustomField();
            customField.setId(Util.getInteger(map, TestLinkResponseParams.id.toString()));
            customField.setDefaultValue(Util.getString(map, TestLinkResponseParams.defaultValue.toString()));
            customField.setDisplayOrder(Util.getInteger(map, TestLinkResponseParams.displayOrder.toString()));
            customField.setEnableOnDesign(Util.getBoolean(map, TestLinkResponseParams.enableOnDesign.toString()));
            customField.setEnableOnExecution(Util.getBoolean(map, TestLinkResponseParams.enableOnExecution.toString()));
            customField.setEnableOnTestPlanDesign(Util.getBoolean(map, TestLinkResponseParams.enableOnTestPlanDesign.toString()));
            customField.setLabel(Util.getString(map, TestLinkResponseParams.label.toString()));
            customField.setLengthMax(Util.getInteger(map, TestLinkResponseParams.lengthMax.toString()));
            customField.setLengthMin(Util.getInteger(map, TestLinkResponseParams.lengthMin.toString()));
            customField.setLocation(Util.getInteger(map, TestLinkResponseParams.location.toString()));
            customField.setName(Util.getString(map, TestLinkResponseParams.name.toString()));
            customField.setPossibleValues(Util.getString(map, TestLinkResponseParams.possibleValues.toString()));
            customField.setShowOnDesign(Util.getBoolean(map, TestLinkResponseParams.showOnDesign.toString()));
            customField.setShowOnExecution(Util.getBoolean(map, TestLinkResponseParams.showOnExecution.toString()));
            customField.setShowOnTestPlanDesign(Util.getBoolean(map, TestLinkResponseParams.showOnTestPlanDesign.toString()));
            customField.setType(Util.getInteger(map, TestLinkResponseParams.type.toString()));
            customField.setValidRegexp(Util.getString(map, TestLinkResponseParams.validRegexp.toString()));
            customField.setValue(Util.getString(map, TestLinkResponseParams.value.toString()));
        }
        return customField;
    }

    public static final void putIfNotNullAndTrue(Map<String, Object> map, String key, Boolean boolValue) {
        if (boolValue != null && boolValue.booleanValue()) {
            map.put(key, 0);
        }
    }

    public static final String getStringValueOrNull(Object o) {
        String value = null;
        if (o != null) {
            value = o.toString();
        }
        return value;
    }
}

