/*
 * Decompiled with CFR 0.152.
 */
package br.eti.kinoshita.testlinkjavaapi;

import br.eti.kinoshita.testlinkjavaapi.BaseService;
import br.eti.kinoshita.testlinkjavaapi.constants.ActionOnDuplicate;
import br.eti.kinoshita.testlinkjavaapi.constants.ExecutionStatus;
import br.eti.kinoshita.testlinkjavaapi.constants.ExecutionType;
import br.eti.kinoshita.testlinkjavaapi.constants.ResponseDetails;
import br.eti.kinoshita.testlinkjavaapi.constants.TestCaseDetails;
import br.eti.kinoshita.testlinkjavaapi.constants.TestCaseStatus;
import br.eti.kinoshita.testlinkjavaapi.constants.TestCaseStepAction;
import br.eti.kinoshita.testlinkjavaapi.constants.TestImportance;
import br.eti.kinoshita.testlinkjavaapi.constants.TestLinkMethods;
import br.eti.kinoshita.testlinkjavaapi.constants.TestLinkParams;
import br.eti.kinoshita.testlinkjavaapi.constants.TestLinkResponseParams;
import br.eti.kinoshita.testlinkjavaapi.constants.TestLinkTables;
import br.eti.kinoshita.testlinkjavaapi.model.Attachment;
import br.eti.kinoshita.testlinkjavaapi.model.CustomField;
import br.eti.kinoshita.testlinkjavaapi.model.ReportTCResultResponse;
import br.eti.kinoshita.testlinkjavaapi.model.TestCase;
import br.eti.kinoshita.testlinkjavaapi.model.TestCaseStep;
import br.eti.kinoshita.testlinkjavaapi.model.TestCaseStepResult;
import br.eti.kinoshita.testlinkjavaapi.util.TestLinkAPIException;
import br.eti.kinoshita.testlinkjavaapi.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TestCaseService
extends BaseService {
    public TestCaseService(XmlRpcClient xmlRpcClient, String devKey) {
        super(xmlRpcClient, devKey);
    }

    protected TestCase createTestCase(String testCaseName, Integer testSuiteId, Integer testProjectId, String authorLogin, String summary, List<TestCaseStep> steps, String preconditions, TestCaseStatus status, TestImportance importance, ExecutionType execution, Integer order, Integer internalId, Boolean checkDuplicatedName, ActionOnDuplicate actionOnDuplicatedName) throws TestLinkAPIException {
        TestCase testCase = null;
        Integer id = null;
        testCase = new TestCase(id, testCaseName, testSuiteId, testProjectId, authorLogin, summary, steps, preconditions, status, importance, execution, null, order, internalId, null, checkDuplicatedName, actionOnDuplicatedName, null, null, null, null, null, null, null);
        try {
            Map<String, Object> executionData = Util.getTestCaseMap(testCase);
            Object response = this.executeXmlRpcCall(TestLinkMethods.CREATE_TEST_CASE.toString(), executionData);
            Object[] responseArray = Util.castToArray(response);
            Map responseMap = (Map)responseArray[0];
            Integer version = (Integer)((HashMap)responseMap.get("additionalInfo")).get("version_number");
            id = Util.getInteger(responseMap, TestLinkResponseParams.ID.toString());
            testCase.setId(id);
            testCase.setVersion(version);
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error creating test plan: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return testCase;
    }

    public Map<String, Object> updateTestCase(TestCase tc) throws TestLinkAPIException {
        try {
            Map responseMap = null;
            Map<String, Object> executionData = Util.getTestCaseMap(tc);
            Object response = this.executeXmlRpcCall(TestLinkMethods.UPDATE_TEST_CASE.toString(), executionData);
            if (response instanceof Object[]) {
                Object[] arr = (Object[])response;
                if (arr.length > 0 && arr[0] instanceof Map) {
                    responseMap = (Map)arr[0];
                }
            } else {
                responseMap = (Map)response;
            }
            return responseMap;
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error updating test case: " + xmlrpcex.getMessage(), xmlrpcex);
        }
    }

    public Map<String, Object> createTestCaseSteps(Integer testCaseId, String testCaseExternalId, Integer version, TestCaseStepAction action, List<TestCaseStep> testCaseSteps) throws TestLinkAPIException {
        Map responseMap = null;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.TEST_CASE_ID.toString(), testCaseId);
            executionData.put(TestLinkParams.TEST_CASE_EXTERNAL_ID.toString(), testCaseExternalId);
            executionData.put(TestLinkParams.VERSION.toString(), version);
            executionData.put(TestLinkParams.ACTION.toString(), action.toString());
            List<Map<String, Object>> steps = Util.getTestCaseStepsMap(testCaseSteps);
            executionData.put(TestLinkParams.STEPS.toString(), steps);
            Object response = this.executeXmlRpcCall(TestLinkMethods.CREATE_TEST_CASE_STEPS.toString(), executionData);
            if (response instanceof Object[]) {
                Object[] arr = (Object[])response;
                if (arr.length > 0 && arr[0] instanceof Map) {
                    responseMap = (Map)arr[0];
                }
            } else {
                responseMap = (Map)response;
            }
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error adding steps to test case: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return responseMap;
    }

    public Map<String, Object> deleteTestCaseSteps(String testCaseExternalId, Integer version, List<TestCaseStep> testCaseSteps) throws TestLinkAPIException {
        Map responseMap = null;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.TEST_CASE_EXTERNAL_ID.toString(), testCaseExternalId);
            executionData.put(TestLinkParams.VERSION.toString(), version);
            List<Integer> steps = Util.getTestCaseStepsIdList(testCaseSteps);
            executionData.put(TestLinkParams.STEPS.toString(), steps);
            Object response = this.executeXmlRpcCall(TestLinkMethods.DELETE_TEST_CASE_STEPS.toString(), executionData);
            responseMap = (Map)response;
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error deleting steps from test case: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return responseMap;
    }

    protected Integer addTestCaseToTestPlan(Integer testProjectId, Integer testPlanId, Integer testCaseId, Integer version, Integer platformId, Integer order, Integer urgency) throws TestLinkAPIException {
        Integer featureId = 0;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.TEST_PROJECT_ID.toString(), testProjectId);
            executionData.put(TestLinkParams.TEST_PLAN_ID.toString(), testPlanId);
            executionData.put(TestLinkParams.TEST_CASE_ID.toString(), testCaseId);
            executionData.put(TestLinkParams.VERSION.toString(), version);
            executionData.put(TestLinkParams.PLATFORM_ID.toString(), platformId);
            executionData.put(TestLinkParams.ORDER.toString(), order);
            executionData.put(TestLinkParams.URGENCY.toString(), urgency);
            Object response = this.executeXmlRpcCall(TestLinkMethods.ADD_TEST_CASE_TO_TEST_PLAN.toString(), executionData);
            Map<String, Object> responseMap = Util.castToMap(response);
            featureId = Util.getInteger(responseMap, TestLinkResponseParams.FEATURE_ID.toString());
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error adding test case to test plan: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return featureId;
    }

    protected TestCase[] getTestCasesForTestSuite(Integer testSuiteId, Boolean deep, TestCaseDetails detail) throws TestLinkAPIException {
        TestCase[] testCases = null;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.TEST_SUITE_ID.toString(), testSuiteId);
            executionData.put(TestLinkParams.DEEP.toString(), deep);
            executionData.put(TestLinkParams.DETAILS.toString(), Util.getStringValueOrNull((Object)detail));
            Object response = this.executeXmlRpcCall(TestLinkMethods.GET_TEST_CASES_FOR_TEST_SUITE.toString(), executionData);
            Object[] responseArray = Util.castToArray(response);
            testCases = new TestCase[responseArray.length];
            for (int i = 0; i < responseArray.length; ++i) {
                Map responseMap = (Map)responseArray[i];
                testCases[i] = Util.getTestCase(responseMap);
            }
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error retrieving test cases for test suite: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return testCases;
    }

    protected TestCase[] getTestCasesForTestPlan(Integer testPlanId, List<Integer> testCasesIds, Integer buildId, List<Integer> keywordsIds, String keywords, Boolean executed, List<Integer> assignedTo, String[] executeStatus, ExecutionType executionType, Boolean getStepInfo, TestCaseDetails detail) throws TestLinkAPIException {
        TestCase[] testCases = null;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.TEST_PLAN_ID.toString(), testPlanId);
            executionData.put(TestLinkParams.TEST_CASE_ID.toString(), testCasesIds);
            executionData.put(TestLinkParams.BUILD_ID.toString(), buildId);
            executionData.put(TestLinkParams.KEYWORD_ID.toString(), keywordsIds);
            executionData.put(TestLinkParams.KEYWORDS.toString(), keywords);
            executionData.put(TestLinkParams.EXECUTED.toString(), executed);
            executionData.put(TestLinkParams.ASSIGNED_TO.toString(), assignedTo);
            executionData.put(TestLinkParams.EXECUTE_STATUS.toString(), executeStatus);
            executionData.put(TestLinkParams.EXECUTION_TYPE.toString(), Util.getStringValueOrNull((Object)executionType));
            executionData.put(TestLinkParams.GET_STEP_INFO.toString(), getStepInfo);
            executionData.put(TestLinkParams.DETAILS.toString(), Util.getStringValueOrNull((Object)detail));
            Object response = this.executeXmlRpcCall(TestLinkMethods.GET_TEST_CASES_FOR_TEST_PLAN.toString(), executionData);
            Map<String, Object> responseMap = Util.castToMap(response);
            ArrayList<TestCase> testCasesList = new ArrayList<TestCase>();
            for (Map.Entry<String, Object> entry : responseMap.entrySet()) {
                String key = entry.getKey();
                Map testCaseMap = null;
                if (entry.getValue() instanceof Object[]) {
                    Object[] responseArray = (Object[])entry.getValue();
                    testCaseMap = (Map)responseArray[0];
                    testCaseMap.put(TestLinkResponseParams.ID.toString(), key);
                    testCasesList.add(Util.getTestCase(testCaseMap));
                    continue;
                }
                if (!(entry.getValue() instanceof Map)) continue;
                testCaseMap = (Map)entry.getValue();
                if (testCaseMap.size() > 0) {
                    Set keys = testCaseMap.keySet();
                    Iterator it = keys.iterator();
                    while (it.hasNext()) {
                        Object o = testCaseMap.get(it.next());
                        if (!(o instanceof Map)) continue;
                        Map testCaseMapTmp = (Map)o;
                        testCaseMapTmp.put(TestLinkResponseParams.ID.toString(), key);
                        testCasesList.add(Util.getTestCase(testCaseMapTmp));
                    }
                    continue;
                }
                testCaseMap.put(TestLinkResponseParams.ID.toString(), key);
                testCasesList.add(Util.getTestCase(testCaseMap));
            }
            testCases = testCasesList.toArray(new TestCase[0]);
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error retrieving test cases for test plan: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return testCases;
    }

    protected TestCase getTestCase(Integer testCaseId, Integer testCaseExternalId, Integer version) throws TestLinkAPIException {
        TestCase testCase = null;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.TEST_CASE_ID.toString(), testCaseId);
            executionData.put(TestLinkParams.TEST_CASE_EXTERNAL_ID.toString(), testCaseExternalId);
            executionData.put(TestLinkParams.VERSION.toString(), version);
            Object response = this.executeXmlRpcCall(TestLinkMethods.GET_TEST_CASE.toString(), executionData);
            Object[] responseArray = Util.castToArray(response);
            Map responseMap = (Map)responseArray[0];
            testCase = Util.getTestCase(responseMap);
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error getting test case info : " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return testCase;
    }

    protected TestCase getTestCaseByExternalId(String fullTestCaseExternalId, Integer version) throws TestLinkAPIException {
        TestCase testCase = null;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.TEST_CASE_EXTERNAL_ID.toString(), fullTestCaseExternalId);
            executionData.put(TestLinkParams.VERSION.toString(), version);
            Object response = this.executeXmlRpcCall(TestLinkMethods.GET_TEST_CASE.toString(), executionData);
            Object[] responseArray = Util.castToArray(response);
            Map responseMap = (Map)responseArray[0];
            testCase = Util.getTestCase(responseMap);
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error getting test case info : " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return testCase;
    }

    protected Integer getTestCaseIDByName(String testCaseName, String testSuiteName, String testProjectName, String testCasePathName) throws TestLinkAPIException {
        Integer testCaseID = null;
        try {
            Map responseMap;
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.TEST_CASE_NAME.toString(), testCaseName);
            executionData.put(TestLinkParams.TEST_SUITE_NAME.toString(), testSuiteName);
            executionData.put(TestLinkParams.TEST_PROJECT_NAME.toString(), testProjectName);
            executionData.put(TestLinkParams.TEST_CASE_PATH_NAME.toString(), testCasePathName);
            Object response = this.executeXmlRpcCall(TestLinkMethods.GET_TEST_CASE_ID_BY_NAME.toString(), executionData);
            if (response instanceof HashMap) {
                HashMap hm = (HashMap)response;
                responseMap = (Map)hm.get(hm.keySet().toArray()[0]);
            } else {
                Object[] responseArray = Util.castToArray(response);
                responseMap = (Map)responseArray[0];
            }
            testCaseID = Util.getInteger(responseMap, TestLinkResponseParams.ID.toString());
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error getting test case ID : " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return testCaseID;
    }

    protected Attachment uploadTestCaseAttachment(Integer testCaseId, String title, String description, String fileName, String fileType, String content) throws TestLinkAPIException {
        Attachment attachment = null;
        Integer id = 0;
        attachment = new Attachment(id, testCaseId, TestLinkTables.NODES_HIERARCHY.toString(), title, description, fileName, null, fileType, content);
        try {
            Map<String, Object> executionData = Util.getTestCaseAttachmentMap(attachment);
            Object response = this.executeXmlRpcCall(TestLinkMethods.UPLOAD_TEST_CASE_ATTACHMENT.toString(), executionData);
            Map<String, Object> responseMap = Util.castToMap(response);
            id = Util.getInteger(responseMap, TestLinkResponseParams.ID.toString());
            attachment.setId(id);
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error uploading attachment for test case: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return attachment;
    }

    protected Attachment[] getTestCaseAttachments(Integer testCaseId, Integer testCaseVersion, Integer testCaseExternalId) throws TestLinkAPIException {
        Attachment[] attachments = null;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.TEST_CASE_ID.toString(), testCaseId);
            executionData.put(TestLinkParams.VERSION.toString(), testCaseVersion);
            executionData.put(TestLinkParams.TEST_CASE_EXTERNAL_ID.toString(), testCaseExternalId);
            Object response = this.executeXmlRpcCall(TestLinkMethods.GET_TEST_CASE_ATTACHMENTS.toString(), executionData);
            if (response instanceof Map) {
                Map<String, Object> responseMap = Util.castToMap(response);
                Set<Map.Entry<String, Object>> entrySet = responseMap.entrySet();
                attachments = new Attachment[entrySet.size()];
                int index = 0;
                for (Map.Entry<String, Object> entry : entrySet) {
                    String key = entry.getKey();
                    Map attachmentMap = (Map)entry.getValue();
                    attachmentMap.put(TestLinkResponseParams.ID.toString(), key);
                    attachments[index] = Util.getAttachment(attachmentMap);
                    ++index;
                }
            } else {
                attachments = new Attachment[]{};
            }
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error retrieving test case's attachments: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return attachments;
    }

    protected Attachment uploadExecutionAttachment(Integer executionId, String title, String description, String fileName, String fileType, String content) throws TestLinkAPIException {
        Attachment attachment = null;
        Integer id = 0;
        attachment = new Attachment(id, executionId, TestLinkTables.EXECUTIONS.toString(), title, description, fileName, null, fileType, content);
        try {
            Map<String, Object> executionData = Util.getExecutionAttachmentMap(attachment);
            Object response = this.executeXmlRpcCall(TestLinkMethods.UPLOAD_EXECUTION_ATTACHMENT.toString(), executionData);
            Map<String, Object> responseMap = Util.castToMap(response);
            id = Util.getInteger(responseMap, TestLinkResponseParams.ID.toString());
            attachment.setId(id);
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error uploading attachment for execution: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return attachment;
    }

    protected void deleteExecution(Integer executionId) throws TestLinkAPIException {
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.EXECUTION_ID.toString(), executionId);
            this.executeXmlRpcCall(TestLinkMethods.DELETE_EXECUTION.toString(), executionData);
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error deleting execution: " + xmlrpcex.getMessage(), xmlrpcex);
        }
    }

    protected ReportTCResultResponse reportTCResult(Integer testCaseId, Integer testCaseExternalId, Integer testPlanId, ExecutionStatus status, List<TestCaseStepResult> steps, Integer buildId, String buildName, String notes, Boolean guess, String bugId, Integer platformId, String platformName, Map<String, String> customFields, Boolean overwrite) throws TestLinkAPIException {
        ReportTCResultResponse reportTCResultResponse = null;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.TEST_CASE_ID.toString(), testCaseId);
            executionData.put(TestLinkParams.TEST_CASE_EXTERNAL_ID.toString(), testCaseExternalId);
            executionData.put(TestLinkParams.TEST_PLAN_ID.toString(), testPlanId);
            executionData.put(TestLinkParams.STATUS.toString(), status.toString());
            executionData.put(TestLinkParams.STEPS.toString(), steps);
            executionData.put(TestLinkParams.BUILD_ID.toString(), buildId);
            executionData.put(TestLinkParams.BUILD_NAME.toString(), buildName);
            executionData.put(TestLinkParams.NOTES.toString(), notes);
            executionData.put(TestLinkParams.GUESS.toString(), guess);
            executionData.put(TestLinkParams.BUG_ID.toString(), bugId);
            executionData.put(TestLinkParams.PLATFORM_ID.toString(), platformId);
            executionData.put(TestLinkParams.PLATFORM_NAME.toString(), platformName);
            executionData.put(TestLinkParams.CUSTOM_FIELDS.toString(), customFields);
            executionData.put(TestLinkParams.OVERWRITE.toString(), overwrite);
            Object response = this.executeXmlRpcCall(TestLinkMethods.REPORT_TC_RESULT.toString(), executionData);
            if (response instanceof Object[]) {
                Object[] responseArray = Util.castToArray(response);
                Map responseMap = (Map)responseArray[0];
                reportTCResultResponse = Util.getReportTCResultResponse(responseMap);
            }
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error reporting TC result: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return reportTCResultResponse;
    }

    protected CustomField getTestCaseCustomFieldDesignValue(Integer testCaseId, Integer testCaseExternalId, Integer versionNumber, Integer testProjectId, String customFieldName, ResponseDetails details) throws TestLinkAPIException {
        CustomField customField = null;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.TEST_CASE_ID.toString(), testCaseId);
            executionData.put(TestLinkParams.TEST_CASE_EXTERNAL_ID.toString(), testCaseExternalId);
            executionData.put(TestLinkParams.VERSION.toString(), versionNumber);
            executionData.put(TestLinkParams.TEST_PROJECT_ID.toString(), testProjectId);
            executionData.put(TestLinkParams.CUSTOM_FIELD_NAME.toString(), customFieldName);
            executionData.put(TestLinkParams.DETAILS.toString(), Util.getStringValueOrNull((Object)details));
            Object response = this.executeXmlRpcCall(TestLinkMethods.GET_TEST_CASE_CUSTOM_FIELD_DESIGN_VALUE.toString(), executionData);
            if (response instanceof String) {
                customField = new CustomField();
                customField.setValue(response.toString());
            } else if (response instanceof Map) {
                Map<String, Object> responseMap = Util.castToMap(response);
                customField = Util.getCustomField(responseMap);
            }
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error retrieving test case custom field value: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return customField;
    }

    protected CustomField getTestCaseCustomFieldTestPlanDesignValue(Integer testCaseId, Integer testCaseExternalId, Integer versionNumber, Integer testProjectId, String customFieldName, ResponseDetails details) throws TestLinkAPIException {
        CustomField customField = null;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.TEST_CASE_ID.toString(), testCaseId);
            executionData.put(TestLinkParams.TEST_CASE_EXTERNAL_ID.toString(), testCaseExternalId);
            executionData.put(TestLinkParams.VERSION.toString(), versionNumber);
            executionData.put(TestLinkParams.TEST_PROJECT_ID.toString(), testProjectId);
            executionData.put(TestLinkParams.CUSTOM_FIELD_NAME.toString(), customFieldName);
            executionData.put(TestLinkParams.DETAILS.toString(), Util.getStringValueOrNull((Object)details));
            Object response = this.executeXmlRpcCall(TestLinkMethods.GET_TEST_CASE_CUSTOM_FIELD_TEST_PLAN_DESIGN_VALUE.toString(), executionData);
            if (response instanceof String) {
                customField = new CustomField();
                customField.setValue(response.toString());
            } else if (response instanceof Map) {
                Map<String, Object> responseMap = Util.castToMap(response);
                customField = Util.getCustomField(responseMap);
            }
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error retrieving test case custom field value: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return customField;
    }

    protected CustomField getTestCaseCustomFieldExecutionValue(Integer testCaseId, Integer testCaseExternalId, Integer versionNumber, Integer executionId, Integer testPlanId, Integer testProjectId, String customFieldName, ResponseDetails details) throws TestLinkAPIException {
        CustomField customField = null;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.TEST_CASE_ID.toString(), testCaseId);
            executionData.put(TestLinkParams.TEST_CASE_EXTERNAL_ID.toString(), testCaseExternalId);
            executionData.put(TestLinkParams.VERSION.toString(), versionNumber);
            executionData.put(TestLinkParams.TEST_PLAN_ID.toString(), testPlanId);
            executionData.put(TestLinkParams.TEST_PROJECT_ID.toString(), testProjectId);
            executionData.put(TestLinkParams.CUSTOM_FIELD_NAME.toString(), customFieldName);
            executionData.put(TestLinkParams.DETAILS.toString(), Util.getStringValueOrNull((Object)details));
            executionData.put(TestLinkParams.EXECUTION_ID.toString(), executionId);
            Object response = this.executeXmlRpcCall(TestLinkMethods.GET_TEST_CASE_CUSTOM_FIELD_EXECUTION_VALUE.toString(), executionData);
            if (response instanceof String) {
                customField = new CustomField();
                customField.setValue(response.toString());
            } else if (response instanceof Map) {
                Map<String, Object> responseMap = Util.castToMap(response);
                customField = Util.getCustomField(responseMap);
            }
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error retrieving test case custom field value: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return customField;
    }

    protected List<String> getTestCaseKeywords(Integer testProjectId, Integer testCaseId) throws TestLinkAPIException {
        ArrayList<String> keywords = new ArrayList<String>();
        try {
            Object[] responseArray;
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.TEST_PROJECT_ID.toString(), testProjectId);
            executionData.put(TestLinkParams.TEST_CASE_ID.toString(), testCaseId);
            Object response = this.executeXmlRpcCall(TestLinkMethods.GET_TEST_CASE_KEYWORDS.toString(), executionData);
            for (Object keywordObject : responseArray = (Object[])response) {
                Map keywordMap = (Map)keywordObject;
                keywords.add((String)keywordMap.get("keyword"));
            }
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error getting test case info : " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return keywords;
    }

    protected Map<String, Object> setTestCaseExecutionType(Integer testProjectId, Integer testCaseId, Integer testCaseExternalId, Integer versionNumber, ExecutionType executionType) {
        Map<String, Object> responseMap = null;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.TEST_CASE_EXTERNAL_ID.toString(), testCaseExternalId);
            executionData.put(TestLinkParams.TEST_CASE_ID.toString(), testCaseId);
            executionData.put(TestLinkParams.VERSION.toString(), versionNumber);
            executionData.put(TestLinkParams.TEST_PROJECT_ID.toString(), testProjectId);
            executionData.put(TestLinkParams.EXECUTION_TYPE.toString(), Util.getStringValueOrNull((Object)executionType));
            Object response = this.executeXmlRpcCall(TestLinkMethods.SET_TEST_CASE_EXECUTION_TYPE.toString(), executionData);
            responseMap = response instanceof Map ? Util.castToMap(response) : Util.castToMap(((Object[])response)[0]);
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error retrieving test case custom field value: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return responseMap;
    }

    protected Map<String, Object> updateTestCaseCustomFieldDesignValue(Integer testCaseId, Integer versionNumber, Integer testProjectId, String customFieldName, String customFieldValue) {
        Map<String, Object> responseMap = null;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            HashMap<String, String> cf = new HashMap<String, String>();
            cf.put(customFieldName, customFieldValue);
            executionData.put(TestLinkParams.TEST_CASE_ID.toString(), testCaseId);
            executionData.put(TestLinkParams.VERSION.toString(), versionNumber);
            executionData.put(TestLinkParams.TEST_PROJECT_ID.toString(), testProjectId);
            executionData.put(TestLinkParams.CUSTOM_FIELDS.toString(), cf);
            Object response = this.executeXmlRpcCall(TestLinkMethods.UPDATE_TEST_CASE_CUSTOM_FIELD_VALUE.toString(), executionData);
            if (response instanceof Map) {
                responseMap = Util.castToMap(response);
            } else if (!(response instanceof String)) {
                responseMap = Util.castToMap(((Object[])response)[0]);
            }
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error updating test case custom field value. " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return responseMap;
    }

    protected void assignTestCaseExecutionTask(Integer testPlanId, String testCaseExternalId, String user, String buildName) throws TestLinkAPIException {
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.TEST_PLAN_ID.toString(), testPlanId);
            executionData.put(TestLinkParams.TEST_CASE_EXTERNAL_ID.toString(), testCaseExternalId);
            executionData.put(TestLinkParams.USER.toString(), user);
            executionData.put(TestLinkParams.BUILD_NAME.toString(), buildName);
            this.executeXmlRpcCall(TestLinkMethods.ASSIGN_TEST_CASE_EXECUTION_TASK.toString(), executionData);
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error deleting execution: " + xmlrpcex.getMessage(), xmlrpcex);
        }
    }
}

