/*
 * Decompiled with CFR 0.152.
 */
package br.eti.kinoshita.testlinkjavaapi.util;

import br.eti.kinoshita.testlinkjavaapi.util.CustomLoggingUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcCommonsTransport;
import org.apache.xmlrpc.client.XmlRpcCommonsTransportFactory;
import org.apache.xmlrpc.client.XmlRpcStreamTransport;
import org.apache.xmlrpc.client.XmlRpcTransport;

public class CustomXmlRpcCommonsTransportFactory
extends XmlRpcCommonsTransportFactory {
    private final Logger logger = Logger.getLogger(CustomXmlRpcCommonsTransportFactory.class.getPackage().getName());

    public CustomXmlRpcCommonsTransportFactory(XmlRpcClient pClient) {
        super(pClient);
    }

    public XmlRpcTransport getTransport() {
        return new LoggingTransport(this);
    }

    private class LoggingTransport
    extends XmlRpcCommonsTransport {
        public LoggingTransport(CustomXmlRpcCommonsTransportFactory pFactory) {
            super((XmlRpcCommonsTransportFactory)pFactory);
        }

        protected void writeRequest(XmlRpcStreamTransport.ReqWriter pWriter) throws XmlRpcException {
            super.writeRequest(pWriter);
            if (CustomXmlRpcCommonsTransportFactory.this.logger.isLoggable(Level.FINE)) {
                CustomLoggingUtils.logRequest(CustomXmlRpcCommonsTransportFactory.this.logger, this.method.getRequestEntity());
            }
        }

        protected InputStream getInputStream() throws XmlRpcException {
            InputStream istream = super.getInputStream();
            if (CustomXmlRpcCommonsTransportFactory.this.logger.isLoggable(Level.FINE)) {
                return new ByteArrayInputStream(CustomLoggingUtils.logResponse(CustomXmlRpcCommonsTransportFactory.this.logger, istream).getBytes());
            }
            return istream;
        }
    }
}

