/*
 * Decompiled with CFR 0.152.
 */
package br.eti.kinoshita.testlinkjavaapi;

import br.eti.kinoshita.testlinkjavaapi.BaseService;
import br.eti.kinoshita.testlinkjavaapi.constants.TestLinkMethods;
import br.eti.kinoshita.testlinkjavaapi.constants.TestLinkParams;
import br.eti.kinoshita.testlinkjavaapi.constants.TestLinkResponseParams;
import br.eti.kinoshita.testlinkjavaapi.constants.TestLinkTables;
import br.eti.kinoshita.testlinkjavaapi.model.Attachment;
import br.eti.kinoshita.testlinkjavaapi.model.Requirement;
import br.eti.kinoshita.testlinkjavaapi.util.TestLinkAPIException;
import br.eti.kinoshita.testlinkjavaapi.util.Util;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;

class RequirementService
extends BaseService {
    RequirementService(XmlRpcClient xmlRpcClient, String devKey) {
        super(xmlRpcClient, devKey);
    }

    protected Attachment uploadRequirementAttachment(Integer requirementId, String title, String description, String fileName, String fileType, String content) throws TestLinkAPIException {
        Attachment attachment = null;
        Integer id = 0;
        attachment = new Attachment(id, requirementId, TestLinkTables.REQUIREMENTS.toString(), title, description, fileName, null, fileType, content);
        try {
            Map<String, Object> executionData = Util.getRequirementAttachmentMap(attachment);
            Object response = this.executeXmlRpcCall(TestLinkMethods.UPLOAD_REQUIREMENT_ATTACHMENT.toString(), executionData);
            Map responseMap = (Map)response;
            id = Util.getInteger(responseMap, TestLinkResponseParams.ID.toString());
            attachment.setId(id);
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error uploading attachment for requirement: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return attachment;
    }

    protected void assignRequirements(Integer testCaseId, Integer testProjectId, List<Requirement> requirements) throws TestLinkAPIException {
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.TEST_CASE_ID.toString(), testCaseId);
            executionData.put(TestLinkParams.TEST_PROJECT_ID.toString(), testProjectId);
            executionData.put(TestLinkParams.REQUIREMENTS.toString(), Util.getRequirementsGroupedByReqSpecMap(requirements));
            this.executeXmlRpcCall(TestLinkMethods.ASSIGN_REQUIREMENTS.toString(), executionData);
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error assigning requirement for test case: " + xmlrpcex.getMessage(), xmlrpcex);
        }
    }
}

