/*
 * Decompiled with CFR 0.152.
 */
package br.eti.kinoshita.testlinkjavaapi;

import br.eti.kinoshita.testlinkjavaapi.BaseService;
import br.eti.kinoshita.testlinkjavaapi.TestLinkAPIException;
import br.eti.kinoshita.testlinkjavaapi.model.Attachment;
import br.eti.kinoshita.testlinkjavaapi.model.Execution;
import br.eti.kinoshita.testlinkjavaapi.model.TestLinkMethods;
import br.eti.kinoshita.testlinkjavaapi.model.TestLinkParams;
import br.eti.kinoshita.testlinkjavaapi.model.TestLinkResponseParams;
import br.eti.kinoshita.testlinkjavaapi.util.Util;
import java.util.HashMap;
import java.util.Map;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;

class MiscService
extends BaseService {
    public MiscService(XmlRpcClient xmlRpcClient, String devKey) {
        super(xmlRpcClient, devKey);
    }

    protected Boolean checkDevKey(String devKey) throws TestLinkAPIException {
        Boolean statusOk = false;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.devKey.toString(), devKey);
            Object response = this.executeXmlRpcCall(TestLinkMethods.checkDevKey.toString(), executionData);
            statusOk = Boolean.valueOf(response.toString());
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error verifying developer key: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return statusOk;
    }

    protected Boolean doesUserExist(String user) throws TestLinkAPIException {
        Boolean userExist = false;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.user.toString(), user);
            Object response = this.executeXmlRpcCall(TestLinkMethods.doesUserExist.toString(), executionData);
            userExist = Boolean.valueOf(response.toString());
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error verifying if user exists: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return userExist;
    }

    protected String sayHello() throws TestLinkAPIException {
        String message = null;
        try {
            Object response = this.executeXmlRpcCall(TestLinkMethods.sayHello.toString(), null);
            message = (String)response;
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error saying hello: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return message;
    }

    protected String about() throws TestLinkAPIException {
        String message = null;
        try {
            Object response = this.executeXmlRpcCall(TestLinkMethods.about.toString(), null);
            message = (String)response;
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error in about method: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return message;
    }

    protected Boolean setTestMode(Boolean testMode) throws TestLinkAPIException {
        Boolean result = null;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.testMode.toString(), testMode);
            Object response = this.executeXmlRpcCall(TestLinkMethods.setTestMode.toString(), executionData);
            result = (Boolean)response;
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error setting test mode: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return result;
    }

    protected String repeat(String str) throws TestLinkAPIException {
        String repeatMessage = null;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.str.toString(), str);
            Object response = this.executeXmlRpcCall(TestLinkMethods.repeat.toString(), executionData);
            repeatMessage = (String)response;
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error setting test mode: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return repeatMessage;
    }

    protected Attachment uploadAttachment(Integer fkId, String fkTable, String title, String description, String fileName, String fileType, String content) throws TestLinkAPIException {
        Attachment attachment = null;
        Integer id = 0;
        attachment = new Attachment(id, fkId, fkTable, title, description, fileName, null, fileType, content);
        try {
            Map<String, Object> executionData = Util.getAttachmentMap(attachment);
            Object response = this.executeXmlRpcCall(TestLinkMethods.uploadAttachment.toString(), executionData);
            Map responseMap = (Map)response;
            id = Util.getInteger(responseMap, TestLinkResponseParams.id.toString());
            attachment.setId(id);
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error uploading attachment: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return attachment;
    }

    protected String[] getFullPath(Integer nodeId) throws TestLinkAPIException {
        String[] names = null;
        try {
            Map responseMap;
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.nodeId.toString(), nodeId);
            Object response = this.executeXmlRpcCall(TestLinkMethods.getFullPath.toString(), executionData);
            if (response instanceof Map && (responseMap = (Map)response).size() > 0) {
                Object value = responseMap.get(nodeId.toString());
                Object[] values = (Object[])value;
                names = new String[values.length];
                for (int i = 0; i < values.length; ++i) {
                    names[i] = values[i].toString();
                }
            }
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error uploading attachment: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return names;
    }

    protected Execution getLastExecutionResult(Integer testPlanId, Integer testCaseId, Integer testCaseExternalId) throws TestLinkAPIException {
        Execution execution = null;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.testPlanId.toString(), testPlanId);
            executionData.put(TestLinkParams.testCaseId.toString(), testCaseId);
            executionData.put(TestLinkParams.testCaseExternalId.toString(), testCaseExternalId);
            Object response = this.executeXmlRpcCall(TestLinkMethods.getLastExecutionResult.toString(), executionData);
            Object[] responseArray = Util.castToArray(response);
            Map responseMap = (Map)responseArray[0];
            if (responseMap instanceof Map && responseMap.size() > 0) {
                execution = Util.getExecution(responseMap);
            }
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error retrieving last execution result: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return execution;
    }
}

