/*
 * Decompiled with CFR 0.152.
 */
package br.eti.kinoshita.testlinkjavaapi;

import br.eti.kinoshita.testlinkjavaapi.BaseService;
import br.eti.kinoshita.testlinkjavaapi.TestLinkAPIException;
import br.eti.kinoshita.testlinkjavaapi.model.Attachment;
import br.eti.kinoshita.testlinkjavaapi.model.TestLinkMethods;
import br.eti.kinoshita.testlinkjavaapi.model.TestLinkParams;
import br.eti.kinoshita.testlinkjavaapi.model.TestLinkResponseParams;
import br.eti.kinoshita.testlinkjavaapi.model.TestLinkTables;
import br.eti.kinoshita.testlinkjavaapi.model.TestPlan;
import br.eti.kinoshita.testlinkjavaapi.model.TestProject;
import br.eti.kinoshita.testlinkjavaapi.util.Util;
import java.util.HashMap;
import java.util.Map;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;

class TestProjectService
extends BaseService {
    public TestProjectService(XmlRpcClient xmlRpcClient, String devKey) {
        super(xmlRpcClient, devKey);
    }

    protected TestProject createTestProject(String testProjectName, String testProjectPrefix, String notes, Boolean enableRequirements, Boolean enableTestPriority, Boolean enableAutomation, Boolean enableInventory, Boolean isActive, Boolean isPublic) throws TestLinkAPIException {
        TestProject testProject = null;
        Integer id = 0;
        testProject = new TestProject(id, testProjectName, testProjectPrefix, notes, enableRequirements, enableTestPriority, enableAutomation, enableInventory, isActive, isPublic);
        try {
            Map<String, Object> executionData = Util.getTestProjectMap(testProject);
            Object response = this.executeXmlRpcCall(TestLinkMethods.createTestProject.toString(), executionData);
            Object[] responseArray = Util.castToArray(response);
            Map responseMap = (Map)responseArray[0];
            id = Util.getInteger(responseMap, TestLinkResponseParams.id.toString());
            testProject.setId(id);
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error creating test project: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return testProject;
    }

    protected TestProject getTestProjectByName(String projectName) throws TestLinkAPIException {
        TestProject testProject = null;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.testProjectName.toString(), projectName);
            Object response = this.executeXmlRpcCall(TestLinkMethods.getTestProjectByName.toString(), executionData);
            Object[] responseArray = Util.castToArray(response);
            Map responseMap = (Map)responseArray[0];
            testProject = Util.getTestProject(responseMap);
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error retrieving test project: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return testProject;
    }

    protected TestProject[] getProjects() throws TestLinkAPIException {
        TestProject[] projects = null;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            Object response = this.executeXmlRpcCall(TestLinkMethods.getProjects.toString(), executionData);
            Object[] responseArray = Util.castToArray(response);
            projects = new TestProject[responseArray.length];
            for (int i = 0; i < responseArray.length; ++i) {
                TestProject testProject;
                Map projectMap = (Map)responseArray[i];
                projects[i] = testProject = Util.getTestProject(projectMap);
            }
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error retrieving test projects: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return projects;
    }

    protected TestPlan[] getProjectTestPlans(Integer projectId) throws TestLinkAPIException {
        TestPlan[] testPlans = null;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.testProjectId.toString(), projectId);
            Object response = this.executeXmlRpcCall(TestLinkMethods.getProjectTestPlans.toString(), executionData);
            Object[] responseArray = Util.castToArray(response);
            testPlans = new TestPlan[responseArray.length];
            for (int i = 0; i < responseArray.length; ++i) {
                TestPlan testPlan;
                Map planMap = (Map)responseArray[i];
                testPlans[i] = testPlan = Util.getTestPlan(planMap);
            }
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error retrieving test plans: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return testPlans;
    }

    protected Attachment uploadTestProjectAttachment(Integer testProjectId, String title, String description, String fileName, String fileType, String content) throws TestLinkAPIException {
        Attachment attachment = null;
        Integer id = 0;
        attachment = new Attachment(id, testProjectId, TestLinkTables.nodesHierarchy.toString(), title, description, fileName, null, fileType, content);
        try {
            Map<String, Object> executionData = Util.getTestProjectAttachmentMap(attachment);
            Object response = this.executeXmlRpcCall(TestLinkMethods.uploadTestProjectAttachment.toString(), executionData);
            Map responseMap = (Map)response;
            id = Util.getInteger(responseMap, TestLinkResponseParams.id.toString());
            attachment.setId(id);
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error uploading attachment for test project: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return attachment;
    }
}

