/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.behave.runner.fest;

import br.gov.frameworkdemoiselle.behave.annotation.ElementMap;
import br.gov.frameworkdemoiselle.behave.config.BehaveConfig;
import br.gov.frameworkdemoiselle.behave.exception.BehaveException;
import br.gov.frameworkdemoiselle.behave.internal.spi.InjectionManager;
import br.gov.frameworkdemoiselle.behave.internal.util.ReflectionUtil;
import br.gov.frameworkdemoiselle.behave.message.BehaveMessage;
import br.gov.frameworkdemoiselle.behave.runner.Runner;
import br.gov.frameworkdemoiselle.behave.runner.fest.FestStartup;
import br.gov.frameworkdemoiselle.behave.runner.fest.annotation.ElementIndex;
import br.gov.frameworkdemoiselle.behave.runner.fest.util.DesktopElement;
import br.gov.frameworkdemoiselle.behave.runner.fest.util.DesktopReflectionUtil;
import br.gov.frameworkdemoiselle.behave.runner.ui.Element;
import br.gov.frameworkdemoiselle.behave.runner.ui.Screen;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.GregorianCalendar;
import javax.imageio.ImageIO;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.apache.log4j.Logger;
import org.fest.swing.core.BasicComponentPrinter;
import org.fest.swing.core.ComponentPrinter;
import org.fest.swing.core.Robot;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.fixture.FrameFixture;
import org.fest.swing.image.ScreenshotTaker;

public class FestRunner
implements Runner {
    public static String MESSAGEBUNDLE = "demoiselle-runner-fest-bundle";
    private Logger logger = Logger.getLogger((String)this.toString());
    private BehaveMessage message = new BehaveMessage(MESSAGEBUNDLE);
    public Robot robot;
    public JFrame mainFrame;
    public Container mainContainer;
    public Container currentContainer;
    public FrameFixture mainFixture;
    public String currentTitle;

    public void start() {
        this.logger.info((Object)this.message.getString("message-fest-started"));
        if (this.mainFrame == null) {
            this.mainFrame = this.getInstance(true);
            if (this.mainFrame == null) {
                this.mainFrame = this.getInstance(false);
            }
            if (this.mainFrame == null) {
                throw new BehaveException(this.message.getString("exception-properties-not-informed"));
            }
            JFrame frame = (JFrame)GuiActionRunner.execute((GuiQuery)new GuiQuery<JFrame>(){

                protected JFrame executeInEDT() {
                    return FestRunner.this.mainFrame;
                }
            });
            this.mainContainer = frame;
            this.mainContainer.setVisible(true);
            this.mainFixture = new FrameFixture((Frame)((JFrame)this.mainContainer));
            this.robot = this.mainFixture.robot;
        }
        this.currentContainer = this.mainContainer;
    }

    private JFrame getInstance(boolean mainClass) {
        String clazz = mainClass ? BehaveConfig.getProperty((String)"behave.runner.app.mainClass") : BehaveConfig.getProperty((String)"behave.runner.app.startupFrame");
        try {
            if (clazz == null || clazz.equals("")) {
                return null;
            }
            this.logger.info((Object)this.message.getString("message-fest-class", new Object[]{clazz}));
            Object instance = Class.forName(clazz).newInstance();
            if (mainClass) {
                return (JFrame)instance;
            }
            return ((FestStartup)instance).getFrame();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void get(String url) {
    }

    public void navigateTo(String title) {
        for (Window w : JDialog.getWindows()) {
            if (!(w instanceof JDialog) || !w.isVisible() || !title.trim().equalsIgnoreCase(((JDialog)w).getTitle().trim())) continue;
            this.currentContainer = ((JDialog)w).getRootPane().getContentPane();
            this.currentContainer.setFocusTraversalKeysEnabled(true);
            this.currentContainer.setVisible(true);
            this.currentContainer.setEnabled(true);
            this.currentTitle = title;
            this.logger.debug((Object)this.message.getString("message-navigate-dialod", new Object[]{title}));
            return;
        }
        for (Window w : JFrame.getWindows()) {
            if (!(w instanceof JFrame) || !w.isVisible()) continue;
            JFrame frame = (JFrame)w;
            if (!title.trim().equalsIgnoreCase(frame.getTitle().trim())) continue;
            this.currentContainer = frame;
            this.currentContainer.setFocusTraversalKeysEnabled(true);
            this.currentContainer.setVisible(true);
            this.currentContainer.setEnabled(true);
            this.currentTitle = title;
            this.logger.debug((Object)this.message.getString("message-navigate-dialod", new Object[]{title}));
            return;
        }
        if (this.currentContainer == null) {
            throw new BehaveException(this.message.getString("exception-app-not-loaded"));
        }
        throw new BehaveException(this.message.getString("exception-screen-not-found", new Object[]{this.currentContainer.toString(), this.getHierarchy()}));
    }

    public String getHierarchy() {
        ComponentPrinter printer = BasicComponentPrinter.printerWithCurrentAwtHierarchy();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(out, true);
        printer.printComponents(printStream, this.currentContainer);
        printStream.flush();
        return new String(out.toByteArray());
    }

    public String getCurrentUrl() {
        return this.currentTitle;
    }

    public String getTitle() {
        return this.currentTitle;
    }

    public Element getElement(String currentPageName, String elementName) {
        if (currentPageName == null || currentPageName.equals("")) {
            throw new RuntimeException("N\u00e3o existe tela selecionada.");
        }
        Field f = ReflectionUtil.getElementMap((String)currentPageName, (String)elementName);
        ElementMap map = f.getAnnotation(ElementMap.class);
        ElementIndex index = DesktopReflectionUtil.getElementIndex(currentPageName, elementName);
        Class<?> clazz = f.getType();
        DesktopElement element = null;
        if (clazz.isInterface()) {
            element = (DesktopElement)InjectionManager.getInstance().getInstanceDependecyWithoutProxy(clazz);
        } else if (Element.class.isAssignableFrom(clazz)) {
            try {
                element = (DesktopElement)clazz.newInstance();
            }
            catch (Exception e) {
                element = null;
            }
        } else {
            throw new BehaveException(this.message.getString("exception-class-not-element", new Object[]{clazz.getName(), elementName, currentPageName}));
        }
        if (element == null) {
            throw new BehaveException(this.message.getString("exception-error-create-element", new Object[]{elementName, currentPageName}));
        }
        element.setElementMap(map);
        element.setElementIndex(index);
        return element;
    }

    public String getPageSource() {
        return null;
    }

    public void close() {
    }

    public void quit() {
        this.mainFixture.cleanUp();
        this.mainContainer = null;
        this.currentContainer = null;
        this.mainFrame = null;
    }

    public Object getDriver() {
        return this.robot;
    }

    public Screen getScreen() {
        return (Screen)InjectionManager.getInstance().getInstanceDependecy(Screen.class);
    }

    public File saveScreenshot() {
        File screenshotFile = new File(System.getProperty("java.io.tmpdir") + File.separator + GregorianCalendar.getInstance().getTimeInMillis() + ".png");
        screenshotFile.getParentFile().mkdirs();
        ScreenshotTaker screenshotTaker = new ScreenshotTaker();
        screenshotTaker.saveDesktopAsPng(screenshotFile.getAbsolutePath());
        if (this.currentContainer != null) {
            this.reSize(this.currentContainer, screenshotFile.getAbsolutePath());
        }
        return screenshotFile;
    }

    public File saveScreenshotTo(String fileName) {
        return this.saveScreenshotTo(fileName, true);
    }

    public File saveScreenshotTo(String fileName, boolean generateSource) {
        File screenshotFile = new File(fileName);
        screenshotFile.getParentFile().mkdirs();
        ScreenshotTaker screenshotTaker = new ScreenshotTaker();
        screenshotTaker.saveDesktopAsPng(screenshotFile.getAbsolutePath());
        if (this.currentContainer != null) {
            this.reSize(this.currentContainer, screenshotFile.getAbsolutePath());
        }
        return screenshotFile;
    }

    private void reSize(Container w, String filePath) {
        try {
            double scale = 1.0;
            String extension = filePath.substring(filePath.lastIndexOf(".") + 1);
            BufferedImage img = ImageIO.read(new File(filePath));
            img = img.getSubimage(w.getX(), w.getY(), w.getWidth(), w.getHeight());
            BufferedImage bi = new BufferedImage((int)(scale * (double)img.getWidth()), (int)(scale * (double)img.getHeight()), 1);
            Graphics2D grph = (Graphics2D)bi.getGraphics();
            grph.scale(scale, scale);
            grph.drawImage((Image)img, 0, 0, null);
            grph.dispose();
            ImageIO.write((RenderedImage)bi, extension, new File(filePath));
        }
        catch (Exception ex) {
            throw new BehaveException(this.message.getString("exception-error-resize-image", new Object[]{filePath}));
        }
    }

    public void setScreen(String screenName) {
    }
}

