/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.behave.runner.fest.ui;

import br.gov.frameworkdemoiselle.behave.annotation.ElementLocatorType;
import br.gov.frameworkdemoiselle.behave.config.BehaveConfig;
import br.gov.frameworkdemoiselle.behave.exception.BehaveException;
import br.gov.frameworkdemoiselle.behave.message.BehaveMessage;
import br.gov.frameworkdemoiselle.behave.runner.fest.FestRunner;
import br.gov.frameworkdemoiselle.behave.runner.fest.util.DesktopMappedElement;
import br.gov.frameworkdemoiselle.behave.runner.ui.BaseUI;
import java.awt.Component;
import java.lang.reflect.Method;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.fest.swing.core.BasicComponentFinder;
import org.fest.swing.core.ComponentFinder;
import org.fest.swing.core.ComponentMatcher;

public class DesktopBase
extends DesktopMappedElement
implements BaseUI {
    protected BehaveMessage message = new BehaveMessage(FestRunner.MESSAGEBUNDLE);
    private Logger log = Logger.getLogger(DesktopBase.class);
    protected FestRunner runner = (FestRunner)this.getRunner();

    public Component getElement() {
        this.waitThreadSleep(BehaveConfig.getRunner_ScreenMinWait());
        ComponentFinder cf = BasicComponentFinder.finderWithCurrentAwtHierarchy();
        Collection findedComponents = cf.findAll(this.runner.currentContainer, new ComponentMatcher(){

            public boolean matches(Component c) {
                return DesktopBase.this.matcher(c);
            }
        });
        this.log.debug((Object)this.message.getString("message-elements-found", new Object[]{findedComponents.size(), this.runner.getTitle(), this.getElementMap().locator()[0]}));
        if (findedComponents.size() == 0) {
            throw new BehaveException(this.message.getString("exception-elements-not-found", new Object[]{this.runner.currentContainer.toString(), this.runner.getHierarchy()}));
        }
        if (findedComponents.size() > 1) {
            return (Component)findedComponents.toArray()[this.getElementIndex().index()];
        }
        return (Component)findedComponents.toArray()[0];
    }

    private boolean matcher(Component component) {
        String locator = this.getLocatorWithParameters(this.getElementMap().locator()[0]);
        ElementLocatorType locatorType = this.getElementMap().locatorType();
        if (component instanceof JButton) {
            JButton button = (JButton)component;
            switch (locatorType) {
                case Name: {
                    if (button.getName() == null || !button.getName().equalsIgnoreCase(locator)) break;
                    return true;
                }
                case Label: {
                    if (button.getText() == null || !button.getText().equalsIgnoreCase(locator)) break;
                    return true;
                }
                case ClassName: {
                    if (!locator.equals("JButton")) break;
                    return true;
                }
            }
        }
        if (component instanceof JComboBox) {
            JComboBox combo = (JComboBox)component;
            switch (locatorType) {
                case Name: {
                    if (combo.getName() == null || !combo.getName().equalsIgnoreCase(locator)) break;
                    return true;
                }
                case ClassName: {
                    if (!locator.equals("JComboBox")) break;
                    return true;
                }
            }
        }
        if (component instanceof JTextField) {
            JTextField textField = (JTextField)component;
            switch (locatorType) {
                case Name: {
                    if (textField.getName() == null || !textField.getName().equalsIgnoreCase(locator)) break;
                    return true;
                }
                case Label: {
                    if (textField.getText() == null || !textField.getText().equalsIgnoreCase(locator)) break;
                    return true;
                }
                case ClassName: {
                    if (!locator.equals("JTextField")) break;
                    return true;
                }
            }
        }
        if (component instanceof JLabel) {
            JLabel label = (JLabel)component;
            switch (locatorType) {
                case Name: {
                    if (label.getName() == null || !label.getName().equalsIgnoreCase(locator)) break;
                    return true;
                }
                case Label: {
                    if (label.getText() == null || !label.getText().equalsIgnoreCase(locator)) break;
                    return true;
                }
                case ClassName: {
                    if (!locator.equals("JLabel")) break;
                    return true;
                }
            }
        }
        if (component instanceof JSpinner) {
            JSpinner spinner = (JSpinner)component;
            switch (locatorType) {
                case Name: {
                    if (spinner.getName() == null || !spinner.getName().equalsIgnoreCase(locator)) break;
                    return true;
                }
                case ClassName: {
                    if (!locator.equals("JSpinner")) break;
                    return true;
                }
            }
        }
        if (component instanceof JMenu) {
            JMenu menu = (JMenu)component;
            switch (locatorType) {
                case Name: {
                    if (menu.getName() == null || !menu.getName().equalsIgnoreCase(locator)) break;
                    return true;
                }
                case Label: {
                    if (menu.getText() == null || !menu.getText().equalsIgnoreCase(locator)) break;
                    return true;
                }
                case ClassName: {
                    if (!locator.equals("JMenu")) break;
                    return true;
                }
            }
        }
        if (component instanceof JMenuItem) {
            JMenuItem menuItem = (JMenuItem)component;
            switch (locatorType) {
                case Name: {
                    if (menuItem.getName() == null || !menuItem.getName().equalsIgnoreCase(locator)) break;
                    return true;
                }
                case Label: {
                    if (menuItem.getText() == null || !menuItem.getText().equalsIgnoreCase(locator)) break;
                    return true;
                }
                case ClassName: {
                    if (!locator.equals("JMenuItem")) break;
                    return true;
                }
            }
        }
        if (component instanceof JCheckBox) {
            JCheckBox checkBox = (JCheckBox)component;
            switch (locatorType) {
                case Name: {
                    if (checkBox.getName() == null || !checkBox.getName().equalsIgnoreCase(locator)) break;
                    return true;
                }
                case Label: {
                    if (checkBox.getText() == null || !checkBox.getText().equalsIgnoreCase(locator)) break;
                    return true;
                }
                case ClassName: {
                    if (!locator.equals("JCheckBox")) break;
                    return true;
                }
            }
        }
        if (component instanceof JRadioButton) {
            JRadioButton radio = (JRadioButton)component;
            switch (locatorType) {
                case Name: {
                    if (radio.getName() == null || !radio.getName().equalsIgnoreCase(locator)) break;
                    return true;
                }
                case Label: {
                    if (radio.getText() == null || !radio.getText().equalsIgnoreCase(locator)) break;
                    return true;
                }
                case ClassName: {
                    if (!locator.equals("JRadioButton")) break;
                    return true;
                }
            }
        }
        if (component instanceof JFileChooser) {
            JFileChooser fileChooser = (JFileChooser)component;
            switch (locatorType) {
                case Name: {
                    if (fileChooser.getName() == null || !fileChooser.getName().equalsIgnoreCase(locator)) break;
                    return true;
                }
                case ClassName: {
                    if (!locator.equals("JFileChooser")) break;
                    return true;
                }
            }
        }
        if (component instanceof JTabbedPane) {
            JTabbedPane tabbedPane = (JTabbedPane)component;
            for (int i = 0; i < tabbedPane.getComponentCount(); ++i) {
                if (tabbedPane.getTitleAt(i) != null && locatorType == ElementLocatorType.Label && tabbedPane.getTitleAt(i).equalsIgnoreCase(locator)) {
                    return true;
                }
                if (locatorType != ElementLocatorType.ClassName || !locator.equals("JTabbedPane")) continue;
                return true;
            }
        }
        if (component instanceof JTable && locatorType == ElementLocatorType.ClassName && locator.equals("JTable")) {
            return true;
        }
        if (component.getClass().getCanonicalName() != null && locatorType == ElementLocatorType.ClassName && component.getClass().getCanonicalName().equalsIgnoreCase(locator)) {
            try {
                Method isShowingMethod = component.getClass().getMethod("isShowing", new Class[0]);
                boolean isShowing = (Boolean)isShowingMethod.invoke((Object)component, new Object[0]);
                if (!isShowing) {
                    return false;
                }
                if (this.getElementMap().locator().length > 1) {
                    Method getInformacaoMethod = component.getClass().getMethod("getText", new Class[0]);
                    String resultado = (String)getInformacaoMethod.invoke((Object)component, new Object[0]);
                    String locatorAux = this.getLocatorWithParameters(this.getElementMap().locator()[1]);
                    return resultado.equalsIgnoreCase(locatorAux);
                }
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
        return false;
    }

    private String getLocatorWithParameters(String locator) {
        if (this.getLocatorParameter() != null && !this.getLocatorParameter().isEmpty() && locator.matches(".*%param[0-9]+%.*")) {
            int n = 1;
            for (String parameter : this.getLocatorParameter()) {
                String tag = "%param" + n + "%";
                if (locator.contains(tag)) {
                    locator = locator.replace(tag, parameter);
                }
                ++n;
            }
        }
        return locator;
    }

    protected void waitThreadSleep(Long delay) {
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException ex) {
            throw new BehaveException(this.message.getString("exception-thread-sleep"), (Throwable)ex);
        }
    }

    @Override
    public void isVisibleDisabled() {
        JComponent component = (JComponent)this.getElement();
        if (component == null) {
            throw new BehaveException(this.message.getString("exception-element-not-found", new Object[]{this.getElementMap().name()}));
        }
        if (!component.isVisible() || component.isEnabled()) {
            throw new BehaveException(this.message.getString("exception-element-not-displayed-or-enabled", new Object[]{this.getElementMap().name()}));
        }
    }
}

