/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.behave.runner.fest.ui;

import br.gov.frameworkdemoiselle.behave.config.BehaveConfig;
import br.gov.frameworkdemoiselle.behave.exception.BehaveException;
import br.gov.frameworkdemoiselle.behave.message.BehaveMessage;
import br.gov.frameworkdemoiselle.behave.runner.fest.FestRunner;
import br.gov.frameworkdemoiselle.behave.runner.fest.ui.DesktopBase;
import br.gov.frameworkdemoiselle.behave.runner.ui.Label;
import java.util.GregorianCalendar;
import javax.swing.JLabel;
import org.fest.swing.fixture.JLabelFixture;
import org.junit.Assert;

public class DesktopLabel
extends DesktopBase
implements Label {
    private static BehaveMessage message = new BehaveMessage(FestRunner.MESSAGEBUNDLE);

    @Override
    public String getText() {
        return ((JLabel)this.getElement()).getText();
    }

    @Override
    public void waitTextInElement(String text) {
        JLabelFixture textFix = new JLabelFixture(this.runner.robot, (JLabel)this.getElement());
        boolean found = false;
        long startedTime = GregorianCalendar.getInstance().getTimeInMillis();
        while (true) {
            try {
                if (textFix.text().equals(text)) {
                    found = true;
                }
            }
            catch (BehaveException be) {
                throw be;
            }
            catch (Exception e) {
                throw new BehaveException(message.getString("exception-unexpected", new Object[]{e.getMessage()}), (Throwable)e);
            }
            if (found) break;
            this.waitThreadSleep(BehaveConfig.getRunner_ScreenMinWait());
            if (GregorianCalendar.getInstance().getTimeInMillis() - startedTime <= BehaveConfig.getRunner_ScreenMaxWait()) continue;
            Assert.fail((String)message.getString("message-text-not-found", new Object[]{text}));
        }
    }
}

