/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.behave.runner.fest.ui;

import br.gov.frameworkdemoiselle.behave.exception.BehaveException;
import br.gov.frameworkdemoiselle.behave.runner.fest.ui.DesktopBase;
import br.gov.frameworkdemoiselle.behave.runner.ui.TextField;
import javax.swing.text.JTextComponent;
import org.fest.swing.fixture.JTextComponentFixture;

public class DesktopTextField
extends DesktopBase
implements TextField {
    public void sendKeys(CharSequence ... keysToSend) {
        try {
            JTextComponentFixture textFix = new JTextComponentFixture(this.runner.robot, (JTextComponent)this.getElement());
            for (CharSequence cs : keysToSend) {
                textFix.setText(((Object)cs).toString());
            }
        }
        catch (Exception e) {
            throw new BehaveException(this.runner.getHierarchy(), (Throwable)e);
        }
    }

    public void sendKeysWithTries(CharSequence ... keysToSend) {
        this.sendKeys(keysToSend);
    }

    public void clear() {
        this.sendKeys("");
    }

    @Override
    public String getText() {
        JTextComponentFixture textFix = new JTextComponentFixture(this.runner.robot, (JTextComponent)this.getElement());
        return textFix.text();
    }

    @Override
    public void isVisibleDisabled() {
        JTextComponent component = (JTextComponent)this.getElement();
        if (component == null) {
            throw new BehaveException(this.message.getString("exception-element-not-found", new Object[]{this.getElementMap().name()}));
        }
        if (!component.isVisible() || component.isEditable() && component.isEnabled()) {
            throw new BehaveException(this.message.getString("exception-element-not-displayed-or-enabled", new Object[]{this.getElementMap().name()}));
        }
    }

    public void sendKeysTriggerEvent(String event, CharSequence ... keysToSend) {
    }
}

