/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.certificate.ca.provider.impl;

import br.gov.frameworkdemoiselle.certificate.ca.provider.ProviderCA;
import br.gov.frameworkdemoiselle.certificate.ca.provider.impl.ICPBrasilUserHomeProviderCA;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownServiceException;
import java.security.MessageDigest;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.bind.DatatypeConverter;

public class ICPBrasilOnLineSerproProviderCA
implements ProviderCA {
    private static final String STRING_URL_ZIP = "http://repositorio.serpro.gov.br/icp-brasil/ACcompactado.zip";
    private static final String STRING_URL_HASH = "http://repositorio.serpro.gov.br/icp-brasil/hashsha512.txt";
    private static final int TIMEOUT_CONNECTION = 3000;
    private static final int TIMEOUT_READ = 5000;
    private static final Logger LOGGER = Logger.getLogger(ICPBrasilOnLineSerproProviderCA.class.getName());

    public String getURLZIP() {
        return STRING_URL_ZIP;
    }

    public String getURLHash() {
        return STRING_URL_HASH;
    }

    public Collection<X509Certificate> getCAs() {
        Collection<X509Certificate> result = null;
        boolean useCache = false;
        try {
            String pathZip = ICPBrasilUserHomeProviderCA.FULL_PATH_ZIP;
            File filePathZip = new File(pathZip);
            if (filePathZip.exists()) {
                InputStream inputStreamHash = this.getInputStreamFromURL(this.getURLHash());
                Scanner scannerOnlineHash = new Scanner(inputStreamHash);
                scannerOnlineHash.useDelimiter("\\A");
                String onlineHash = scannerOnlineHash.hasNext() ? scannerOnlineHash.next() : "";
                scannerOnlineHash.close();
                if (!onlineHash.equals("")) {
                    String localZipHash = DatatypeConverter.printHexBinary((byte[])this.checksum(filePathZip));
                    String onlineHashWithouFilename = onlineHash.replace("ACcompactado.zip", "").replaceAll(" ", "").replaceAll("\n", "");
                    useCache = onlineHashWithouFilename.equalsIgnoreCase(localZipHash);
                } else {
                    LOGGER.log(Level.WARNING, "Ocorreu um erro ao obter o hash online, pois est\u00e1 vazio.");
                }
            }
            if (!useCache) {
                int nRead;
                LOGGER.log(Level.INFO, "Recuperando REMOTAMENTE as cadeias da ICP-Brasil [" + this.getURLZIP() + "].");
                InputStream inputStreamZip = this.getInputStreamFromURL(this.getURLZIP());
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                byte[] data = new byte[16384];
                while ((nRead = inputStreamZip.read(data, 0, data.length)) != -1) {
                    buffer.write(data, 0, nRead);
                }
                buffer.flush();
                byte[] content = buffer.toByteArray();
                FileOutputStream out = new FileOutputStream(filePathZip);
                out.write(content);
                out.close();
                inputStreamZip.close();
                LOGGER.log(Level.INFO, "Cadeias da ICP-Brasil recupedadas com sucesso.");
            }
            FileInputStream inputStreamZipReturn = new FileInputStream(pathZip.toString());
            result = this.getFromZip(inputStreamZipReturn);
            ((InputStream)inputStreamZipReturn).close();
            LOGGER.log(Level.INFO, "Recuperou [" + result.size() + "] certificados do arquivo que foi baixado.");
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Erro ao tentar recuperar a cadeia.", e);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Erro inesperado ao tentar recuperar a cadeia.", e);
        }
        if (result != null) {
            LOGGER.log(Level.INFO, "O Provider " + this.getName() + " possui [" + result.size() + "] certificados.");
        } else {
            LOGGER.log(Level.INFO, "O Provider " + this.getName() + " N\u00c3O possui certificados.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] checksum(File input) throws IOException {
        FileInputStream in = null;
        try {
            int length;
            in = new FileInputStream(input);
            MessageDigest digest = MessageDigest.getInstance("SHA-512");
            byte[] block = new byte[4096];
            while ((length = ((InputStream)in).read(block)) > 0) {
                digest.update(block, 0, length);
            }
            byte[] byArray = digest.digest();
            return byArray;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<X509Certificate> getOnline(InputStream zip) {
        HashSet<X509Certificate> result = new HashSet();
        long timeBefore = 0L;
        long timeAfter = 0L;
        try {
            timeBefore = System.currentTimeMillis();
            result = this.getFromZip(zip);
            timeAfter = System.currentTimeMillis();
        }
        catch (Throwable error) {
            timeAfter = System.currentTimeMillis();
            LOGGER.log(Level.WARNING, "ERRO. [" + error.getMessage() + "].");
        }
        finally {
            LOGGER.log(Level.INFO, "Levamos " + (timeAfter - timeBefore) + "ms para recuperar as cadeias.");
        }
        return result;
    }

    public Collection<X509Certificate> getFromZip(InputStream zip) throws RuntimeException {
        HashSet<X509Certificate> result = new HashSet<X509Certificate>();
        BufferedInputStream in = new BufferedInputStream(zip);
        ZipInputStream zin = new ZipInputStream(in);
        ZipEntry arquivoInterno = null;
        try {
            while ((arquivoInterno = zin.getNextEntry()) != null) {
                if (arquivoInterno.isDirectory()) continue;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] b = new byte[512];
                int len = 0;
                while ((len = zin.read(b)) != -1) {
                    out.write(b, 0, len);
                }
                ByteArrayInputStream is = new ByteArrayInputStream(out.toByteArray());
                out.close();
                X509Certificate certificate = (X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(is);
                is.close();
                result.add(certificate);
            }
        }
        catch (CertificateException error) {
            throw new RuntimeException("Certificado inv\u00e1lido", error);
        }
        catch (IOException error) {
            throw new RuntimeException("Erro ao tentar abrir o stream", error);
        }
        return result;
    }

    public InputStream getInputStreamFromURL(String stringURL) throws RuntimeException {
        try {
            URL url = new URL(stringURL);
            URLConnection connection = url.openConnection();
            connection.setConnectTimeout(3000);
            connection.setReadTimeout(5000);
            return connection.getInputStream();
        }
        catch (MalformedURLException error) {
            throw new RuntimeException("URL mal formada", error);
        }
        catch (UnknownServiceException error) {
            throw new RuntimeException("Servi\u00e7o da URL desconhecido", error);
        }
        catch (IOException error) {
            throw new RuntimeException("Algum erro de I/O ocorreu", error);
        }
    }

    public String getName() {
        return "ICP Brasil ONLINE SERPRO Provider (" + this.getURLZIP() + ")";
    }
}

