/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.certificate.ca.provider.impl;

import br.gov.frameworkdemoiselle.certificate.ca.provider.ProviderCA;
import br.gov.frameworkdemoiselle.certificate.ca.provider.impl.ICPBrasilProviderCAException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;

public class ICPBrasilProviderCA
implements ProviderCA {
    public Collection<X509Certificate> getCAs() {
        KeyStore keyStore = this.getKeyStore();
        ArrayList<X509Certificate> result = new ArrayList<X509Certificate>();
        try {
            Enumeration<String> e = keyStore.aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                X509Certificate root = (X509Certificate)keyStore.getCertificate(alias);
                result.add(root);
            }
        }
        catch (Throwable error) {
            throw new ICPBrasilProviderCAException("Error on load certificates from default keystore", error);
        }
        return result;
    }

    private KeyStore getKeyStore() {
        KeyStore keyStore = null;
        try {
            InputStream is = ICPBrasilProviderCA.class.getClassLoader().getResourceAsStream("icpbrasil.jks");
            keyStore = KeyStore.getInstance("JKS");
            keyStore.load(is, "changeit".toCharArray());
        }
        catch (Throwable error) {
            throw new ICPBrasilProviderCAException("KeyStore default not loaded.", error);
        }
        return keyStore;
    }

    public String getName() {
        return "ICP Brasil Provider (Componente)";
    }
}

