/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.certificate.ca.provider.impl;

import br.gov.frameworkdemoiselle.certificate.ca.provider.ProviderCA;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ICPBrasilUserHomeProviderCA
implements ProviderCA {
    public static final String PATH_HOME_USER = System.getProperty("user.home");
    public static final String FOLDER_ASSINADOR = ".java" + File.separator + "assinador";
    public static final String FILENAME_ZIP = "ACcompactado.zip";
    public static final String FILENAME_HASH = "hashsha512.txt";
    public static final String FULL_PATH_FOLDER_ASSINADOR = PATH_HOME_USER + File.separator + FOLDER_ASSINADOR;
    public static final String FULL_PATH_ZIP = PATH_HOME_USER + File.separator + FOLDER_ASSINADOR + File.separator + "ACcompactado.zip";
    public static final String FULL_PATH_HASH = PATH_HOME_USER + File.separator + FOLDER_ASSINADOR + File.separator + "hashsha512.txt";
    private static final Logger LOGGER = Logger.getLogger(ICPBrasilUserHomeProviderCA.class.getName());

    public Collection<X509Certificate> getCAs() {
        try {
            this.verifyZIPPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.getFromLocalZip(FULL_PATH_ZIP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<X509Certificate> getFromLocalZip(String fileZip) {
        LOGGER.log(Level.INFO, "Recuperando localmente as cadeias da ICP-Brasil [" + fileZip.toString() + "].");
        HashSet<X509Certificate> result = new HashSet();
        long timeBefore = 0L;
        long timeAfter = 0L;
        try {
            timeBefore = System.currentTimeMillis();
            File fileFileZip = new File(fileZip);
            if (!fileFileZip.exists()) {
                throw new Exception("Arquivo ZIP n\u00e3o encontrado no home do usu\u00e1rio");
            }
            FileInputStream inputStream = new FileInputStream(fileZip.toString());
            result = this.getFromZip(inputStream);
            timeAfter = System.currentTimeMillis();
        }
        catch (Throwable error) {
            timeAfter = System.currentTimeMillis();
            LOGGER.log(Level.WARNING, "ERRO. [" + error.getMessage() + "].");
        }
        finally {
            LOGGER.log(Level.INFO, "Levamos " + (timeAfter - timeBefore) + "ms para tentar recuperar as cadeias do ZIP local.");
        }
        return result;
    }

    public String verifyZIPPath() throws IOException {
        String finalFolder = FULL_PATH_FOLDER_ASSINADOR;
        File fileFinalFolder = new File(finalFolder);
        if (!fileFinalFolder.isDirectory()) {
            fileFinalFolder.mkdirs();
        }
        return finalFolder;
    }

    public Collection<X509Certificate> getFromZip(InputStream zip) throws RuntimeException {
        HashSet<X509Certificate> result = new HashSet<X509Certificate>();
        BufferedInputStream in = new BufferedInputStream(zip);
        ZipInputStream zin = new ZipInputStream(in);
        ZipEntry arquivoInterno = null;
        try {
            while ((arquivoInterno = zin.getNextEntry()) != null) {
                if (arquivoInterno.isDirectory()) continue;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] b = new byte[512];
                int len = 0;
                while ((len = zin.read(b)) != -1) {
                    out.write(b, 0, len);
                }
                ByteArrayInputStream is = new ByteArrayInputStream(out.toByteArray());
                out.close();
                X509Certificate certificate = (X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(is);
                is.close();
                result.add(certificate);
            }
        }
        catch (CertificateException error) {
            throw new RuntimeException("Certificado inv\u00e1lido", error);
        }
        catch (IOException error) {
            throw new RuntimeException("Erro ao tentar abrir o stream", error);
        }
        return result;
    }

    public String getName() {
        return "Home User Provider";
    }
}

