/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.implementation;

import br.gov.frameworkdemoiselle.annotation.Name;
import br.gov.frameworkdemoiselle.internal.configuration.JMXConfig;
import br.gov.frameworkdemoiselle.internal.implementation.MBeanHelper;
import br.gov.frameworkdemoiselle.internal.implementation.MBeanManager;
import br.gov.frameworkdemoiselle.internal.implementation.ManagedType;
import br.gov.frameworkdemoiselle.internal.implementation.NotificationEventListener;
import br.gov.frameworkdemoiselle.internal.proxy.DynamicMBeanProxy;
import br.gov.frameworkdemoiselle.management.ManagementExtension;
import br.gov.frameworkdemoiselle.util.Beans;
import java.util.List;
import javax.management.ObjectInstance;

public class JMXManagementExtension
implements ManagementExtension {
    public void registerNotificationMBean() {
        JMXConfig configuration;
        StringBuffer notificationMBeanName;
        MBeanManager mbeanManager = (MBeanManager)Beans.getReference(MBeanManager.class);
        if (mbeanManager.findMBeanInstance((notificationMBeanName = new StringBuffer().append((configuration = (JMXConfig)Beans.getReference(JMXConfig.class)).getNotificationDomain() != null ? configuration.getNotificationDomain() : "br.gov.frameworkdemoiselle.jmx").append(":name=").append(configuration.getNotificationMBeanName())).toString()) == null) {
            NotificationEventListener listener = (NotificationEventListener)Beans.getReference(NotificationEventListener.class);
            ObjectInstance instance = MBeanHelper.register(listener.createNotificationBroadcaster(), notificationMBeanName.toString());
            mbeanManager.storeRegisteredMBean(instance);
        }
    }

    public void initialize(List<ManagedType> managedTypes) {
        MBeanManager manager = (MBeanManager)Beans.getReference(MBeanManager.class);
        JMXConfig configuration = (JMXConfig)Beans.getReference(JMXConfig.class);
        for (ManagedType type : managedTypes) {
            DynamicMBeanProxy beanProxy = new DynamicMBeanProxy(type);
            Name nameAnnotation = type.getType().getAnnotation(Name.class);
            String mbeanName = nameAnnotation != null ? nameAnnotation.value() : type.getType().getSimpleName();
            StringBuffer name = new StringBuffer().append(configuration.getMbeanDomain() != null ? configuration.getMbeanDomain() : type.getType().getPackage().getName()).append(":name=").append(mbeanName);
            if (manager.findMBeanInstance(name.toString()) != null) continue;
            ObjectInstance instance = MBeanHelper.register(beanProxy, name.toString());
            manager.storeRegisteredMBean(instance);
        }
        this.registerNotificationMBean();
    }

    public void shutdown(List<ManagedType> managedTypes) {
        MBeanManager manager = (MBeanManager)Beans.getReference(MBeanManager.class);
        for (ObjectInstance instance : manager.listRegisteredMBeans()) {
            MBeanHelper.unregister(instance.getObjectName());
        }
        manager.cleanRegisteredMBeans();
    }
}

