/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.transaction;

import br.gov.frameworkdemoiselle.annotation.Priority;
import br.gov.frameworkdemoiselle.internal.producer.EntityManagerProducer;
import br.gov.frameworkdemoiselle.transaction.Transaction;
import br.gov.frameworkdemoiselle.transaction.TransactionException;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.NameQualifier;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.lang.annotation.Annotation;
import java.util.Collection;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;

@Priority(value=2147483547)
public class JPATransaction
implements Transaction {
    private static final long serialVersionUID = 1L;
    private EntityManagerProducer producer;
    private ResourceBundle bundle;

    private EntityManagerProducer getProducer() {
        if (this.producer == null) {
            this.producer = (EntityManagerProducer)Beans.getReference(EntityManagerProducer.class);
        }
        return this.producer;
    }

    private ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = (ResourceBundle)Beans.getReference(ResourceBundle.class, (Annotation[])new Annotation[]{new NameQualifier("demoiselle-jpa-bundle")});
        }
        return this.bundle;
    }

    public Collection<EntityManager> getDelegate() {
        return this.getProducer().getCache().values();
    }

    public void begin() {
        try {
            for (EntityManager entityManager : this.getDelegate()) {
                EntityTransaction transaction = entityManager.getTransaction();
                if (transaction.isActive()) continue;
                transaction.begin();
            }
        }
        catch (Exception e) {
            this.setRollbackOnly();
            throw new TransactionException((Throwable)e);
        }
    }

    public void commit() {
        int commitedEntityManagers = 0;
        try {
            for (EntityManager entityManager : this.getDelegate()) {
                EntityTransaction transaction = entityManager.getTransaction();
                if (!transaction.isActive()) continue;
                transaction.commit();
                ++commitedEntityManagers;
            }
        }
        catch (Exception e) {
            this.setRollbackOnly();
            if (commitedEntityManagers > 0) {
                throw new TransactionException(this.getBundle().getString("partial-rollback-problem"), (Throwable)e);
            }
            throw new TransactionException((Throwable)e);
        }
    }

    public void rollback() {
        try {
            for (EntityManager entityManager : this.getDelegate()) {
                EntityTransaction transaction = entityManager.getTransaction();
                if (!transaction.isActive()) continue;
                transaction.rollback();
            }
        }
        catch (Exception e) {
            throw new TransactionException((Throwable)e);
        }
    }

    public void setRollbackOnly() {
        try {
            for (EntityManager entityManager : this.getDelegate()) {
                EntityTransaction transaction = entityManager.getTransaction();
                if (!transaction.isActive()) continue;
                transaction.setRollbackOnly();
            }
        }
        catch (Exception e) {
            throw new TransactionException((Throwable)e);
        }
    }

    public boolean isActive() {
        boolean active = false;
        try {
            for (EntityManager entityManager : this.getDelegate()) {
                EntityTransaction transaction = entityManager.getTransaction();
                if (!transaction.isActive()) continue;
                active = true;
                break;
            }
        }
        catch (Exception e) {
            throw new TransactionException((Throwable)e);
        }
        return active;
    }

    public boolean isMarkedRollback() {
        boolean rollbackOnly = false;
        try {
            for (EntityManager entityManager : this.getDelegate()) {
                EntityTransaction transaction = entityManager.getTransaction();
                if (!transaction.isActive() || !transaction.getRollbackOnly()) continue;
                rollbackOnly = true;
                break;
            }
        }
        catch (Exception e) {
            throw new TransactionException((Throwable)e);
        }
        return rollbackOnly;
    }
}

