/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.eta.etaservices.printing.pdf;

import br.gov.lexml.eta.etaservices.printing.pdf.VelocityExtension;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

final class VelocityExtensionUtils {
    private VelocityExtensionUtils() {
    }

    static Double stringToDouble(String value) throws NumberFormatException {
        if (value == null) {
            return 0.0;
        }
        try {
            DecimalFormat df = new DecimalFormat();
            df.setDecimalFormatSymbols(new DecimalFormatSymbols(new Locale("pt", "BR")));
            return df.parse(value).doubleValue();
        }
        catch (ParseException e) {
            try {
                return Double.valueOf(value.trim());
            }
            catch (NumberFormatException e1) {
                return 0.0;
            }
        }
    }

    static String formatCurrencyNumber(String value) throws NumberFormatException {
        double number = VelocityExtensionUtils.stringToDouble(value);
        NumberFormat formatter = NumberFormat.getCurrencyInstance();
        return formatter.format(number);
    }

    public static String render(String vtl, VelocityContext ctx, VelocityEngine velocityEngine) {
        if (vtl == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        boolean success = velocityEngine == null ? Velocity.evaluate((Context)ctx, (Writer)sw, (String)VelocityExtension.class.getName(), (String)vtl) : velocityEngine.evaluate((Context)ctx, (Writer)sw, VelocityExtension.class.getName(), vtl);
        return success ? sw.toString() : vtl;
    }

    public static String lowercaseInitial(String html) {
        if (html == null) {
            return null;
        }
        String brancosIniciais = "";
        String restante = html;
        Matcher m = Pattern.compile("^((?:\\s*<[^>]*?>)*\\s*)(.*)$", 32).matcher(html);
        if (m.matches()) {
            brancosIniciais = m.group(1);
            restante = m.group(2);
        }
        if (restante.length() > 1 && Character.isUpperCase(restante.charAt(0))) {
            return brancosIniciais + Character.toLowerCase(restante.charAt(0)) + restante.substring(1);
        }
        return html;
    }

    public static String removeFinalDot(String html) {
        if (html == null) {
            return null;
        }
        String inicio = html;
        String brancosFinais = "";
        Matcher m = Pattern.compile("^(.*?)((?:\\s*<[^>]*>)*\\s*)$", 32).matcher(html);
        if (m.matches()) {
            inicio = m.group(1);
            brancosFinais = m.group(2);
        }
        if (inicio.endsWith(".") || inicio.endsWith(",")) {
            return inicio.substring(0, inicio.length() - 1) + brancosFinais;
        }
        return html;
    }
}

