/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.eta.etaservices.emenda;

import br.gov.lexml.eta.etaservices.emenda.Autoria;
import br.gov.lexml.eta.etaservices.emenda.ColegiadoApreciador;
import br.gov.lexml.eta.etaservices.emenda.ComandoEmenda;
import br.gov.lexml.eta.etaservices.emenda.ComponenteEmendado;
import br.gov.lexml.eta.etaservices.emenda.Epigrafe;
import br.gov.lexml.eta.etaservices.emenda.ModoEdicaoEmenda;
import br.gov.lexml.eta.etaservices.emenda.OpcoesImpressao;
import br.gov.lexml.eta.etaservices.emenda.RefProposicaoEmendada;
import java.time.Instant;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.List;
import java.util.Map;

public interface Emenda {
    public Instant getDataUltimaModificacao();

    public String getAplicacao();

    public String getVersaoAplicacao();

    public ModoEdicaoEmenda getModoEdicao();

    public Map<String, Object> getMetadados();

    public RefProposicaoEmendada getProposicao();

    public ColegiadoApreciador getColegiadoApreciador();

    public Epigrafe getEpigrafe();

    public List<? extends ComponenteEmendado> getComponentes();

    public ComandoEmenda getComandoEmenda();

    public String getJustificativa();

    public String getLocal();

    public LocalDate getData();

    default public String getDataFormatada() {
        return this.getData().format(DateTimeFormatter.ofLocalizedDate(FormatStyle.LONG)).toLowerCase();
    }

    public Autoria getAutoria();

    public OpcoesImpressao getOpcoesImpressao();
}

