/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.eta.etaservices.parsing.xml;

import br.gov.lexml.eta.etaservices.emenda.Autoria;
import br.gov.lexml.eta.etaservices.emenda.ColegiadoApreciador;
import br.gov.lexml.eta.etaservices.emenda.ColegiadoAutor;
import br.gov.lexml.eta.etaservices.emenda.ComandoEmenda;
import br.gov.lexml.eta.etaservices.emenda.ComponenteEmendado;
import br.gov.lexml.eta.etaservices.emenda.DispositivoEmendaAdicionado;
import br.gov.lexml.eta.etaservices.emenda.DispositivoEmendaModificado;
import br.gov.lexml.eta.etaservices.emenda.DispositivoEmendaSuprimido;
import br.gov.lexml.eta.etaservices.emenda.Emenda;
import br.gov.lexml.eta.etaservices.emenda.Epigrafe;
import br.gov.lexml.eta.etaservices.emenda.ItemComandoEmenda;
import br.gov.lexml.eta.etaservices.emenda.ModoEdicaoEmenda;
import br.gov.lexml.eta.etaservices.emenda.NotaAlteracao;
import br.gov.lexml.eta.etaservices.emenda.OpcoesImpressao;
import br.gov.lexml.eta.etaservices.emenda.Parlamentar;
import br.gov.lexml.eta.etaservices.emenda.RefProposicaoEmendada;
import br.gov.lexml.eta.etaservices.emenda.Sexo;
import br.gov.lexml.eta.etaservices.emenda.SiglaCasaLegislativa;
import br.gov.lexml.eta.etaservices.emenda.TipoAutoria;
import br.gov.lexml.eta.etaservices.emenda.TipoColegiado;
import br.gov.lexml.eta.etaservices.parsing.xml.AtributosEmenda;
import br.gov.lexml.eta.etaservices.parsing.xml.AutoriaRecord;
import br.gov.lexml.eta.etaservices.parsing.xml.ColegiadoApreciadorRecord;
import br.gov.lexml.eta.etaservices.parsing.xml.ColegiadoAutorRecord;
import br.gov.lexml.eta.etaservices.parsing.xml.ComandoEmendaRecord;
import br.gov.lexml.eta.etaservices.parsing.xml.ComponenteEmendadoRecord;
import br.gov.lexml.eta.etaservices.parsing.xml.DispositivoEmendaModificadoRecord;
import br.gov.lexml.eta.etaservices.parsing.xml.DispositivoEmendaSuprimidoRecord;
import br.gov.lexml.eta.etaservices.parsing.xml.DispositivosEmendaRecord;
import br.gov.lexml.eta.etaservices.parsing.xml.EmendaRecord;
import br.gov.lexml.eta.etaservices.parsing.xml.EpigrafeRecord;
import br.gov.lexml.eta.etaservices.parsing.xml.ItemComandoEmendaRecord;
import br.gov.lexml.eta.etaservices.parsing.xml.Metadados;
import br.gov.lexml.eta.etaservices.parsing.xml.OpcoesImpressaoRecord;
import br.gov.lexml.eta.etaservices.parsing.xml.ParlamentarRecord;
import br.gov.lexml.eta.etaservices.parsing.xml.RefProposicaoEmendadaRecord;
import java.io.Reader;
import java.io.StringReader;
import java.time.Instant;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class EmendaXmlUnmarshaller {
    public Emenda fromXml(String xml) throws DocumentException {
        SAXReader reader = new SAXReader();
        Document doc = reader.read((Reader)new StringReader(xml));
        return this.parseEmenda(doc.getRootElement());
    }

    private Emenda parseEmenda(Element rootElement) {
        AtributosEmenda atributosEmenda = this.parseAtributosEmenda(rootElement);
        Metadados metadados = this.parseMetadados(rootElement);
        RefProposicaoEmendada proposicao = this.parseProposicao(rootElement);
        ColegiadoApreciador colegiadoApreciador = this.parseColegiado(rootElement);
        Epigrafe epigrafe = this.parseEpigrafe(rootElement);
        List<? extends ComponenteEmendado> componentes = this.parseComponentes(rootElement);
        ComandoEmenda comandoEmenda = this.parseComandoEmenda(rootElement);
        String justificativa = this.parseJustificativa(rootElement);
        Autoria autoria = this.parseAutoria(rootElement);
        OpcoesImpressao opcoesImpressao = this.parseOpcoesImpressao(rootElement);
        return new EmendaRecord(metadados.getDataUltimaModificacao(), metadados.getAplicacao(), metadados.getVersaoAplicacao(), metadados.getModoEdicao(), metadados.getMeta(), proposicao, colegiadoApreciador, epigrafe, componentes, comandoEmenda, justificativa, atributosEmenda.getLocal(), atributosEmenda.getData(), autoria, opcoesImpressao);
    }

    private List<? extends ComponenteEmendado> parseComponentes(Element rootElement) {
        List nodes = rootElement.selectNodes("/Componente");
        return nodes.stream().map(this::parseComponente).collect(Collectors.toList());
    }

    private AtributosEmenda parseAtributosEmenda(Element rootElement) {
        String local = rootElement.attributeValue("local");
        String dataAttribute = rootElement.attributeValue("data");
        LocalDate data = LocalDate.parse(dataAttribute);
        return new AtributosEmenda(local, data);
    }

    private Metadados parseMetadados(Element rootElement) {
        Node metadadosNode = rootElement.selectSingleNode("/Metadados");
        List metadados = metadadosNode.selectNodes("");
        Instant dataUltimaModificacao = Instant.now();
        String aplicacao = "";
        String versaoAplicacao = "";
        ModoEdicaoEmenda modoEdicao = ModoEdicaoEmenda.EMENDA;
        LinkedHashMap<String, Object> meta = new LinkedHashMap<String, Object>();
        block12: for (Node n : metadados) {
            switch (n.getName()) {
                case "DataUltimaModificacao": {
                    String dt = n.getStringValue();
                    dataUltimaModificacao = Instant.parse(dt);
                    continue block12;
                }
                case "Aplicacao": {
                    aplicacao = n.getStringValue();
                    continue block12;
                }
                case "VersaoAplicacao": {
                    versaoAplicacao = n.getStringValue();
                    continue block12;
                }
                case "ModoEdicao": {
                    String me = n.getStringValue();
                    modoEdicao = ModoEdicaoEmenda.parse(me);
                    continue block12;
                }
            }
            meta.put(n.getName(), n.getStringValue());
        }
        return new Metadados(dataUltimaModificacao, aplicacao, versaoAplicacao, modoEdicao, meta);
    }

    private RefProposicaoEmendada parseProposicao(Element rootElement) {
        Node proposicao = rootElement.selectSingleNode("/Proposicao");
        String urn = proposicao.valueOf("/@urn");
        String sigla = proposicao.valueOf("/@sigla");
        String numero = proposicao.valueOf("/@numero");
        String ano = proposicao.valueOf("/@ano");
        String ementa = proposicao.valueOf("/@ementa");
        String identificacaoTexto = proposicao.valueOf("/@identificacaoTexto");
        return new RefProposicaoEmendadaRecord(urn, sigla, numero, ano, ementa, identificacaoTexto);
    }

    private ColegiadoApreciador parseColegiado(Element rootElement) {
        Node colegiado = rootElement.selectSingleNode("/ColegiadoApreciador");
        SiglaCasaLegislativa sigla = SiglaCasaLegislativa.parse(colegiado.valueOf("/@siglaCasaLegislativa"));
        TipoColegiado tipoColegiado = TipoColegiado.parse(colegiado.valueOf("/@tipoColegiado"));
        String siglaComissao = colegiado.valueOf("/@siglaComissao");
        return new ColegiadoApreciadorRecord(sigla, tipoColegiado, siglaComissao);
    }

    private Epigrafe parseEpigrafe(Element rootElement) {
        Node epigrafe = rootElement.selectSingleNode("/Epigrafe");
        String texto = epigrafe.valueOf("/@texto");
        String complemento = epigrafe.valueOf("/@complemento");
        return new EpigrafeRecord(texto, complemento);
    }

    private ComponenteEmendado parseComponente(Node componente) {
        String urn = componente.valueOf("/@urn");
        boolean articulado = componente.valueOf("/@articulado").equals("true");
        String tituloAnexo = componente.valueOf("/@tituloAnexo");
        String rotuloAnexo = componente.valueOf("/@rotuloAnexo");
        DispositivosEmendaRecord dispositivos = this.parseDispositivos(componente);
        return new ComponenteEmendadoRecord(urn, articulado, rotuloAnexo, tituloAnexo, dispositivos);
    }

    private DispositivosEmendaRecord parseDispositivos(Node componente) {
        Node dispositivos = componente.selectSingleNode("/Dispositivos");
        List<? extends DispositivoEmendaSuprimido> suprimidos = this.parseSuprimidos(dispositivos);
        List<? extends DispositivoEmendaModificado> modificados = this.parseModificados(dispositivos);
        List<? extends DispositivoEmendaAdicionado> adicionados = this.parseAdicionados(dispositivos);
        return new DispositivosEmendaRecord(suprimidos, modificados, adicionados);
    }

    private List<? extends DispositivoEmendaSuprimido> parseSuprimidos(Node dispositivos) {
        return dispositivos.selectNodes("/DispositivoSuprimido").stream().map(this::parseSuprimido).collect(Collectors.toList());
    }

    private DispositivoEmendaSuprimido parseSuprimido(Node suprimido) {
        String tipo = suprimido.valueOf("/@tipo");
        String id = suprimido.valueOf("/@id");
        String rotulo = suprimido.valueOf("/@rotulo");
        return new DispositivoEmendaSuprimidoRecord(tipo, id, rotulo);
    }

    private List<? extends DispositivoEmendaModificado> parseModificados(Node dispositivos) {
        return dispositivos.selectNodes("/DispositivoModificado").stream().map(this::parseModificado).collect(Collectors.toList());
    }

    private DispositivoEmendaModificado parseModificado(Node modificado) {
        String tipo = modificado.valueOf("/@tipo");
        String id = modificado.valueOf("/@id");
        String rotulo = modificado.valueOf("/@rotulo");
        String omitido = modificado.valueOf("/@textoOmitido");
        Boolean textoOmitido = omitido == null ? null : Boolean.valueOf(omitido.equals("true"));
        String aAspas = modificado.valueOf("/@abreAspas");
        Boolean abreAspas = aAspas == null ? null : Boolean.valueOf(aAspas.equals("true"));
        String fAspas = modificado.valueOf("/@abreAspas");
        Boolean fechaAspas = fAspas == null ? null : Boolean.valueOf(fAspas.equals("true"));
        NotaAlteracao nota = NotaAlteracao.parse(modificado.valueOf("/@notaAlteracao"));
        Node txt = modificado.selectSingleNode("/Texto");
        String texto = txt.getStringValue();
        return new DispositivoEmendaModificadoRecord(tipo, id, rotulo, texto, textoOmitido, abreAspas, fechaAspas, nota);
    }

    private List<? extends DispositivoEmendaAdicionado> parseAdicionados(Node dispositivos) {
        return dispositivos.selectNodes("/DispositivoAdicionado").stream().map(this::parseAdicionado).collect(Collectors.toList());
    }

    private DispositivoEmendaAdicionado parseAdicionado(Node adicionado) {
        boolean ondeCouber = adicionado.valueOf("/@ondeCouber").equals("true");
        String idPai = adicionado.valueOf("/@idPai");
        String idIrmao = adicionado.valueOf("/@idIrmaoAnterior");
        String tipo = adicionado.valueOf("/@tipo");
        String id = adicionado.valueOf("/@id");
        String rotulo = adicionado.valueOf("/@rotulo");
        String omitido = adicionado.valueOf("/@textoOmitido");
        Boolean textoOmitido = omitido == null ? null : Boolean.valueOf(omitido.equals("true"));
        String aAspas = adicionado.valueOf("/@abreAspas");
        Boolean abreAspas = aAspas == null ? null : Boolean.valueOf(aAspas.equals("true"));
        String fAspas = adicionado.valueOf("/@abreAspas");
        Boolean fechaAspas = fAspas == null ? null : Boolean.valueOf(fAspas.equals("true"));
        NotaAlteracao nota = NotaAlteracao.parse(adicionado.valueOf("/@notaAlteracao"));
        return null;
    }

    private ComandoEmenda parseComandoEmenda(Element rootElement) {
        Node comandoEmenda = rootElement.selectSingleNode("/ComandoEmenda");
        Node cabecalhoComumNode = comandoEmenda.selectSingleNode("/CabecalhoComum");
        String cabecalhoComum = cabecalhoComumNode == null ? null : cabecalhoComumNode.getStringValue();
        List<ItemComandoEmenda> itensComandoEmenda = this.parseItensComandoEmenda(comandoEmenda);
        return new ComandoEmendaRecord(cabecalhoComum, itensComandoEmenda);
    }

    private List<ItemComandoEmenda> parseItensComandoEmenda(Node comandoEmenda) {
        return comandoEmenda.selectNodes("/ItemComandoEmenda").stream().map(this::parseItem).collect(Collectors.toList());
    }

    private ItemComandoEmenda parseItem(Node itemComandoEmenda) {
        String rotulo = itemComandoEmenda.selectSingleNode("/Rotulo").getStringValue();
        String cabecalho = itemComandoEmenda.selectSingleNode("/Cabecalho").getStringValue();
        String citacao = itemComandoEmenda.selectSingleNode("/Citacao").getStringValue();
        String complemento = itemComandoEmenda.selectSingleNode("/Complemento").getStringValue();
        return new ItemComandoEmendaRecord(cabecalho, citacao, rotulo, complemento);
    }

    private String parseJustificativa(Element rootElement) {
        return rootElement.selectSingleNode("/Justificativa").getStringValue();
    }

    private Autoria parseAutoria(Element rootElement) {
        Node autoria = rootElement.selectSingleNode("/Autoria");
        TipoAutoria tipo = TipoAutoria.parse(autoria.valueOf("/@tipo"));
        boolean imprimirPartidoUF = autoria.valueOf("/@imprimirPartidoUF").equals("true");
        int quantidadeAssinaturasAdicionaisDeputados = Integer.parseInt(autoria.valueOf("/@quantidadeAssinaturasAdicionaisDeputados"));
        int quantidadeAssinaturasAdicionaisSenadores = Integer.parseInt(autoria.valueOf("/@quantidadeAssinaturasAdicionaisSenadores"));
        List<Parlamentar> parlamentares = this.parseParlamentares(autoria);
        ColegiadoAutor colegiado = this.parseColegiadoAutor(autoria);
        return new AutoriaRecord(tipo, imprimirPartidoUF, quantidadeAssinaturasAdicionaisSenadores, quantidadeAssinaturasAdicionaisDeputados, parlamentares, colegiado);
    }

    private List<Parlamentar> parseParlamentares(Node autoria) {
        return autoria.selectNodes("/Parlamentar").stream().map(this::parseParlamentar).collect(Collectors.toList());
    }

    private Parlamentar parseParlamentar(Node parlamentar) {
        String identificacao = parlamentar.valueOf("/@identificacao");
        String nome = parlamentar.valueOf("/@nome");
        Sexo sexo = Sexo.parse(parlamentar.valueOf("/@sexo"));
        String partido = parlamentar.valueOf("/@siglaPartido");
        String uf = parlamentar.valueOf("/@siglaUF");
        SiglaCasaLegislativa casa = SiglaCasaLegislativa.parse(parlamentar.valueOf("/@siglaCasaLegislativa"));
        String cargo = parlamentar.valueOf("/@cargo");
        return new ParlamentarRecord(identificacao, nome, sexo, partido, uf, casa, cargo);
    }

    private ColegiadoAutor parseColegiadoAutor(Node autoria) {
        Node colegiado = autoria.selectSingleNode("/Colegiado");
        if (colegiado == null) {
            return null;
        }
        String identificacao = colegiado.valueOf("/@identificacao");
        String nome = colegiado.valueOf("/@nome");
        String sigla = colegiado.valueOf("/@sigla");
        return new ColegiadoAutorRecord(identificacao, nome, sigla);
    }

    private OpcoesImpressao parseOpcoesImpressao(Element rootElement) {
        Node opcoes = rootElement.selectSingleNode("/OpcoesImpressao");
        boolean imprimirBrasao = opcoes.valueOf("/@imprimirBrasao").equals("true");
        String textoCabecalho = opcoes.valueOf("/@textoCabecalho");
        boolean reduzirEspacoEntreLinhas = opcoes.valueOf("/@reduzirEspacoEntreLinhas").equals("true");
        return new OpcoesImpressaoRecord(imprimirBrasao, textoCabecalho, reduzirEspacoEntreLinhas);
    }
}

