/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.eta.etaservices.parsing.xml;

import br.gov.lexml.eta.etaservices.emenda.Parlamentar;
import br.gov.lexml.eta.etaservices.emenda.Sexo;
import br.gov.lexml.eta.etaservices.emenda.SiglaCasaLegislativa;
import java.util.Objects;

public final class ParlamentarRecord
implements Parlamentar {
    private final String identificacao;
    private final String nome;
    private final Sexo sexo;
    private final String siglaPartido;
    private final String siglaUf;
    private final SiglaCasaLegislativa siglaCasaLegislativa;
    private final String cargo;

    public ParlamentarRecord(String identificacao, String nome, Sexo sexo, String siglaPartido, String siglaUf, SiglaCasaLegislativa siglaCasaLegislativa, String cargo) {
        this.identificacao = identificacao;
        this.nome = nome;
        this.sexo = sexo;
        this.siglaPartido = siglaPartido;
        this.siglaUf = siglaUf;
        this.siglaCasaLegislativa = siglaCasaLegislativa;
        this.cargo = cargo;
    }

    @Override
    public String getTratamento() {
        return this.siglaCasaLegislativa == SiglaCasaLegislativa.CD ? this.tratamentoCamara() : this.tratamentoSenado();
    }

    private String tratamentoCamara() {
        return this.sexo == Sexo.M ? "Deputado" : "Deputada";
    }

    private String tratamentoSenado() {
        return this.sexo == Sexo.M ? "Senador" : "Senadora";
    }

    @Override
    public String getIdentificacao() {
        return this.identificacao;
    }

    @Override
    public String getNome() {
        return this.nome;
    }

    @Override
    public Sexo getSexo() {
        return this.sexo;
    }

    @Override
    public String getSiglaPartido() {
        return this.siglaPartido;
    }

    @Override
    public String getSiglaUF() {
        return this.siglaUf;
    }

    @Override
    public SiglaCasaLegislativa getSiglaCasaLegislativa() {
        return this.siglaCasaLegislativa;
    }

    @Override
    public String getCargo() {
        return this.cargo;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ParlamentarRecord that = (ParlamentarRecord)obj;
        return Objects.equals(this.identificacao, that.identificacao) && Objects.equals(this.nome, that.nome) && Objects.equals((Object)this.sexo, (Object)that.sexo) && Objects.equals(this.siglaPartido, that.siglaPartido) && Objects.equals(this.siglaUf, that.siglaUf) && Objects.equals((Object)this.siglaCasaLegislativa, (Object)that.siglaCasaLegislativa) && Objects.equals(this.cargo, that.cargo);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identificacao, this.nome, this.sexo, this.siglaPartido, this.siglaUf, this.siglaCasaLegislativa, this.cargo});
    }

    public String toString() {
        return "Parlamentar[identificacao=" + this.identificacao + ", nome=" + this.nome + ", sexo=" + (Object)((Object)this.sexo) + ", siglaPartido=" + this.siglaPartido + ", siglaUf=" + this.siglaUf + ", siglaCasaLegislativa=" + (Object)((Object)this.siglaCasaLegislativa) + ", cargo=" + this.cargo + ']';
    }
}

