/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.eta.etaservices.printing.pdf;

import java.io.ByteArrayInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.tools.ant.filters.StringInputStream;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.SimpleXmlSerializer;
import org.htmlcleaner.TagNode;

public class HTML2FOConverter {
    private static final Log log = LogFactory.getLog(HTML2FOConverter.class);

    public static void main(String[] args) throws Exception {
        String html = IOUtils.toString((Reader)new FileReader("src/test/resources/table.html"));
        System.out.println(html);
        System.out.println("-----------------");
        System.out.println(new HTML2FOConverter().html2fo(html));
    }

    public String html2fo(String html) {
        String xhtml = this.html2xhtml(html);
        return this.xhtml2fo(xhtml);
    }

    private String html2xhtml(String html) {
        String ret;
        if (StringUtils.isEmpty((CharSequence)html)) {
            return "";
        }
        html = "<div>" + html + "</div>";
        CleanerProperties props = new CleanerProperties();
        props.setTranslateSpecialEntities(true);
        props.setTransResCharsToNCR(true);
        props.setOmitXmlDeclaration(true);
        props.setOmitHtmlEnvelope(true);
        props.setOmitComments(true);
        TagNode tagNode = new HtmlCleaner(props).clean(html);
        try {
            ret = new SimpleXmlSerializer(props).getAsString(tagNode);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        try {
            ret = this.trataTabelas(ret);
        }
        catch (Exception e) {
            log.warn((Object)"Falha no tratamento das tabelas.", (Throwable)e);
        }
        ret = ret.substring(5, ret.length() - 6);
        return ret;
    }

    private String xhtml2fo(String xhtml) {
        String ret;
        if (StringUtils.isEmpty((CharSequence)xhtml)) {
            return "";
        }
        try {
            xhtml = HTML2FOConverter.unescapeHtmlKeepingXMLEntities(xhtml);
            xhtml = xhtml.replaceAll("&(?![lg]t;)", "&amp;");
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer(new StreamSource(this.getClass().getResourceAsStream("/xhtml2fo.xsl")));
            xhtml = this.trataAlinhamentoDePragrafo(xhtml);
            xhtml = "<div>" + xhtml + "</div>";
            if (log.isDebugEnabled()) {
                log.debug((Object)("xhtml2fo: xhtml depois=\n" + xhtml));
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(xhtml.getBytes(StandardCharsets.UTF_8));
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            transformer.transform(new StreamSource(bis), new StreamResult((OutputStream)bos));
            ret = new String(bos.toByteArray(), StandardCharsets.UTF_8);
            ret = ret.substring(ret.indexOf(">") + 1);
            ret = ret.substring(0, ret.lastIndexOf("<"));
            if (log.isDebugEnabled()) {
                log.debug((Object)("xhtml2fo: xsl-fo=\n" + ret));
            }
        }
        catch (Exception e) {
            log.error((Object)"Falha na convers\u00e3o de XHTML para XSL-FO.", (Throwable)e);
            ret = "[Falha na formata\u00e7\u00e3o do campo. (" + e.getMessage() + ")]";
        }
        return ret;
    }

    private String trataAlinhamentoDePragrafo(String xhtml) {
        StringBuffer sb = new StringBuffer();
        Pattern tagPattern = Pattern.compile("<.+?>", 34);
        Matcher mTag = tagPattern.matcher(xhtml);
        Pattern alignClassPattern = Pattern.compile("class=\"align-(.+?)\"");
        String styleAttr = "style=\"";
        while (mTag.find()) {
            String tag = mTag.group();
            Matcher mClass = alignClassPattern.matcher(tag);
            if (mClass.find()) {
                String alignment = mClass.group(1);
                tag = tag.replace(mClass.group(), "");
                int i = tag.indexOf(styleAttr);
                String newStyle = "text-align: " + alignment + ";";
                if (alignment.equals("center") || alignment.equals("right")) {
                    newStyle = newStyle + " text-indent: 0;";
                }
                tag = i == -1 ? tag.replace(">", " style=\"" + newStyle + "\">") : tag.replace(styleAttr, styleAttr + newStyle + " ");
            }
            mTag.appendReplacement(sb, Matcher.quoteReplacement(tag));
        }
        mTag.appendTail(sb);
        return sb.toString();
    }

    private String trataTabelas(String ret) throws Exception {
        if (!ret.contains("table")) {
            return ret;
        }
        Document d = new SAXReader().read((InputStream)new StringInputStream(ret));
        List tables = d.selectNodes("//table");
        for (Node table : tables) {
            this.trataTabela((Element)table);
        }
        OutputFormat format = new OutputFormat();
        format.setSuppressDeclaration(true);
        StringWriter out = new StringWriter();
        XMLWriter writer = new XMLWriter(format);
        writer.setWriter((Writer)out);
        writer.write(d);
        writer.close();
        return out.toString();
    }

    private void trataTabela(Element table) {
        List rows = table.selectNodes("tbody/tr");
        TableMatrix m = new TableMatrix();
        for (Node r : rows) {
            m.nextRow();
            List cells = r.selectNodes("th|td");
            for (Node c : cells) {
                m.addCell(HTML2FOConverter.getCellInfo((Element)c));
            }
        }
        int qtColunas = m.getQtColunas();
        Element tbody = (Element)table.selectNodes("tbody").get(0);
        int qtLinhasOrig = rows.size();
        int qtLinhas = m.getQtLinhas();
        for (int i = qtLinhasOrig; i < qtLinhas; ++i) {
            tbody.addElement("tr");
        }
        rows = tbody.selectNodes("tr");
        int ri = 0;
        for (Node r : rows) {
            int qtCells;
            for (int i = qtCells = m.countCellsInRow(ri++); i < qtColunas; ++i) {
                ((Element)r).addElement("td");
            }
        }
        String colWidths = m.getColWidths();
        table.addAttribute("colwidths", colWidths);
    }

    private static Integer getWidth(Element e) {
        String styles = e.attributeValue("style");
        if (styles != null) {
            for (String style : styles.split(";")) {
                if (!style.trim().startsWith("width") || !style.contains(":")) continue;
                String strWidth = style.substring(style.indexOf(":") + 1).replaceAll("\\D", "");
                return Integer.parseInt(strWidth, 10);
            }
        }
        return 300;
    }

    private static int getIntegerAttribute(Element n, String attName, int defaultValue) {
        String strValue = n.attributeValue(attName);
        if (strValue != null) {
            try {
                return Integer.parseInt(strValue, 10);
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Esperado valor inteiro para o atributo '" + attName + "'. Valor encontrado '" + strValue + "'."));
            }
        }
        return defaultValue;
    }

    private static CellInfo getCellInfo(Element c) {
        CellInfo ci = new CellInfo();
        ci.width = HTML2FOConverter.getWidth(c);
        ci.colspan = HTML2FOConverter.getIntegerAttribute(c, "colspan", 1);
        ci.rowspan = HTML2FOConverter.getIntegerAttribute(c, "rowspan", 1);
        return ci;
    }

    public static String unescapeHtmlKeepingXMLEntities(String html) {
        html = html.replace("&#60;", "&lt;").replace("&#62;", "&gt;").replaceAll("&([gl]t;)", "&amp;$1");
        return StringEscapeUtils.unescapeHtml4((String)html);
    }

    private static class TableMatrix {
        final List<List<CellInfo>> t = new ArrayList<List<CellInfo>>();
        final List<Integer> qtCells = new ArrayList<Integer>();
        final List<Integer> rowWidths = new ArrayList<Integer>();
        final Map<String, CellInfo> pos = new HashMap<String, CellInfo>();
        int current = -1;
        int qtColunas = -1;

        private TableMatrix() {
        }

        public void nextRow() {
            ++this.current;
        }

        public int countCellsInRow(int ri) {
            int qtCells = 0;
            for (int ci = 0; ci < this.getQtColunas(); ++ci) {
                CellInfo cell = this.pos.get(ri + "," + ci);
                if (cell == null) continue;
                ++qtCells;
            }
            return qtCells;
        }

        public void addCell(CellInfo cellInfo) {
            List<CellInfo> r = this.getRow(cellInfo);
            r.add(cellInfo);
            for (int i = 0; i < cellInfo.rowspan; ++i) {
                int ri = this.current + i;
                this.qtCells.set(ri, this.qtCells.get(ri) + cellInfo.colspan);
                this.rowWidths.set(ri, this.rowWidths.get(ri) + cellInfo.width);
            }
            int ri = this.current;
            int ci = r.size() - 1;
            while (this.pos.get(ri + "," + ci) != null) {
                ++ci;
            }
            for (int dri = 0; dri < cellInfo.rowspan; ++dri) {
                for (int dci = 0; dci < cellInfo.colspan; ++dci) {
                    this.pos.put(ri + dri + "," + (ci + dci), cellInfo);
                }
            }
        }

        private List<CellInfo> getRow(CellInfo cellInfo) {
            int rimax = this.current + cellInfo.rowspan - 1;
            if (rimax >= this.t.size()) {
                for (int j = this.t.size(); j <= rimax; ++j) {
                    this.t.add(new ArrayList());
                    this.qtCells.add(0);
                    this.rowWidths.add(0);
                }
            }
            return this.t.get(this.current);
        }

        public int getQtLinhas() {
            return this.t.size();
        }

        public int getQtColunas() {
            if (this.qtColunas == -1) {
                this.qtColunas = this.qtCells.stream().mapToInt(Integer::intValue).max().orElse(0);
            }
            return this.qtColunas;
        }

        public String getColWidths() {
            Object[] colWidths = new Integer[this.getQtColunas()];
            Arrays.fill(colWidths, (Object)0);
            for (int ci = 0; ci < colWidths.length; ++ci) {
                colWidths[ci] = this.calculaLarguraColuna(ci);
            }
            return StringUtils.join((Object[])colWidths, (String)",");
        }

        private int calculaLarguraColuna(int ci) {
            int sum;
            CellInfo cell;
            int ri;
            int qtLinhas = this.getQtLinhas();
            ArrayList<Integer> larguras = new ArrayList<Integer>();
            for (ri = 0; ri < qtLinhas; ++ri) {
                cell = this.pos.get(ri + "," + ci);
                if (cell == null || cell.colspan != 1) continue;
                larguras.add(cell.width);
            }
            if (!larguras.isEmpty()) {
                sum = larguras.stream().mapToInt(Integer::intValue).sum();
                return sum / larguras.size();
            }
            for (ri = 0; ri < qtLinhas; ++ri) {
                cell = this.pos.get(ri + "," + ci);
                if (cell == null) continue;
                larguras.add(cell.width / cell.rowspan);
            }
            sum = larguras.stream().mapToInt(Integer::intValue).sum();
            return sum / larguras.size();
        }
    }

    private static class CellInfo {
        int width;
        int colspan = 1;
        int rowspan = 1;

        private CellInfo() {
        }

        public String toString() {
            return "w: " + this.width + ", c: " + this.colspan + ", r: " + this.rowspan;
        }
    }
}

