/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.eta.etaservices.printing.pdf;

import br.gov.lexml.eta.etaservices.emenda.Emenda;
import br.gov.lexml.eta.etaservices.printing.pdf.FOPProcessor;
import br.gov.lexml.eta.etaservices.printing.pdf.PdfGenerator;
import br.gov.lexml.eta.etaservices.printing.pdf.VelocityTemplateProcessor;
import br.gov.lexml.eta.etaservices.printing.xml.EmendaXmlMarshaller;
import java.io.IOException;
import java.io.OutputStream;

public class PdfGeneratorBean
implements PdfGenerator {
    private final VelocityTemplateProcessor templateProcessor;
    private final EmendaXmlMarshaller emendaXmlMarshaller;

    public PdfGeneratorBean(VelocityTemplateProcessor templateProcessor, EmendaXmlMarshaller emendaXmlMarshaller) {
        this.templateProcessor = templateProcessor;
        this.emendaXmlMarshaller = emendaXmlMarshaller;
    }

    @Override
    public void generate(Emenda emenda, OutputStream outputStream) throws IOException {
        String xml = this.emendaXmlMarshaller.toXml(emenda);
        String templateResult = this.templateProcessor.getTemplateResult(emenda);
        new FOPProcessor().processFOP(outputStream, templateResult, xml);
    }
}

