/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.eta.etaservices.emenda;

import br.gov.lexml.eta.etaservices.emenda.Emenda;
import br.gov.lexml.eta.etaservices.emenda.EmendaJsonGenerator;
import br.gov.lexml.eta.etaservices.parsing.xml.EmendaXmlUnmarshaller;
import br.gov.lexml.pdfa.PDFAttachmentHelper;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.IOUtils;

public class EmendaJsonGeneratorBean
implements EmendaJsonGenerator {
    @Override
    public void extractJsonFromPdf(InputStream pdfStream, Writer jsonWriter) throws Exception {
        Path attachmentsDirPath = Files.createTempDirectory("extractJsonFromPdf", new FileAttribute[0]);
        File pdfFile = new File(attachmentsDirPath.toFile(), "emenda.pdf");
        IOUtils.copy((InputStream)pdfStream, (OutputStream)new FileOutputStream(pdfFile));
        PDFAttachmentHelper.extractAttachments((String)pdfFile.getPath(), (String)attachmentsDirPath.toAbsolutePath().toString());
        File xmlFile = new File(attachmentsDirPath.toFile(), "emenda.xml");
        String xml = IOUtils.toString((InputStream)new FileInputStream(xmlFile), (String)StandardCharsets.UTF_8.name());
        Emenda e = new EmendaXmlUnmarshaller().fromXml(xml);
        this.writeJson(e, jsonWriter);
    }

    @Override
    public void writeJson(Emenda e, Writer writer) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        ObjectWriter objectWriter = objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL).registerModule((Module)new JavaTimeModule()).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).writerWithDefaultPrettyPrinter().forType(Emenda.class);
        JsonGenerator jsonGenerator = objectWriter.createGenerator(writer);
        jsonGenerator.writeObject((Object)e);
        jsonGenerator.flush();
    }
}

