/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.eta.etaservices.printing.pdf;

import br.gov.lexml.eta.etaservices.printing.pdf.FOHelper;
import br.gov.lexml.pdfa.PDFA;
import br.gov.lexml.pdfa.PDFAttachmentFile;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Date;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopConfParser;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.FopFactoryBuilder;
import org.apache.fop.pdf.PDFAMode;
import org.apache.xmlgraphics.io.Resource;
import org.apache.xmlgraphics.io.ResourceResolver;
import org.dom4j.io.DocumentSource;
import org.springframework.core.io.ClassPathResource;

public class FOPProcessor {
    private static final Log log = LogFactory.getLog(FOPProcessor.class);
    private static FopFactory fopFactory;

    public void processFOP(OutputStream outputStream, String xslFo, String emendaXML) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            FOUserAgent foUserAgent = fopFactory.newFOUserAgent();
            FOHelper helper = new FOHelper(xslFo);
            DocumentSource src = new DocumentSource(helper.getFOPDocumentWithoutXmpmeta());
            if (helper.isPDFAMode()) {
                foUserAgent.getRendererOptions().put("pdf-a-mode", PDFAMode.PDFA_3B.getName());
                foUserAgent.setAccessibility(true);
                String cmpCreateDate = helper.getCmpCreateDate();
                if (cmpCreateDate == null) {
                    log.info((Object)"cmpCreateDate is null");
                } else {
                    Date date = Date.from(ZonedDateTime.parse(cmpCreateDate).toInstant());
                    foUserAgent.setCreationDate(date);
                }
            }
            Fop fop = fopFactory.newFop("application/pdf", foUserAgent, (OutputStream)out);
            SAXResult res = new SAXResult(fop.getDefaultHandler());
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform((Source)src, res);
            byte[] data = out.toByteArray();
            PDFA pdfa = PDFA.getNewInstance((OutputStream)outputStream, (InputStream)new ByteArrayInputStream(data), (String)helper.getPDFAPart(), (String)helper.getPDFAConformance());
            if (pdfa == null) {
                log.error((Object)("Could not find a PDF/A part " + helper.getPDFAPart() + ", conformance " + helper.getPDFAConformance() + " constructor on PDFA class."));
            } else {
                pdfa.addXMP(helper.getXmpmeta().getBytes());
                pdfa.addAttachments(new PDFAttachmentFile[]{new PDFAttachmentFile(emendaXML.getBytes(), "emenda.xml", "text/xml", helper.getCmpCreateDate(), PDFAttachmentFile.AFRelationShip.SOURCE)});
                pdfa.setVersion(PDFA.PDFVersion.PDF_VERSION_1_7);
                pdfa.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error processing FOP. " + e.getMessage(), e);
        }
    }

    static {
        try {
            InputStream xconf = FOPProcessor.class.getResourceAsStream("/fop.xconf");
            ClasspathUriResolver resolver = new ClasspathUriResolver();
            FopConfParser parser = new FopConfParser(xconf, new URI("file://."), (ResourceResolver)resolver);
            FopFactoryBuilder builder = parser.getFopFactoryBuilder();
            fopFactory = builder.build();
        }
        catch (Exception e) {
            log.fatal((Object)"N\u00e3o foi poss\u00edvel configurar o FOP.", (Throwable)e);
        }
    }

    static class ClasspathUriResolver
    implements ResourceResolver {
        ClasspathUriResolver() {
        }

        public OutputStream getOutputStream(URI arg0) {
            return null;
        }

        public Resource getResource(URI uri) {
            String strUri = uri.toString().replaceAll("^file://\\.", "");
            try {
                ClassPathResource resource = new ClassPathResource("pdfa-fonts/" + strUri);
                InputStream inputStream = resource.getInputStream();
                if (inputStream != null) {
                    return new Resource("image/x-afp+truetype", inputStream);
                }
            }
            catch (Exception e) {
                log.error((Object)("Arquivo de fonte /pdfa-fonts/" + strUri + " n\u00e3o encontrado."));
            }
            return null;
        }
    }
}

