/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.eta.etaservices.emenda;

import br.gov.lexml.eta.etaservices.emenda.Emenda;
import br.gov.lexml.eta.etaservices.emenda.EmendaJsonGenerator;
import br.gov.lexml.eta.etaservices.parsing.xml.EmendaXmlUnmarshaller;
import br.gov.lexml.eta.etaservices.util.EtaBackendException;
import br.gov.lexml.pdfa.PDFAttachmentHelper;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.IOUtils;

public class EmendaJsonGeneratorBean
implements EmendaJsonGenerator {
    @Override
    public void extractJsonFromPdf(InputStream pdfStream, Writer jsonWriter) throws Exception {
        Path attachmentsDirPath = Files.createTempDirectory("extractJsonFromPdf", new FileAttribute[0]);
        File pdfFile = new File(attachmentsDirPath.toFile(), "emenda.pdf");
        try (OutputStream fos = Files.newOutputStream(pdfFile.toPath(), new OpenOption[0]);){
            IOUtils.copy((InputStream)pdfStream, (OutputStream)fos);
        }
        try {
            PDFAttachmentHelper.extractAttachments((String)pdfFile.getPath(), (String)attachmentsDirPath.toAbsolutePath().toString());
        }
        catch (Exception e) {
            throw new EtaBackendException("N\u00e3o se trata de um arquivo gerado pelo editor de emendas.", e);
        }
        File xmlFile = new File(attachmentsDirPath.toFile(), "emenda.xml");
        if (!xmlFile.isFile()) {
            throw new EtaBackendException("N\u00e3o se trata de um arquivo gerado pelo editor de emendas.");
        }
        try (InputStream fin = Files.newInputStream(xmlFile.toPath(), new OpenOption[0]);){
            String xml = IOUtils.toString((InputStream)fin, (Charset)StandardCharsets.UTF_8);
            Emenda e = new EmendaXmlUnmarshaller().fromXml(xml);
            this.writeJson(e, jsonWriter);
        }
    }

    @Override
    public void writeJson(Emenda e, Writer writer) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        ObjectWriter objectWriter = objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL).registerModule((Module)new JavaTimeModule()).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).writerWithDefaultPrettyPrinter().forType(Emenda.class);
        try (JsonGenerator jsonGenerator = objectWriter.createGenerator(writer);){
            jsonGenerator.writeObject((Object)e);
            jsonGenerator.flush();
        }
    }
}

