/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.eta.etaservices.printing.pdf;

import br.gov.lexml.eta.etaservices.emenda.Emenda;
import br.gov.lexml.eta.etaservices.printing.pdf.TemplateLoader;
import br.gov.lexml.eta.etaservices.printing.pdf.VelocityExtension;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VelocityTemplateProcessor {
    private static final Logger log = LoggerFactory.getLogger(VelocityTemplateProcessor.class);
    private static final String TEMPLATE_RESOURCE = "/template-velocity-emenda.xml";
    private final TemplateLoader templateLoader;
    private String velocityResult;

    public VelocityTemplateProcessor(TemplateLoader templateLoader) {
        this.templateLoader = templateLoader;
    }

    public String getTemplateResult(Emenda emenda) throws IOException {
        if (this.velocityResult == null) {
            String finalTemplate = this.templateLoader.loadTemplate(TEMPLATE_RESOURCE);
            if (log.isDebugEnabled()) {
                log.debug("finalTemplate: {}", (Object)finalTemplate);
            }
            this.velocityResult = this.getVelocityResult(finalTemplate, emenda);
        }
        return this.velocityResult;
    }

    private String getVelocityResult(String template, Emenda emenda) {
        VelocityEngine ve = new VelocityEngine();
        ve.setProperty("runtime.log.logsystem.log4j.logger", (Object)this.getClass().getName());
        ve.init();
        VelocityContext ctx = new VelocityContext();
        VelocityExtension vex = new VelocityExtension(ctx, ve);
        ctx.put("emenda", (Object)emenda);
        ctx.put("ve", (Object)vex);
        if (emenda.getNotasRodape() != null && !emenda.getNotasRodape().isEmpty()) {
            emenda.getNotasRodape().forEach(nr -> ctx.put(nr.getId(), (Object)vex.html2fo(nr.getTexto())));
        }
        StringWriter w = new StringWriter();
        ve.evaluate((Context)ctx, (Writer)w, "defaultTemplate", template);
        String result = w.toString();
        if (StringUtils.isEmpty((CharSequence)result)) {
            return "";
        }
        result = result.replaceAll("\\s{2,}", " ");
        result = result.replaceAll("\\s([.,;:!?])", "$1");
        log.debug("getVelocityResult: {}", (Object)result);
        return result;
    }
}

