/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.eta.etaservices.parsing.xml;

import br.gov.lexml.eta.etaservices.emenda.Anexo;
import br.gov.lexml.eta.etaservices.emenda.Autoria;
import br.gov.lexml.eta.etaservices.emenda.ColegiadoApreciador;
import br.gov.lexml.eta.etaservices.emenda.ColegiadoAutor;
import br.gov.lexml.eta.etaservices.emenda.ComandoEmenda;
import br.gov.lexml.eta.etaservices.emenda.ComandoEmendaTextoLivre;
import br.gov.lexml.eta.etaservices.emenda.ComponenteEmendado;
import br.gov.lexml.eta.etaservices.emenda.DispositivoEmendaAdicionado;
import br.gov.lexml.eta.etaservices.emenda.DispositivoEmendaModificado;
import br.gov.lexml.eta.etaservices.emenda.DispositivoEmendaSuprimido;
import br.gov.lexml.eta.etaservices.emenda.Emenda;
import br.gov.lexml.eta.etaservices.emenda.Epigrafe;
import br.gov.lexml.eta.etaservices.emenda.ItemComandoEmenda;
import br.gov.lexml.eta.etaservices.emenda.ModoEdicaoEmenda;
import br.gov.lexml.eta.etaservices.emenda.NotaAlteracao;
import br.gov.lexml.eta.etaservices.emenda.OpcoesImpressao;
import br.gov.lexml.eta.etaservices.emenda.Parlamentar;
import br.gov.lexml.eta.etaservices.emenda.RefProposicaoEmendada;
import br.gov.lexml.eta.etaservices.emenda.Revisao;
import br.gov.lexml.eta.etaservices.emenda.Sexo;
import br.gov.lexml.eta.etaservices.emenda.SiglaCasaLegislativa;
import br.gov.lexml.eta.etaservices.emenda.TipoAutoria;
import br.gov.lexml.eta.etaservices.emenda.TipoColegiado;
import br.gov.lexml.eta.etaservices.parsing.xml.AnexoRecord;
import br.gov.lexml.eta.etaservices.parsing.xml.AtributosEmenda;
import br.gov.lexml.eta.etaservices.parsing.xml.AutoriaRecord;
import br.gov.lexml.eta.etaservices.parsing.xml.ColegiadoApreciadorRecord;
import br.gov.lexml.eta.etaservices.parsing.xml.ColegiadoAutorRecord;
import br.gov.lexml.eta.etaservices.parsing.xml.ComandoEmendaRecord;
import br.gov.lexml.eta.etaservices.parsing.xml.ComandoEmendaTextoLivreRecord;
import br.gov.lexml.eta.etaservices.parsing.xml.ComponenteEmendadoRecord;
import br.gov.lexml.eta.etaservices.parsing.xml.DispositivoEmendaAdicionadoRecord;
import br.gov.lexml.eta.etaservices.parsing.xml.DispositivoEmendaModificadoRecord;
import br.gov.lexml.eta.etaservices.parsing.xml.DispositivoEmendaSuprimidoRecord;
import br.gov.lexml.eta.etaservices.parsing.xml.DispositivosEmendaRecord;
import br.gov.lexml.eta.etaservices.parsing.xml.EmendaRecord;
import br.gov.lexml.eta.etaservices.parsing.xml.EpigrafeRecord;
import br.gov.lexml.eta.etaservices.parsing.xml.ItemComandoEmendaRecord;
import br.gov.lexml.eta.etaservices.parsing.xml.Metadados;
import br.gov.lexml.eta.etaservices.parsing.xml.OpcoesImpressaoRecord;
import br.gov.lexml.eta.etaservices.parsing.xml.ParlamentarRecord;
import br.gov.lexml.eta.etaservices.parsing.xml.RefProposicaoEmendadaRecord;
import br.gov.lexml.eta.etaservices.printing.json.RevisaoElementoPojo;
import br.gov.lexml.eta.etaservices.printing.json.RevisaoJustificativaPojo;
import br.gov.lexml.eta.etaservices.printing.json.RevisaoPojo;
import br.gov.lexml.eta.etaservices.printing.json.RevisaoTextoLivrePojo;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class EmendaXmlUnmarshaller {
    public Emenda fromXml(String xml) throws DocumentException {
        SAXReader reader = new SAXReader();
        Document doc = reader.read((Reader)new StringReader(xml));
        return this.parseEmenda(doc.getRootElement());
    }

    private Emenda parseEmenda(Element rootElement) {
        AtributosEmenda atributosEmenda = this.parseAtributosEmenda(rootElement);
        Metadados metadados = this.parseMetadados(rootElement);
        RefProposicaoEmendada proposicao = this.parseProposicao(rootElement);
        ColegiadoApreciador colegiadoApreciador = this.parseColegiado(rootElement);
        Epigrafe epigrafe = this.parseEpigrafe(rootElement);
        List<? extends ComponenteEmendado> componentes = this.parseComponentes(rootElement);
        List<? extends Anexo> anexos = this.parseAnexos(rootElement);
        ComandoEmendaTextoLivre comandoEmendaTextoLivre = this.parseComandoEmendaTextoLivre(rootElement);
        ComandoEmenda comandoEmenda = this.parseComandoEmenda(rootElement);
        String justificativa = this.parseJustificativa(rootElement);
        Autoria autoria = this.parseAutoria(rootElement);
        OpcoesImpressao opcoesImpressao = this.parseOpcoesImpressao(rootElement);
        List<? extends Revisao> revisoes = this.parseRevisoes(rootElement);
        return new EmendaRecord(metadados.getDataUltimaModificacao(), metadados.getAplicacao(), metadados.getVersaoAplicacao(), metadados.getModoEdicao(), metadados.getMeta(), proposicao, colegiadoApreciador, epigrafe, componentes, comandoEmenda, comandoEmendaTextoLivre, anexos, justificativa, atributosEmenda.getLocal(), atributosEmenda.getData(), autoria, opcoesImpressao, revisoes);
    }

    private List<? extends ComponenteEmendado> parseComponentes(Element rootElement) {
        List nodes = rootElement.selectNodes("Componente");
        return nodes.stream().map(this::parseComponente).collect(Collectors.toList());
    }

    private List<? extends Anexo> parseAnexos(Element rootElement) {
        List nodes = rootElement.selectNodes("Anexo");
        return nodes.stream().map(this::parseAnexo).collect(Collectors.toList());
    }

    private AtributosEmenda parseAtributosEmenda(Element rootElement) {
        String local = rootElement.attributeValue("local");
        String dataAttribute = rootElement.attributeValue("data");
        LocalDate data = dataAttribute != null ? LocalDate.parse(dataAttribute) : null;
        return new AtributosEmenda(local, data);
    }

    private Metadados parseMetadados(Element rootElement) {
        List metadados = rootElement.selectNodes("Metadados/*");
        Instant dataUltimaModificacao = Instant.now();
        String aplicacao = "";
        String versaoAplicacao = "";
        ModoEdicaoEmenda modoEdicao = ModoEdicaoEmenda.EMENDA;
        LinkedHashMap<String, Object> meta = new LinkedHashMap<String, Object>();
        block12: for (Node n : metadados) {
            switch (n.getName()) {
                case "DataUltimaModificacao": {
                    String dt = n.getStringValue().trim();
                    dataUltimaModificacao = Instant.parse(dt);
                    continue block12;
                }
                case "Aplicacao": {
                    aplicacao = n.getStringValue();
                    continue block12;
                }
                case "VersaoAplicacao": {
                    versaoAplicacao = n.getStringValue();
                    continue block12;
                }
                case "ModoEdicao": {
                    String me = n.getStringValue();
                    modoEdicao = ModoEdicaoEmenda.parse(me);
                    continue block12;
                }
            }
            meta.put(n.getName(), n.getStringValue());
        }
        return new Metadados(dataUltimaModificacao, aplicacao, versaoAplicacao, modoEdicao, meta);
    }

    private RefProposicaoEmendada parseProposicao(Element rootElement) {
        Element proposicao = (Element)rootElement.selectSingleNode("Proposicao");
        String urn = proposicao.attributeValue("urn");
        String sigla = proposicao.attributeValue("sigla");
        String numero = proposicao.attributeValue("numero");
        String ano = proposicao.attributeValue("ano");
        String ementa = proposicao.attributeValue("ementa");
        String identificacaoTexto = proposicao.attributeValue("identificacaoTexto");
        return new RefProposicaoEmendadaRecord(urn, sigla, numero, ano, ementa, identificacaoTexto);
    }

    private ColegiadoApreciador parseColegiado(Element rootElement) {
        Element colegiado = (Element)rootElement.selectSingleNode("ColegiadoApreciador");
        SiglaCasaLegislativa sigla = SiglaCasaLegislativa.parse(colegiado.attributeValue("siglaCasaLegislativa"));
        TipoColegiado tipoColegiado = TipoColegiado.parse(colegiado.attributeValue("tipoColegiado"));
        String siglaComissao = colegiado.attributeValue("siglaComissao");
        return new ColegiadoApreciadorRecord(sigla, tipoColegiado, siglaComissao);
    }

    private Epigrafe parseEpigrafe(Element rootElement) {
        Element epigrafe = (Element)rootElement.selectSingleNode("Epigrafe");
        String texto = epigrafe.attributeValue("texto");
        String complemento = epigrafe.attributeValue("complemento");
        return new EpigrafeRecord(texto, complemento);
    }

    private ComponenteEmendado parseComponente(Node nodeComponente) {
        Element componente = (Element)nodeComponente;
        String urn = componente.attributeValue("urn");
        boolean articulado = this.booleanAttributeValue(componente.attributeValue("articulado"));
        String tituloAnexo = componente.attributeValue("tituloAnexo");
        String rotuloAnexo = componente.attributeValue("rotuloAnexo");
        DispositivosEmendaRecord dispositivos = this.parseDispositivos((Node)componente);
        return new ComponenteEmendadoRecord(urn, articulado, rotuloAnexo, tituloAnexo, dispositivos);
    }

    private Anexo parseAnexo(Node nodeComponente) {
        Element componente = (Element)nodeComponente;
        String nomeArquivo = componente.attributeValue("nomeArquivo");
        String base64 = componente.attributeValue("base64");
        return new AnexoRecord(nomeArquivo, base64);
    }

    private DispositivosEmendaRecord parseDispositivos(Node componente) {
        Node dispositivos = componente.selectSingleNode("Dispositivos");
        List<? extends DispositivoEmendaSuprimido> suprimidos = this.parseSuprimidos(dispositivos);
        List<? extends DispositivoEmendaModificado> modificados = this.parseModificados(dispositivos);
        List<? extends DispositivoEmendaAdicionado> adicionados = this.parseAdicionados(dispositivos);
        return new DispositivosEmendaRecord(suprimidos, modificados, adicionados);
    }

    private List<? extends DispositivoEmendaSuprimido> parseSuprimidos(Node dispositivos) {
        return dispositivos.selectNodes("DispositivoSuprimido").stream().map(this::parseSuprimido).collect(Collectors.toList());
    }

    private DispositivoEmendaSuprimido parseSuprimido(Node nodeSuprimido) {
        Element suprimido = (Element)nodeSuprimido;
        String tipo = suprimido.attributeValue("tipo");
        String id = suprimido.attributeValue("id");
        String rotulo = suprimido.attributeValue("rotulo");
        String urnNormaAlterada = suprimido.attributeValue("base");
        return new DispositivoEmendaSuprimidoRecord(tipo, id, rotulo, urnNormaAlterada);
    }

    private List<? extends DispositivoEmendaModificado> parseModificados(Node dispositivos) {
        return dispositivos.selectNodes("DispositivoModificado").stream().map(this::parseModificado).collect(Collectors.toList());
    }

    private DispositivoEmendaModificado parseModificado(Node nodeModificado) {
        Element modificado = (Element)nodeModificado;
        String tipo = modificado.attributeValue("tipo");
        String id = modificado.attributeValue("id");
        String rotulo = modificado.attributeValue("rotulo");
        Boolean textoOmitido = this.booleanAttributeValue(modificado.attributeValue("textoOmitido"));
        Boolean abreAspas = this.booleanAttributeValue(modificado.attributeValue("abreAspas"));
        Boolean fechaAspas = this.booleanAttributeValue(modificado.attributeValue("fechaAspas"));
        NotaAlteracao nota = NotaAlteracao.parse(modificado.attributeValue("notaAlteracao"));
        String texto = this.nodeContentWithTags(modificado.selectSingleNode("Texto"));
        String urnNormaAlterada = modificado.attributeValue("base");
        return new DispositivoEmendaModificadoRecord(tipo, id, rotulo, texto, textoOmitido, abreAspas, fechaAspas, nota, urnNormaAlterada);
    }

    private List<? extends DispositivoEmendaAdicionado> parseAdicionados(Node dispositivos) {
        return dispositivos.selectNodes("DispositivoAdicionado").stream().map(this::parseAdicionado).collect(Collectors.toList());
    }

    private DispositivoEmendaAdicionadoRecord parseAdicionado(Node nodeAdicionado) {
        Element adicionado = (Element)nodeAdicionado;
        boolean ondeCouber = this.booleanAttributeValue(adicionado.attributeValue("ondeCouber"));
        String idPai = adicionado.attributeValue("idPai");
        String idIrmaoAnterior = adicionado.attributeValue("idIrmaoAnterior");
        String idPosicaoAgrupador = adicionado.attributeValue("idPosicaoAgrupador");
        Node filho = nodeAdicionado.selectSingleNode("*");
        return this.parseAdicionadoLexml(filho, ondeCouber, idPai, idIrmaoAnterior, idPosicaoAgrupador);
    }

    private DispositivoEmendaAdicionadoRecord parseAdicionadoLexml(Node nodeAdicionado, boolean ondeCouber, String idPai, String idIrmaoAnterior, String idPosicaoAgrupador) {
        Element adicionado = (Element)nodeAdicionado;
        String tipo = adicionado.getName();
        String id = adicionado.attributeValue("id");
        Boolean textoOmitido = this.booleanAttributeValue(adicionado.attributeValue("textoOmitido"));
        Boolean abreAspas = this.booleanAttributeValue(adicionado.attributeValue("abreAspas"));
        Boolean fechaAspas = this.booleanAttributeValue(adicionado.attributeValue("fechaAspas"));
        NotaAlteracao notaAlteracao = NotaAlteracao.parse(adicionado.attributeValue("notaAlteracao"));
        String urnNormaAlterada = adicionado.attributeValue("base");
        Boolean existeNaNormaAlterada = this.booleanAttributeValue(adicionado.attributeValue("existeNaNormaAlterada"));
        String rotulo = this.nodeStringValue(adicionado.selectSingleNode("Rotulo"));
        String texto = this.nodeContentWithTags(adicionado.selectSingleNode("p"));
        String uuid2 = adicionado.attributeValue("uuid2");
        List nodesFilhos = adicionado.selectNodes("*[not(self::Rotulo or self::p)]");
        List<DispositivoEmendaAdicionadoRecord> filhos = nodesFilhos.stream().map(this::parseAdicionadoLexml).collect(Collectors.toList());
        return new DispositivoEmendaAdicionadoRecord(tipo, id, rotulo, texto, textoOmitido, abreAspas, fechaAspas, notaAlteracao, ondeCouber, idPai, idIrmaoAnterior, idPosicaoAgrupador, urnNormaAlterada, existeNaNormaAlterada, filhos, uuid2);
    }

    private DispositivoEmendaAdicionadoRecord parseAdicionadoLexml(Node nodeAdicionado) {
        return this.parseAdicionadoLexml(nodeAdicionado, false, null, null, null);
    }

    private ComandoEmenda parseComandoEmenda(Element rootElement) {
        Node comandoEmenda = rootElement.selectSingleNode("ComandoEmenda");
        Node cabecalhoComumNode = comandoEmenda.selectSingleNode("CabecalhoComum");
        String cabecalhoComum = this.nodeContentWithTags(cabecalhoComumNode);
        List<ItemComandoEmenda> itensComandoEmenda = this.parseItensComandoEmenda(comandoEmenda);
        return new ComandoEmendaRecord(cabecalhoComum, itensComandoEmenda);
    }

    private ComandoEmendaTextoLivre parseComandoEmendaTextoLivre(Element rootElement) {
        Node comandoEmendaTextoLivre = rootElement.selectSingleNode("ComandoEmendaTextoLivre");
        if (comandoEmendaTextoLivre == null) {
            return null;
        }
        String motivo = ((Element)comandoEmendaTextoLivre).attributeValue("motivo");
        String texto = this.nodeStringValue(comandoEmendaTextoLivre);
        return new ComandoEmendaTextoLivreRecord(motivo, texto);
    }

    private List<ItemComandoEmenda> parseItensComandoEmenda(Node comandoEmenda) {
        return comandoEmenda.selectNodes("ItemComandoEmenda").stream().map(this::parseItem).collect(Collectors.toList());
    }

    private ItemComandoEmenda parseItem(Node itemComandoEmenda) {
        String rotulo = this.nodeStringValue(itemComandoEmenda.selectSingleNode("Rotulo"));
        String cabecalho = this.nodeContentWithTags(itemComandoEmenda.selectSingleNode("Cabecalho"));
        String citacao = this.nodeContentWithTags(itemComandoEmenda.selectSingleNode("Citacao"));
        String complemento = this.nodeContentWithTags(itemComandoEmenda.selectSingleNode("Complemento"));
        return new ItemComandoEmendaRecord(cabecalho, citacao, rotulo, complemento);
    }

    private String parseJustificativa(Element rootElement) {
        return this.nodeStringValue(rootElement.selectSingleNode("Justificativa"));
    }

    private Autoria parseAutoria(Element rootElement) {
        Element autoria = (Element)rootElement.selectSingleNode("Autoria");
        TipoAutoria tipo = TipoAutoria.parse(autoria.attributeValue("tipo"));
        boolean imprimirPartidoUF = this.booleanAttributeValue(autoria.attributeValue("imprimirPartidoUF"));
        int quantidadeAssinaturasAdicionaisDeputados = Integer.parseInt(autoria.attributeValue("quantidadeAssinaturasAdicionaisDeputados"));
        int quantidadeAssinaturasAdicionaisSenadores = Integer.parseInt(autoria.attributeValue("quantidadeAssinaturasAdicionaisSenadores"));
        List<Parlamentar> parlamentares = this.parseParlamentares((Node)autoria);
        ColegiadoAutor colegiado = this.parseColegiadoAutor((Node)autoria);
        return new AutoriaRecord(tipo, imprimirPartidoUF, quantidadeAssinaturasAdicionaisSenadores, quantidadeAssinaturasAdicionaisDeputados, parlamentares, colegiado);
    }

    private List<Parlamentar> parseParlamentares(Node autoria) {
        return autoria.selectNodes("Parlamentar").stream().map(this::parseParlamentar).collect(Collectors.toList());
    }

    private Parlamentar parseParlamentar(Node nodeParlamentar) {
        Element parlamentar = (Element)nodeParlamentar;
        String identificacao = parlamentar.attributeValue("identificacao");
        String nome = parlamentar.attributeValue("nome");
        Sexo sexo = Sexo.parse(parlamentar.attributeValue("sexo"));
        String partido = parlamentar.attributeValue("siglaPartido");
        String uf = parlamentar.attributeValue("siglaUF");
        SiglaCasaLegislativa casa = SiglaCasaLegislativa.parse(parlamentar.attributeValue("siglaCasaLegislativa"));
        String cargo = parlamentar.attributeValue("cargo");
        return new ParlamentarRecord(identificacao, nome, sexo, partido, uf, casa, cargo);
    }

    private ColegiadoAutor parseColegiadoAutor(Node autoria) {
        Element colegiado = (Element)autoria.selectSingleNode("Colegiado");
        if (colegiado == null) {
            return null;
        }
        String identificacao = colegiado.attributeValue("identificacao");
        String nome = colegiado.attributeValue("nome");
        String sigla = colegiado.attributeValue("sigla");
        return new ColegiadoAutorRecord(identificacao, nome, sigla);
    }

    private OpcoesImpressao parseOpcoesImpressao(Element rootElement) {
        Element opcoes = (Element)rootElement.selectSingleNode("OpcoesImpressao");
        boolean imprimirBrasao = this.booleanAttributeValue(opcoes.attributeValue("imprimirBrasao"));
        String textoCabecalho = opcoes.attributeValue("textoCabecalho");
        boolean reduzirEspacoEntreLinhas = this.booleanAttributeValue(opcoes.attributeValue("reduzirEspacoEntreLinhas"));
        Integer tamanhoFonte = this.integerAttributeValue(opcoes.attributeValue("tamanhoFonte"));
        return new OpcoesImpressaoRecord(imprimirBrasao, textoCabecalho, reduzirEspacoEntreLinhas, tamanhoFonte);
    }

    private boolean booleanAttributeValue(String attributeValue) {
        return attributeValue != null && (attributeValue.equals("true") || attributeValue.equalsIgnoreCase("s"));
    }

    private Integer integerAttributeValue(String attributeValue) {
        return attributeValue != null ? Integer.valueOf(Integer.parseInt(attributeValue)) : null;
    }

    private String nodeStringValue(Node node) {
        return node == null ? null : node.getStringValue();
    }

    private String nodeContentWithTags(Node node) {
        return node == null ? null : node.asXML().trim().replaceAll("^<[^>]+>", "").replaceAll("</[^>]+>$", "");
    }

    private List<? extends Revisao> parseRevisoes(Element rootElement) {
        ArrayList<RevisaoPojo> ret = new ArrayList<RevisaoPojo>();
        Element revisoesElement = (Element)rootElement.selectSingleNode("Revisoes");
        if (revisoesElement != null) {
            List revisoes = revisoesElement.elements();
            for (Element eRevisao : revisoes) {
                ret.add(this.parseRevisao(eRevisao));
            }
        }
        return ret;
    }

    private RevisaoPojo parseRevisao(Element eRevisao) {
        Class classePojo;
        if (eRevisao.getName().equals("RevisaoElemento")) {
            classePojo = RevisaoElementoPojo.class;
        } else if (eRevisao.getName().equals("RevisaoJustificativa")) {
            classePojo = RevisaoJustificativaPojo.class;
        } else if (eRevisao.getName().equals("RevisaoTextoLivre")) {
            classePojo = RevisaoTextoLivrePojo.class;
        } else {
            throw new RuntimeException("Elemento " + eRevisao.getName() + " desconhecido na lista de revis\u00f5es.");
        }
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{classePojo});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            StringWriter sw = new StringWriter();
            eRevisao.write((Writer)sw);
            RevisaoPojo revisao = (RevisaoPojo)jaxbUnmarshaller.unmarshal((Reader)new StringReader(sw.toString()));
            return revisao;
        }
        catch (Exception e) {
            throw new RuntimeException("Falha ao fazer unmarshalling de revisao.", e);
        }
    }
}

