/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.eta.etaservices.printing.pdf;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.fop.pdf.PDFAMode;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FOHelper {
    private final String xml;
    private Document xmlDoc;
    private Node xmpmetaNode;
    private String xmpmetaString;
    private static final Logger log = LoggerFactory.getLogger(FOHelper.class);
    private String pdfaidPart;
    private String pdfaidConformance;
    private String dcCreator;
    private String xmpCreateDate;
    private static final Map<String, String> DEFAULT_URI = new HashMap<String, String>();

    public FOHelper(String xml) {
        this.xml = xml;
        this.processXML();
    }

    private void processXML() {
        SAXReader xmlReader = new SAXReader();
        try {
            this.xmlDoc = xmlReader.read((Reader)new StringReader(this.xml));
            this.pdfaidPart = this.getStringValueByXPath("//pdfaid:part");
            this.pdfaidConformance = this.getStringValueByXPath("//pdfaid:conformance");
            this.dcCreator = this.getStringValueByXPath("//dc:creator");
            this.xmpCreateDate = this.getStringValueByXPath("//xmp:CreateDate");
            this.xmpmetaNode = this.getNodeByXPath("//x:xmpmeta");
            if (this.xmpmetaNode != null) {
                this.xmpmetaNode.detach();
            }
        }
        catch (DocumentException e) {
            log.error("Exception loading FOP XML: " + e.getMessage(), (Throwable)e);
        }
    }

    public String getXmpmeta() {
        if (this.xmpmetaString == null && this.xmpmetaNode != null) {
            this.xmpmetaString = this.xmpmetaNode.asXML();
        }
        return this.xmpmetaString;
    }

    public Document getFOPDocumentWithoutXmpmeta() {
        return this.xmlDoc;
    }

    public String getDCCreator() {
        return this.dcCreator;
    }

    public boolean isPDFAMode() {
        return this.pdfaidPart != null && this.pdfaidConformance != null && (this.pdfaidPart.equals("1") || this.pdfaidPart.equals("2") || this.pdfaidPart.equals("3"));
    }

    public String getCmpCreateDate() {
        return this.xmpCreateDate;
    }

    public String getPDFAModeNameFOP() {
        if (this.pdfaidPart != null && this.pdfaidConformance != null && (this.pdfaidPart.equals("1") || this.pdfaidPart.equals("2") || this.pdfaidPart.equals("3"))) {
            if (this.pdfaidConformance.equals("A")) {
                return PDFAMode.PDFA_1A.getName();
            }
            if (this.pdfaidConformance.equals("B")) {
                return PDFAMode.PDFA_1B.getName();
            }
        }
        return null;
    }

    public String getPDFAPart() {
        return this.pdfaidPart;
    }

    public String getPDFAConformance() {
        return this.pdfaidConformance;
    }

    private Node getNodeByXPath(String xpathString) {
        XPath xpath = DocumentHelper.createXPath((String)xpathString);
        xpath.setNamespaceURIs(DEFAULT_URI);
        return xpath.selectSingleNode((Object)this.xmlDoc);
    }

    private String getStringValueByXPath(String xpathString) {
        String ret;
        Node node = this.getNodeByXPath(xpathString);
        if (node != null && (ret = node.getStringValue()) != null) {
            return ret.trim();
        }
        return null;
    }

    static {
        DEFAULT_URI.put("x", "adobe:ns:meta/");
        DEFAULT_URI.put("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        DEFAULT_URI.put("xmp", "http://ns.adobe.com/xap/1.0/");
        DEFAULT_URI.put("pdf", "http://ns.adobe.com/pdf/1.3/");
        DEFAULT_URI.put("dc", "http://purl.org/dc/elements/1.1/");
        DEFAULT_URI.put("pdfaid", "http://www.aiim.org/pdfa/ns/id/");
        DEFAULT_URI.put("pdfaExtension", "http://www.aiim.org/pdfa/ns/extension/");
        DEFAULT_URI.put("pdfaSchema", "http://www.aiim.org/pdfa/ns/schema#");
        DEFAULT_URI.put("pdfaProperty", "http://www.aiim.org/pdfa/ns/property#");
    }
}

