/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.eta.etaservices.emenda;

import br.gov.lexml.eta.etaservices.emenda.Anexo;
import br.gov.lexml.eta.etaservices.emenda.Autoria;
import br.gov.lexml.eta.etaservices.emenda.ColegiadoApreciador;
import br.gov.lexml.eta.etaservices.emenda.ComandoEmenda;
import br.gov.lexml.eta.etaservices.emenda.ComandoEmendaTextoLivre;
import br.gov.lexml.eta.etaservices.emenda.ComponenteEmendado;
import br.gov.lexml.eta.etaservices.emenda.Epigrafe;
import br.gov.lexml.eta.etaservices.emenda.ModoEdicaoEmenda;
import br.gov.lexml.eta.etaservices.emenda.NotaRodape;
import br.gov.lexml.eta.etaservices.emenda.OpcoesImpressao;
import br.gov.lexml.eta.etaservices.emenda.RefProposicaoEmendada;
import br.gov.lexml.eta.etaservices.emenda.Revisao;
import br.gov.lexml.eta.etaservices.emenda.SubstituicaoTermo;
import br.gov.lexml.eta.etaservices.emenda.TipoMateria;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.vavr.collection.Stream;
import java.time.Instant;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.List;
import java.util.Map;

public interface Emenda {
    public Instant getDataUltimaModificacao();

    public String getAplicacao();

    public String getVersaoAplicacao();

    public ModoEdicaoEmenda getModoEdicao();

    public Map<String, Object> getMetadados();

    public RefProposicaoEmendada getProposicao();

    public ColegiadoApreciador getColegiadoApreciador();

    public Epigrafe getEpigrafe();

    public List<? extends ComponenteEmendado> getComponentes();

    public ComandoEmenda getComandoEmenda();

    public ComandoEmendaTextoLivre getComandoEmendaTextoLivre();

    public SubstituicaoTermo getSubstituicaoTermo();

    public String getJustificativa();

    public String getJustificativaAntesRevisao();

    public String getLocal();

    public LocalDate getData();

    public List<? extends Anexo> getAnexos();

    @JsonIgnore
    default public String getDataFormatada() {
        return this.getData().format(DateTimeFormatter.ofLocalizedDate(FormatStyle.LONG)).toLowerCase();
    }

    public Autoria getAutoria();

    public OpcoesImpressao getOpcoesImpressao();

    public List<? extends Revisao> getRevisoes();

    public List<? extends NotaRodape> getNotasRodape();

    @JsonIgnore
    default public boolean isPossuiMarcasRevisao() {
        return this.getRevisoes() != null && !this.getRevisoes().isEmpty();
    }

    @JsonIgnore
    default public boolean isMateriaCongressoNacional() {
        return Stream.of((Object[])TipoMateria.values()).exists(t -> t.name().equals(this.getProposicao().getSigla()));
    }
}

