// Generated by delombok at Thu Feb 11 14:56:08 CET 2021
/*
 * This file is part of "albirar-communications".
 * 
 * "albirar-communications" is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * "albirar-communications" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with "albirar-communications" source code.  If not, see <https://www.gnu.org/licenses/gpl-3.0.html>.
 *
 * Copyright (C) 2020 Octavi Fornés
 */
package cat.albirar.communications.core.messages.models;

import java.io.Serializable;
import java.nio.charset.Charset;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import cat.albirar.communications.core.channels.models.ContactBean;
import cat.albirar.template.engine.EContentType;
import lombok.Builder.Default;

/**
 * A message bean with address (to or from), title (in SMS does'nt apply) and body.
 * @author Octavi Forn&eacute;s &lt;<a href="mailto:ofornes@albirar.cat">ofornes@albirar.cat</a>&gt;
 * @since 1.0.0
 */
@JsonInclude(Include.NON_EMPTY)
public class MessageBean implements Serializable {
    private static final long serialVersionUID = 3661502290127929947L;
    @NotNull
    @Valid
    private ContactBean receiver;
    @NotNull
    @Valid
    private ContactBean sender;
    @NotBlank
    private String title;
    @NotNull
    private EContentType bodyType;
    @NotNull
    private Charset bodyCharSet;
    @NotBlank
    private String body;

    public MessageBean() {
        MessageBean b = MessageBean.builder().build();
        receiver = b.getReceiver();
        sender = b.getSender();
        title = b.getTitle();
        bodyType = b.getBodyType();
        bodyCharSet = b.getBodyCharSet();
        body = b.getBody();
    }

    @java.lang.SuppressWarnings("all")
    private static EContentType $default$bodyType() {
        return EContentType.HTML;
    }

    @java.lang.SuppressWarnings("all")
    private static Charset $default$bodyCharSet() {
        return Charset.forName("UTF-8");
    }


    @java.lang.SuppressWarnings("all")
    public static abstract class MessageBeanBuilder<C extends MessageBean, B extends MessageBean.MessageBeanBuilder<C, B>> {
        @java.lang.SuppressWarnings("all")
        private ContactBean receiver;
        @java.lang.SuppressWarnings("all")
        private ContactBean sender;
        @java.lang.SuppressWarnings("all")
        private String title;
        @java.lang.SuppressWarnings("all")
        private boolean bodyType$set;
        @java.lang.SuppressWarnings("all")
        private EContentType bodyType$value;
        @java.lang.SuppressWarnings("all")
        private boolean bodyCharSet$set;
        @java.lang.SuppressWarnings("all")
        private Charset bodyCharSet$value;
        @java.lang.SuppressWarnings("all")
        private String body;

        @java.lang.SuppressWarnings("all")
        protected B $fillValuesFrom(final C instance) {
            MessageBean.MessageBeanBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        private static void $fillValuesFromInstanceIntoBuilder(final MessageBean instance, final MessageBean.MessageBeanBuilder<?, ?> b) {
            b.receiver(instance.receiver);
            b.sender(instance.sender);
            b.title(instance.title);
            b.bodyType(instance.bodyType);
            b.bodyCharSet(instance.bodyCharSet);
            b.body(instance.body);
        }

        @java.lang.SuppressWarnings("all")
        protected abstract B self();

        @java.lang.SuppressWarnings("all")
        public abstract C build();

        @java.lang.SuppressWarnings("all")
        public B receiver(final ContactBean receiver) {
            this.receiver = receiver;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        public B sender(final ContactBean sender) {
            this.sender = sender;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        public B title(final String title) {
            this.title = title;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        public B bodyType(final EContentType bodyType) {
            this.bodyType$value = bodyType;
            bodyType$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        public B bodyCharSet(final Charset bodyCharSet) {
            this.bodyCharSet$value = bodyCharSet;
            bodyCharSet$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        public B body(final String body) {
            this.body = body;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "MessageBean.MessageBeanBuilder(receiver=" + this.receiver + ", sender=" + this.sender + ", title=" + this.title + ", bodyType$value=" + this.bodyType$value + ", bodyCharSet$value=" + this.bodyCharSet$value + ", body=" + this.body + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    private static final class MessageBeanBuilderImpl extends MessageBean.MessageBeanBuilder<MessageBean, MessageBean.MessageBeanBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        private MessageBeanBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        protected MessageBean.MessageBeanBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public MessageBean build() {
            return new MessageBean(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    protected MessageBean(final MessageBean.MessageBeanBuilder<?, ?> b) {
        this.receiver = b.receiver;
        this.sender = b.sender;
        this.title = b.title;
        if (b.bodyType$set) this.bodyType = b.bodyType$value;
         else this.bodyType = MessageBean.$default$bodyType();
        if (b.bodyCharSet$set) this.bodyCharSet = b.bodyCharSet$value;
         else this.bodyCharSet = MessageBean.$default$bodyCharSet();
        this.body = b.body;
    }

    @java.lang.SuppressWarnings("all")
    public static MessageBean.MessageBeanBuilder<?, ?> builder() {
        return new MessageBean.MessageBeanBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    public MessageBean.MessageBeanBuilder<?, ?> toBuilder() {
        return new MessageBean.MessageBeanBuilderImpl().$fillValuesFrom(this);
    }

    @java.lang.SuppressWarnings("all")
    public ContactBean getReceiver() {
        return this.receiver;
    }

    @java.lang.SuppressWarnings("all")
    public ContactBean getSender() {
        return this.sender;
    }

    @java.lang.SuppressWarnings("all")
    public String getTitle() {
        return this.title;
    }

    @java.lang.SuppressWarnings("all")
    public EContentType getBodyType() {
        return this.bodyType;
    }

    @java.lang.SuppressWarnings("all")
    public Charset getBodyCharSet() {
        return this.bodyCharSet;
    }

    @java.lang.SuppressWarnings("all")
    public String getBody() {
        return this.body;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof MessageBean)) return false;
        final MessageBean other = (MessageBean) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$receiver = this.getReceiver();
        final java.lang.Object other$receiver = other.getReceiver();
        if (this$receiver == null ? other$receiver != null : !this$receiver.equals(other$receiver)) return false;
        final java.lang.Object this$sender = this.getSender();
        final java.lang.Object other$sender = other.getSender();
        if (this$sender == null ? other$sender != null : !this$sender.equals(other$sender)) return false;
        final java.lang.Object this$title = this.getTitle();
        final java.lang.Object other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) return false;
        final java.lang.Object this$bodyType = this.getBodyType();
        final java.lang.Object other$bodyType = other.getBodyType();
        if (this$bodyType == null ? other$bodyType != null : !this$bodyType.equals(other$bodyType)) return false;
        final java.lang.Object this$bodyCharSet = this.getBodyCharSet();
        final java.lang.Object other$bodyCharSet = other.getBodyCharSet();
        if (this$bodyCharSet == null ? other$bodyCharSet != null : !this$bodyCharSet.equals(other$bodyCharSet)) return false;
        final java.lang.Object this$body = this.getBody();
        final java.lang.Object other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof MessageBean;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $receiver = this.getReceiver();
        result = result * PRIME + ($receiver == null ? 43 : $receiver.hashCode());
        final java.lang.Object $sender = this.getSender();
        result = result * PRIME + ($sender == null ? 43 : $sender.hashCode());
        final java.lang.Object $title = this.getTitle();
        result = result * PRIME + ($title == null ? 43 : $title.hashCode());
        final java.lang.Object $bodyType = this.getBodyType();
        result = result * PRIME + ($bodyType == null ? 43 : $bodyType.hashCode());
        final java.lang.Object $bodyCharSet = this.getBodyCharSet();
        result = result * PRIME + ($bodyCharSet == null ? 43 : $bodyCharSet.hashCode());
        final java.lang.Object $body = this.getBody();
        result = result * PRIME + ($body == null ? 43 : $body.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString() {
        return "MessageBean(receiver=" + this.getReceiver() + ", sender=" + this.getSender() + ", title=" + this.getTitle() + ", bodyType=" + this.getBodyType() + ", bodyCharSet=" + this.getBodyCharSet() + ", body=" + this.getBody() + ")";
    }

    @java.lang.SuppressWarnings("all")
    public void setReceiver(@NotNull @Valid final ContactBean receiver) {
        this.receiver = receiver;
    }

    @java.lang.SuppressWarnings("all")
    public void setSender(@NotNull @Valid final ContactBean sender) {
        this.sender = sender;
    }

    @java.lang.SuppressWarnings("all")
    public void setTitle(@NotBlank final String title) {
        this.title = title;
    }

    @java.lang.SuppressWarnings("all")
    public void setBodyType(@NotNull final EContentType bodyType) {
        this.bodyType = bodyType;
    }

    @java.lang.SuppressWarnings("all")
    public void setBodyCharSet(@NotNull final Charset bodyCharSet) {
        this.bodyCharSet = bodyCharSet;
    }

    @java.lang.SuppressWarnings("all")
    public void setBody(@NotBlank final String body) {
        this.body = body;
    }
}
