/*
 * Decompiled with CFR 0.152.
 */
package cat.albirar.communications.services.impl;

import cat.albirar.communications.core.configuration.AlbirarCommunicationsConfiguration;
import cat.albirar.communications.core.messages.models.MessageBean;
import cat.albirar.communications.core.services.ICommunicationService;
import cat.albirar.communications.core.status.EStatusMessage;
import cat.albirar.communications.core.status.models.MessageStatusBean;
import cat.albirar.communications.providers.email.EmailPushBean;
import cat.albirar.communications.providers.email.SmsPushBean;
import cat.albirar.communications.providers.mocks.IMockEmailServiceProvider;
import cat.albirar.communications.providers.mocks.IMockSmsServiceProvider;
import cat.albirar.communications.test.AbstractCommunicationsTest;
import cat.albirar.communications.test.RabbitMqContainerExtension;
import cat.albirar.communications.test.configuration.CoreCommunicationsTestConfiguration;
import cat.albirar.communications.test.configuration.TestMessagesFactory;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.validation.ConstraintViolationException;
import org.awaitility.Awaitility;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import org.springframework.util.StringUtils;

@ContextConfiguration(classes={AlbirarCommunicationsConfiguration.class, CoreCommunicationsTestConfiguration.class})
@ExtendWith(value={SpringExtension.class, RabbitMqContainerExtension.class})
public class CommunicationServiceTest
extends AbstractCommunicationsTest {
    @Autowired
    private ICommunicationService communicationService;
    @Autowired
    private IMockEmailServiceProvider emailProvider;
    @Autowired
    private IMockSmsServiceProvider smsProvider;
    private MessageBean emailMessage;
    private MessageBean smsMessage;

    @BeforeEach
    public void init() {
        TestMessagesFactory tm = new TestMessagesFactory();
        this.emailMessage = tm.getEmailMessage();
        this.smsMessage = tm.getSmsMessage();
    }

    @Test
    public void testPushEmailMessage() {
        Instant ts = Instant.now();
        String messageId = this.communicationService.pushMessage(this.emailMessage);
        Awaitility.await().atLeast(10L, TimeUnit.MILLISECONDS).and().atMost(10L, TimeUnit.SECONDS).until(() -> this.emailProvider.isMessageProcessed(messageId));
        Optional omsg = this.emailProvider.getMessage(messageId);
        Assertions.assertNotNull((Object)omsg);
        Assertions.assertTrue((boolean)omsg.isPresent());
        EmailPushBean msg = (EmailPushBean)omsg.get();
        Assertions.assertEquals((Object)this.emailMessage.getSender(), (Object)msg.getFrom());
        Assertions.assertEquals((Object)this.emailMessage.getReceiver(), (Object)msg.getRecipient());
        Assertions.assertEquals((Object)this.emailMessage.getTitle(), (Object)msg.getSubject());
        Assertions.assertEquals((Object)this.emailMessage.getBody(), (Object)msg.getMessage());
        Assertions.assertEquals((Object)this.emailMessage.getBodyCharSet().displayName(), (Object)msg.getCharset());
        Assertions.assertEquals((Object)this.emailMessage.getBodyType().getMediaType(), (Object)msg.getMediaType());
        Assertions.assertTrue((boolean)ts.isBefore(msg.getTimestamp()));
    }

    @Test
    public void testPushSmsMessage() {
        Instant ts = Instant.now();
        String messageId = this.communicationService.pushMessage(this.smsMessage);
        Awaitility.await().atLeast(10L, TimeUnit.MILLISECONDS).and().atMost(10L, TimeUnit.SECONDS).until(() -> this.smsProvider.isMessageProcessed(messageId));
        Optional omsg = this.smsProvider.getMessage(messageId);
        Assertions.assertNotNull((Object)omsg);
        Assertions.assertTrue((boolean)omsg.isPresent());
        SmsPushBean msg = (SmsPushBean)omsg.get();
        Assertions.assertEquals((Object)this.smsMessage.getSender(), (Object)msg.getFrom());
        Assertions.assertEquals((Object)this.smsMessage.getReceiver(), (Object)msg.getRecipient());
        Assertions.assertEquals((Object)this.smsMessage.getBody(), (Object)msg.getMessage());
        Assertions.assertTrue((boolean)ts.isBefore(msg.getTimestamp()));
    }

    @Test
    public void testIsReportMessage() {
        String messageIdSms = this.communicationService.pushMessage(this.smsMessage);
        String messageIdEmail = this.communicationService.pushMessage(this.emailMessage);
        Awaitility.await().atLeast(10L, TimeUnit.MILLISECONDS).and().atMost(10L, TimeUnit.SECONDS).until(() -> this.smsProvider.isMessageProcessed(messageIdSms) && this.emailProvider.isMessageProcessed(messageIdEmail));
        Assertions.assertTrue((boolean)this.communicationService.isStatusMessage(messageIdSms));
        Assertions.assertTrue((boolean)this.communicationService.isStatusMessage(messageIdEmail));
    }

    @Test
    public void testPopReportMessages() {
        String messageIdSms = this.communicationService.pushMessage(this.smsMessage);
        String messageIdEmail = this.communicationService.pushMessage(this.emailMessage);
        Awaitility.await().atLeast(10L, TimeUnit.MILLISECONDS).and().atMost(10L, TimeUnit.SECONDS).until(() -> this.smsProvider.isMessageProcessed(messageIdSms) && this.emailProvider.isMessageProcessed(messageIdEmail));
        Optional omsg = this.communicationService.popStatusMessage(messageIdSms);
        Assertions.assertTrue((boolean)omsg.isPresent());
        MessageStatusBean msg = (MessageStatusBean)omsg.get();
        Assertions.assertEquals((Object)this.smsMessage.getBody(), (Object)msg.getBody());
        Assertions.assertEquals((Object)this.smsMessage.getBodyCharSet(), (Object)msg.getBodyCharSet());
        Assertions.assertEquals((Object)this.smsMessage.getBodyType(), (Object)msg.getBodyType());
        Assertions.assertEquals((Object)this.smsMessage.getReceiver(), (Object)msg.getReceiver());
        Assertions.assertEquals((Object)this.smsMessage.getSender(), (Object)msg.getSender());
        Assertions.assertEquals((Object)this.smsMessage.getTitle(), (Object)msg.getTitle());
        Assertions.assertEquals((Object)EStatusMessage.SEND, (Object)msg.getStatus());
        Assertions.assertNotNull((Object)msg.getErrorMessage());
        Assert.assertFalse((boolean)msg.getErrorMessage().isPresent());
        omsg = this.communicationService.popStatusMessage(messageIdEmail);
        Assertions.assertTrue((boolean)omsg.isPresent());
        msg = (MessageStatusBean)omsg.get();
        Assertions.assertEquals((Object)this.emailMessage.getBody(), (Object)msg.getBody());
        Assertions.assertEquals((Object)this.emailMessage.getBodyCharSet(), (Object)msg.getBodyCharSet());
        Assertions.assertEquals((Object)this.emailMessage.getBodyType(), (Object)msg.getBodyType());
        Assertions.assertEquals((Object)this.emailMessage.getReceiver(), (Object)msg.getReceiver());
        Assertions.assertEquals((Object)this.emailMessage.getSender(), (Object)msg.getSender());
        Assertions.assertEquals((Object)this.emailMessage.getTitle(), (Object)msg.getTitle());
        Assertions.assertEquals((Object)EStatusMessage.SEND, (Object)msg.getStatus());
        Assertions.assertNotNull((Object)msg.getErrorMessage());
        Assert.assertFalse((boolean)msg.getErrorMessage().isPresent());
    }

    @Test
    public void testValidationIsReportMessage() {
        Assertions.assertThrows(ConstraintViolationException.class, () -> this.communicationService.isStatusMessage(null));
        Assertions.assertThrows(ConstraintViolationException.class, () -> this.communicationService.isStatusMessage(""));
        Assertions.assertThrows(ConstraintViolationException.class, () -> this.communicationService.isStatusMessage("   "));
    }

    @Test
    public void testThrowProviderException() {
        this.emailProvider.setThrowException(true);
        this.smsProvider.setThrowException(true);
        String messageIdEmail = this.communicationService.pushMessage(this.emailMessage);
        String messageIdSms = this.communicationService.pushMessage(this.smsMessage);
        Awaitility.await().atLeast(10L, TimeUnit.MILLISECONDS).and().atMost(10L, TimeUnit.SECONDS).until(() -> this.communicationService.isStatusMessage(messageIdEmail) && this.communicationService.isStatusMessage(messageIdSms));
        Awaitility.await().atLeast(10L, TimeUnit.MILLISECONDS).and().atMost(10L, TimeUnit.SECONDS).until(() -> this.smsProvider.isThrowMessageProcessed(messageIdSms) && this.emailProvider.isThrowMessageProcessed(messageIdEmail));
        this.emailProvider.setThrowException(false);
        this.smsProvider.setThrowException(false);
        Optional omsg = this.communicationService.popStatusMessage(messageIdEmail);
        Assertions.assertTrue((boolean)omsg.isPresent());
        MessageStatusBean msg = (MessageStatusBean)omsg.get();
        Assertions.assertEquals((Object)this.emailMessage.getBody(), (Object)msg.getBody());
        Assertions.assertEquals((Object)this.emailMessage.getBodyCharSet(), (Object)msg.getBodyCharSet());
        Assertions.assertEquals((Object)this.emailMessage.getBodyType(), (Object)msg.getBodyType());
        Assertions.assertEquals((Object)this.emailMessage.getReceiver(), (Object)msg.getReceiver());
        Assertions.assertEquals((Object)this.emailMessage.getSender(), (Object)msg.getSender());
        Assertions.assertEquals((Object)this.emailMessage.getTitle(), (Object)msg.getTitle());
        Assertions.assertEquals((Object)EStatusMessage.ERROR, (Object)msg.getStatus());
        Assertions.assertNotNull((Object)msg.getErrorMessage());
        Assertions.assertTrue((boolean)msg.getErrorMessage().isPresent());
        String t = (String)msg.getErrorMessage().get();
        Assertions.assertTrue((boolean)StringUtils.hasText((String)t));
        omsg = this.communicationService.popStatusMessage(messageIdSms);
        Assertions.assertTrue((boolean)omsg.isPresent());
        msg = (MessageStatusBean)omsg.get();
        Assertions.assertEquals((Object)this.smsMessage.getBody(), (Object)msg.getBody());
        Assertions.assertEquals((Object)this.smsMessage.getBodyCharSet(), (Object)msg.getBodyCharSet());
        Assertions.assertEquals((Object)this.smsMessage.getBodyType(), (Object)msg.getBodyType());
        Assertions.assertEquals((Object)this.smsMessage.getReceiver(), (Object)msg.getReceiver());
        Assertions.assertEquals((Object)this.smsMessage.getSender(), (Object)msg.getSender());
        Assertions.assertEquals((Object)this.smsMessage.getTitle(), (Object)msg.getTitle());
        Assertions.assertEquals((Object)EStatusMessage.ERROR, (Object)msg.getStatus());
        Assertions.assertNotNull((Object)msg.getErrorMessage());
        Assertions.assertTrue((boolean)msg.getErrorMessage().isPresent());
        t = (String)msg.getErrorMessage().get();
        Assertions.assertTrue((boolean)StringUtils.hasText((String)t));
    }
}

