/*
 * Decompiled with CFR 0.152.
 */
package cat.albirar.communications.core.configuration;

import cat.albirar.communications.core.processors.impl.EmailReportProcessor;
import cat.albirar.communications.core.processors.impl.EmailSenderProcessor;
import cat.albirar.communications.core.processors.impl.SmsReportProcessor;
import cat.albirar.communications.core.processors.impl.SmsSenderProcessor;
import cat.albirar.communications.core.services.impl.CommunicationServiceImpl;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.core.NamingStrategy;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.amqp.core.UUIDNamingStrategy;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;
import org.springframework.validation.beanvalidation.MethodValidationPostProcessor;

@Configuration
@ComponentScan(basePackageClasses={EmailSenderProcessor.class, CommunicationServiceImpl.class})
@PropertySource(value={"classpath:/cat/albirar/communications/albirar-communications.properties"})
public class AlbirarCommunicationsConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlbirarCommunicationsConfiguration.class);
    @Value(value="#{systemProperties['albirar.communications.connection.host'] ?:'localhost'}")
    private String host;
    @Value(value="#{systemProperties['albirar.communications.connection.virtualhost'] ?:'/'}")
    private String virtualHost;
    @Value(value="#{systemProperties['albirar.communications.connection.port'] ?: '5672'}")
    private int port;
    @Value(value="#{systemProperties['albirar.communications.connection.username'] ?:'guest'}")
    private String username;
    @Value(value="#{systemProperties['albirar.communications.connection.password'] ?:'guest'}")
    private String password;
    private String exchangeName = "albirar-communications";
    private String emailSendQueueName = "emailSendQueue";
    private String emailReportQueueName = "emailReportQueue";
    private String smsSendQueueName = "smsSendQueue";
    private String smsReportQueueName = "smsReportQueue";

    @Bean
    @ConditionalOnMissingBean
    public LocalValidatorFactoryBean validator() {
        return new LocalValidatorFactoryBean();
    }

    @Bean
    @ConditionalOnMissingBean
    public MethodValidationPostProcessor validationPostProcessor() {
        return new MethodValidationPostProcessor();
    }

    @Bean
    @ConditionalOnMissingBean
    public NamingStrategy namingStrategy() {
        return new UUIDNamingStrategy();
    }

    @Bean
    @ConditionalOnMissingBean
    public ConnectionFactory connectionFactory() {
        LOGGER.debug("Creating connection factory with values: {}", (Object)("host: '" + this.host + "', port: " + this.port + ", virtualHost: '" + this.virtualHost + "', username: '" + this.username + "', password: '" + this.password + "'"));
        CachingConnectionFactory cnxFc = new CachingConnectionFactory(this.host, this.port);
        cnxFc.setVirtualHost(this.virtualHost);
        cnxFc.setUsername(this.username);
        cnxFc.setPassword(this.password);
        cnxFc.setPublisherConfirmType(CachingConnectionFactory.ConfirmType.CORRELATED);
        return cnxFc;
    }

    @Bean
    @ConditionalOnMissingBean
    public RabbitAdmin rabbitAdmin(ConnectionFactory connectionFactory) {
        RabbitAdmin radm = new RabbitAdmin(connectionFactory);
        return radm;
    }

    @Bean
    @ConditionalOnMissingBean
    public MessageConverter messageConverter() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new Jdk8Module());
        Jackson2JsonMessageConverter msgCnv = new Jackson2JsonMessageConverter(mapper);
        return msgCnv;
    }

    @Bean
    @ConditionalOnMissingBean
    public RabbitTemplate rabbitTemplate(ConnectionFactory connectionFactory, MessageConverter messageConverter) {
        RabbitTemplate template = new RabbitTemplate(connectionFactory);
        template.setMessageConverter(messageConverter);
        return template;
    }

    @Bean
    @ConditionalOnMissingBean(name={"emailSendQueue"})
    public Queue emailSendQueue() {
        return new Queue(this.emailSendQueueName);
    }

    @Bean
    @ConditionalOnMissingBean(name={"smsSendQueue"})
    public Queue smsSendQueue() {
        return new Queue(this.smsSendQueueName);
    }

    @Bean
    @ConditionalOnMissingBean(name={"emailReportQueue"})
    public Queue emailReportQueue() {
        return new Queue(this.emailReportQueueName);
    }

    @Bean
    @ConditionalOnMissingBean(name={"smsReportQueue"})
    public Queue smsReportQueue() {
        return new Queue(this.smsReportQueueName);
    }

    @Bean
    @ConditionalOnMissingBean(name={"exchange"})
    public TopicExchange exchange() {
        return new TopicExchange(this.exchangeName);
    }

    @Bean
    public Binding bindingEmailSend(@Qualifier(value="emailSendQueue") Queue emailSendQueue, TopicExchange exchange) {
        return BindingBuilder.bind((Queue)emailSendQueue).to(exchange).with(this.emailSendQueueName);
    }

    @Bean
    public Binding bindingEmailReport(@Qualifier(value="emailReportQueue") Queue emailReportQueue, TopicExchange exchange) {
        return BindingBuilder.bind((Queue)emailReportQueue).to(exchange).with(this.emailReportQueueName);
    }

    @Bean
    public Binding bindingSmsSend(@Qualifier(value="smsSendQueue") Queue smsSendQueue, TopicExchange exchange) {
        return BindingBuilder.bind((Queue)smsSendQueue).to(exchange).with(this.smsSendQueueName);
    }

    @Bean
    public Binding bindingReportSend(@Qualifier(value="smsReportQueue") Queue smsReportQueue, TopicExchange exchange) {
        return BindingBuilder.bind((Queue)smsReportQueue).to(exchange).with(this.smsReportQueueName);
    }

    @Bean
    public SimpleMessageListenerContainer listenerSendEmail(ConnectionFactory connectionFactory, EmailSenderProcessor emailSenderProcessor, @Qualifier(value="emailSendQueue") Queue emailSendQueue) {
        SimpleMessageListenerContainer container = new SimpleMessageListenerContainer();
        container.setConnectionFactory(connectionFactory);
        container.setQueues(new Queue[]{emailSendQueue});
        container.setMessageListener((MessageListener)emailSenderProcessor);
        return container;
    }

    @Bean
    public SimpleMessageListenerContainer listenerSendSms(ConnectionFactory connectionFactory, SmsSenderProcessor smsSenderProcessor, @Qualifier(value="smsSendQueue") Queue smsSendQueue) {
        SimpleMessageListenerContainer container = new SimpleMessageListenerContainer();
        container.setConnectionFactory(connectionFactory);
        container.setQueues(new Queue[]{smsSendQueue});
        container.setMessageListener((MessageListener)smsSenderProcessor);
        return container;
    }

    @Bean
    public SimpleMessageListenerContainer listenerReportEmail(ConnectionFactory connectionFactory, EmailReportProcessor emailReportProcessor, @Qualifier(value="emailReportQueue") Queue emailReportQueue) {
        SimpleMessageListenerContainer container = new SimpleMessageListenerContainer();
        container.setConnectionFactory(connectionFactory);
        container.setQueues(new Queue[]{emailReportQueue});
        container.setMessageListener((MessageListener)emailReportProcessor);
        return container;
    }

    @Bean
    public SimpleMessageListenerContainer listenerReportSms(ConnectionFactory connectionFactory, SmsReportProcessor smsReportProcessor, @Qualifier(value="smsReportQueue") Queue smsReportQueue) {
        SimpleMessageListenerContainer container = new SimpleMessageListenerContainer();
        container.setConnectionFactory(connectionFactory);
        container.setQueues(new Queue[]{smsReportQueue});
        container.setMessageListener((MessageListener)smsReportProcessor);
        return container;
    }
}

