/*
 * Decompiled with CFR 0.152.
 */
package cat.albirar.communications.core.processors.impl;

import cat.albirar.communications.core.messages.models.MessageBean;
import cat.albirar.communications.core.processors.impl.AbstractSenderProcessor;
import cat.albirar.communications.core.providers.ProviderException;
import cat.albirar.communications.core.providers.sms.ISmsSenderProvider;
import cat.albirar.communications.core.status.EStatusMessage;
import cat.albirar.communications.core.status.models.MessageStatusBean;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class SmsSenderProcessor
extends AbstractSenderProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmsSenderProcessor.class);
    @Autowired(required=false)
    private List<ISmsSenderProvider> smsProviders;

    @Override
    protected void processMessage(String messageId, MessageBean message) {
        LOGGER.info("Sending SMS for message {}", (Object)message);
        try {
            if (!ObjectUtils.isEmpty(this.smsProviders)) {
                this.smsProviders.get(0).sendSms(messageId, message.getSender(), message.getReceiver(), message.getBody());
                MessageBean r = ((MessageStatusBean.MessageStatusBeanBuilder)((MessageStatusBean.MessageStatusBeanBuilder)MessageStatusBean.copyBuilder(message).status(EStatusMessage.SEND)).messageId(messageId)).build();
                this.reportMessage("smsReportQueue", (MessageStatusBean)r);
            } else {
                LOGGER.error("No sms provider was configured!");
                MessageBean r = ((MessageStatusBean.MessageStatusBeanBuilder)((MessageStatusBean.MessageStatusBeanBuilder)((MessageStatusBean.MessageStatusBeanBuilder)MessageStatusBean.copyBuilder(message).status(EStatusMessage.ERROR)).messageId(messageId)).errorMessage(Optional.of("No sms provider was configured!"))).build();
                this.reportMessage("smsReportQueue", (MessageStatusBean)r);
            }
        }
        catch (ProviderException e) {
            String errMsg = String.format("On preparing or sending the SMS message for %s (%s)", message, e.getMessage());
            LOGGER.error(errMsg, (Throwable)e);
            MessageBean r = ((MessageStatusBean.MessageStatusBeanBuilder)((MessageStatusBean.MessageStatusBeanBuilder)((MessageStatusBean.MessageStatusBeanBuilder)MessageStatusBean.copyBuilder(message).status(EStatusMessage.ERROR)).messageId(messageId)).errorMessage(Optional.of(errMsg))).build();
            this.reportMessage("smsReportQueue", (MessageStatusBean)r);
        }
    }
}

