// Generated by delombok at Thu Feb 18 11:53:42 CET 2021
/*
 * This file is part of "albirar-communications".
 * 
 * "albirar-communications" is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * "albirar-communications" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with "albirar-communications" source code.  If not, see <https://www.gnu.org/licenses/gpl-3.0.html>.
 *
 * Copyright (C) 2020 Octavi Fornés
 */
package cat.albirar.communications.core.channels.models;

import java.io.Serializable;
import java.util.Locale;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import lombok.Builder.Default;

/**
 * Data contact of a sender or receiver in SMS or EMAIL.
 * @author Octavi Forn&eacute;s &lt;<a href="mailto:ofornes@albirar.cat">ofornes@albirar.cat</a>&gt;
 * @since 1.0.0
 */
@JsonInclude(Include.NON_EMPTY)
public class ContactBean implements Serializable {
    private static final long serialVersionUID = 7887468884518241617L;
    @NotBlank
    private String displayName;
    @NotNull
    private Locale preferredLocale;
    @NotNull
    @Valid
    private LocalizableAttributesCommunicationChannelBean channelBean;

    public ContactBean() {
        ContactBean cb = ContactBean.builder().build();
        displayName = cb.getDisplayName();
        preferredLocale = cb.getPreferredLocale();
        channelBean = cb.getChannelBean();
    }

    @java.lang.SuppressWarnings("all")
    private static Locale $default$preferredLocale() {
        return Locale.getDefault();
    }

    @java.lang.SuppressWarnings("all")
    private static LocalizableAttributesCommunicationChannelBean $default$channelBean() {
        return LocalizableAttributesCommunicationChannelBean.builder().build();
    }


    @java.lang.SuppressWarnings("all")
    public static abstract class ContactBeanBuilder<C extends ContactBean, B extends ContactBean.ContactBeanBuilder<C, B>> {
        @java.lang.SuppressWarnings("all")
        private String displayName;
        @java.lang.SuppressWarnings("all")
        private boolean preferredLocale$set;
        @java.lang.SuppressWarnings("all")
        private Locale preferredLocale$value;
        @java.lang.SuppressWarnings("all")
        private boolean channelBean$set;
        @java.lang.SuppressWarnings("all")
        private LocalizableAttributesCommunicationChannelBean channelBean$value;

        @java.lang.SuppressWarnings("all")
        protected B $fillValuesFrom(final C instance) {
            ContactBean.ContactBeanBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        private static void $fillValuesFromInstanceIntoBuilder(final ContactBean instance, final ContactBean.ContactBeanBuilder<?, ?> b) {
            b.displayName(instance.displayName);
            b.preferredLocale(instance.preferredLocale);
            b.channelBean(instance.channelBean);
        }

        @java.lang.SuppressWarnings("all")
        protected abstract B self();

        @java.lang.SuppressWarnings("all")
        public abstract C build();

        @java.lang.SuppressWarnings("all")
        public B displayName(final String displayName) {
            this.displayName = displayName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        public B preferredLocale(final Locale preferredLocale) {
            this.preferredLocale$value = preferredLocale;
            preferredLocale$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        public B channelBean(final LocalizableAttributesCommunicationChannelBean channelBean) {
            this.channelBean$value = channelBean;
            channelBean$set = true;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "ContactBean.ContactBeanBuilder(displayName=" + this.displayName + ", preferredLocale$value=" + this.preferredLocale$value + ", channelBean$value=" + this.channelBean$value + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    private static final class ContactBeanBuilderImpl extends ContactBean.ContactBeanBuilder<ContactBean, ContactBean.ContactBeanBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        private ContactBeanBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        protected ContactBean.ContactBeanBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public ContactBean build() {
            return new ContactBean(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    protected ContactBean(final ContactBean.ContactBeanBuilder<?, ?> b) {
        this.displayName = b.displayName;
        if (b.preferredLocale$set) this.preferredLocale = b.preferredLocale$value;
         else this.preferredLocale = ContactBean.$default$preferredLocale();
        if (b.channelBean$set) this.channelBean = b.channelBean$value;
         else this.channelBean = ContactBean.$default$channelBean();
    }

    @java.lang.SuppressWarnings("all")
    public static ContactBean.ContactBeanBuilder<?, ?> builder() {
        return new ContactBean.ContactBeanBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    public ContactBean.ContactBeanBuilder<?, ?> toBuilder() {
        return new ContactBean.ContactBeanBuilderImpl().$fillValuesFrom(this);
    }

    @java.lang.SuppressWarnings("all")
    public String getDisplayName() {
        return this.displayName;
    }

    @java.lang.SuppressWarnings("all")
    public Locale getPreferredLocale() {
        return this.preferredLocale;
    }

    @java.lang.SuppressWarnings("all")
    public LocalizableAttributesCommunicationChannelBean getChannelBean() {
        return this.channelBean;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ContactBean)) return false;
        final ContactBean other = (ContactBean) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$displayName = this.getDisplayName();
        final java.lang.Object other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) return false;
        final java.lang.Object this$preferredLocale = this.getPreferredLocale();
        final java.lang.Object other$preferredLocale = other.getPreferredLocale();
        if (this$preferredLocale == null ? other$preferredLocale != null : !this$preferredLocale.equals(other$preferredLocale)) return false;
        final java.lang.Object this$channelBean = this.getChannelBean();
        final java.lang.Object other$channelBean = other.getChannelBean();
        if (this$channelBean == null ? other$channelBean != null : !this$channelBean.equals(other$channelBean)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ContactBean;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $displayName = this.getDisplayName();
        result = result * PRIME + ($displayName == null ? 43 : $displayName.hashCode());
        final java.lang.Object $preferredLocale = this.getPreferredLocale();
        result = result * PRIME + ($preferredLocale == null ? 43 : $preferredLocale.hashCode());
        final java.lang.Object $channelBean = this.getChannelBean();
        result = result * PRIME + ($channelBean == null ? 43 : $channelBean.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString() {
        return "ContactBean(displayName=" + this.getDisplayName() + ", preferredLocale=" + this.getPreferredLocale() + ", channelBean=" + this.getChannelBean() + ")";
    }

    @java.lang.SuppressWarnings("all")
    public void setDisplayName(@NotBlank final String displayName) {
        this.displayName = displayName;
    }

    @java.lang.SuppressWarnings("all")
    public void setPreferredLocale(@NotNull final Locale preferredLocale) {
        this.preferredLocale = preferredLocale;
    }

    @java.lang.SuppressWarnings("all")
    public void setChannelBean(@NotNull @Valid final LocalizableAttributesCommunicationChannelBean channelBean) {
        this.channelBean = channelBean;
    }
}
