// Generated by delombok at Thu Feb 18 11:53:42 CET 2021
/*
 * This file is part of "albirar-communications".
 * 
 * "albirar-communications" is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * "albirar-communications" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with "albirar-communications" source code.  If not, see <https://www.gnu.org/licenses/gpl-3.0.html>.
 *
 * Copyright (C) 2020 Octavi Fornés
 */
package cat.albirar.communications.core.channels.models;

import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import lombok.Builder.Default;

/**
 * A {@link Locale localized} communication channel with some variables.
 * Enable the use of a specific language and region for a destination.
 * @author Octavi Forn&eacute;s &lt;<a href="mailto:ofornes@albirar.cat">ofornes@albirar.cat</a>&gt;
 * @since 1.0.0
 */
@JsonInclude(Include.NON_EMPTY)
public class LocalizableAttributesCommunicationChannelBean extends CommunicationChannelBean {
    private static final long serialVersionUID = 4450726832946360111L;
    /**
     * The locale for this communication channel.
     */
    @NotNull
    private Locale locale;
    @NotNull
    private Map<String, Object> attributes;

    public static LocalizableAttributesCommunicationChannelBeanBuilder<?, ?> builderCopy(CommunicationChannelBean parent) {
        return (LocalizableAttributesCommunicationChannelBeanBuilder<?, ?>) LocalizableAttributesCommunicationChannelBean.builder().channelType(parent.getChannelType()).channelId(parent.getChannelId()).attributes(new TreeMap<>());
    }

    public LocalizableAttributesCommunicationChannelBean() {
        super();
        LocalizableAttributesCommunicationChannelBean b = LocalizableAttributesCommunicationChannelBean.builder().build();
        locale = b.getLocale();
        attributes = b.getAttributes();
    }

    @java.lang.SuppressWarnings("all")
    private static Locale $default$locale() {
        return Locale.getDefault();
    }

    @java.lang.SuppressWarnings("all")
    private static Map<String, Object> $default$attributes() {
        return new TreeMap<>();
    }


    @java.lang.SuppressWarnings("all")
    public static abstract class LocalizableAttributesCommunicationChannelBeanBuilder<C extends LocalizableAttributesCommunicationChannelBean, B extends LocalizableAttributesCommunicationChannelBean.LocalizableAttributesCommunicationChannelBeanBuilder<C, B>> extends CommunicationChannelBean.CommunicationChannelBeanBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        private boolean locale$set;
        @java.lang.SuppressWarnings("all")
        private Locale locale$value;
        @java.lang.SuppressWarnings("all")
        private boolean attributes$set;
        @java.lang.SuppressWarnings("all")
        private Map<String, Object> attributes$value;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            LocalizableAttributesCommunicationChannelBean.LocalizableAttributesCommunicationChannelBeanBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        private static void $fillValuesFromInstanceIntoBuilder(final LocalizableAttributesCommunicationChannelBean instance, final LocalizableAttributesCommunicationChannelBean.LocalizableAttributesCommunicationChannelBeanBuilder<?, ?> b) {
            b.locale(instance.locale);
            b.attributes(instance.attributes);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public abstract C build();

        @java.lang.SuppressWarnings("all")
        public B locale(final Locale locale) {
            this.locale$value = locale;
            locale$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        public B attributes(final Map<String, Object> attributes) {
            this.attributes$value = attributes;
            attributes$set = true;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "LocalizableAttributesCommunicationChannelBean.LocalizableAttributesCommunicationChannelBeanBuilder(super=" + super.toString() + ", locale$value=" + this.locale$value + ", attributes$value=" + this.attributes$value + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    private static final class LocalizableAttributesCommunicationChannelBeanBuilderImpl extends LocalizableAttributesCommunicationChannelBean.LocalizableAttributesCommunicationChannelBeanBuilder<LocalizableAttributesCommunicationChannelBean, LocalizableAttributesCommunicationChannelBean.LocalizableAttributesCommunicationChannelBeanBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        private LocalizableAttributesCommunicationChannelBeanBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        protected LocalizableAttributesCommunicationChannelBean.LocalizableAttributesCommunicationChannelBeanBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public LocalizableAttributesCommunicationChannelBean build() {
            return new LocalizableAttributesCommunicationChannelBean(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    protected LocalizableAttributesCommunicationChannelBean(final LocalizableAttributesCommunicationChannelBean.LocalizableAttributesCommunicationChannelBeanBuilder<?, ?> b) {
        super(b);
        if (b.locale$set) this.locale = b.locale$value;
         else this.locale = LocalizableAttributesCommunicationChannelBean.$default$locale();
        if (b.attributes$set) this.attributes = b.attributes$value;
         else this.attributes = LocalizableAttributesCommunicationChannelBean.$default$attributes();
    }

    @java.lang.SuppressWarnings("all")
    public static LocalizableAttributesCommunicationChannelBean.LocalizableAttributesCommunicationChannelBeanBuilder<?, ?> builder() {
        return new LocalizableAttributesCommunicationChannelBean.LocalizableAttributesCommunicationChannelBeanBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    public LocalizableAttributesCommunicationChannelBean.LocalizableAttributesCommunicationChannelBeanBuilder<?, ?> toBuilder() {
        return new LocalizableAttributesCommunicationChannelBean.LocalizableAttributesCommunicationChannelBeanBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * The locale for this communication channel.
     */
    @java.lang.SuppressWarnings("all")
    public Locale getLocale() {
        return this.locale;
    }

    @java.lang.SuppressWarnings("all")
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof LocalizableAttributesCommunicationChannelBean)) return false;
        final LocalizableAttributesCommunicationChannelBean other = (LocalizableAttributesCommunicationChannelBean) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$locale = this.getLocale();
        final java.lang.Object other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) return false;
        final java.lang.Object this$attributes = this.getAttributes();
        final java.lang.Object other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !this$attributes.equals(other$attributes)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof LocalizableAttributesCommunicationChannelBean;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $locale = this.getLocale();
        result = result * PRIME + ($locale == null ? 43 : $locale.hashCode());
        final java.lang.Object $attributes = this.getAttributes();
        result = result * PRIME + ($attributes == null ? 43 : $attributes.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString() {
        return "LocalizableAttributesCommunicationChannelBean(super=" + super.toString() + ", locale=" + this.getLocale() + ", attributes=" + this.getAttributes() + ")";
    }

    /**
     * The locale for this communication channel.
     */
    @java.lang.SuppressWarnings("all")
    public void setLocale(@NotNull final Locale locale) {
        this.locale = locale;
    }

    @java.lang.SuppressWarnings("all")
    public void setAttributes(@NotNull final Map<String, Object> attributes) {
        this.attributes = attributes;
    }
}
