/*
 * This file is part of "albirar-communications-core".
 * 
 * "albirar-communications-core" is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * "albirar-communications-core" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with "albirar-communications-core" source code.  If not, see <https://www.gnu.org/licenses/gpl-3.0.html>.
 *
 * Copyright (C) 2020 Octavi Fornés
 */
package cat.albirar.communications.core.processors;

import org.springframework.amqp.core.MessageListener;
/**
 * A common contract for listeners on messages, that inform of managed messages (previous to process) and processed messages (after process).
 * @author Octavi Forn&eacute;s &lt;<a href="mailto:ofornes@albirar.cat">ofornes@albirar.cat</a>&gt;
 * @since 1.0.0
 */
public interface IProcessor extends MessageListener {
    /**
     * Get the number of processed messages (by any specific processor).
     * @return The number of processed messages
     */
    public long getProcessedMessages();
    /**
     * Get the number of managed messages (previous to process).
     * @return The number of managed messages
     */
    public long getManagedMessages();
}
