// Generated by delombok at Thu Feb 18 11:53:42 CET 2021
/*
 * This file is part of "albirar-communications".
 * 
 * "albirar-communications" is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * "albirar-communications" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with "albirar-communications" source code.  If not, see <https://www.gnu.org/licenses/gpl-3.0.html>.
 *
 * Copyright (C) 2020 Octavi Fornés
 */
package cat.albirar.communications.core.status.models;

import java.io.Serializable;
import java.util.Optional;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import cat.albirar.communications.core.messages.models.MessageBean;
import cat.albirar.communications.core.status.EStatusMessage;
import lombok.Builder.Default;

/**
 * The status of a message.
 * @author Octavi Forn&eacute;s &lt;<a href="mailto:ofornes@albirar.cat">ofornes@albirar.cat</a>&gt;
 * @since 1.0.0
 */
@JsonInclude(Include.NON_EMPTY)
public class MessageStatusBean extends MessageBean implements Serializable {
    private static final long serialVersionUID = -4642994972130453525L;
    @NotBlank
    private String messageId;
    @NotNull
    private EStatusMessage status;
    @NotNull
    private Optional<String> errorMessage;

    public static final MessageStatusBeanBuilder<?, ?> copyBuilder(MessageBean message) {
        return (MessageStatusBeanBuilder<?, ?>) MessageStatusBean.builder().receiver(message.getReceiver()).sender(message.getSender()).title(message.getTitle()).bodyType(message.getBodyType()).bodyCharSet(message.getBodyCharSet()).body(message.getBody());
    }

    public MessageStatusBean() {
        super();
        MessageStatusBean b = MessageStatusBean.builder().build();
        messageId = b.getMessageId();
        status = b.getStatus();
        errorMessage = b.getErrorMessage();
    }

    @java.lang.SuppressWarnings("all")
    private static Optional<String> $default$errorMessage() {
        return Optional.empty();
    }


    @java.lang.SuppressWarnings("all")
    public static abstract class MessageStatusBeanBuilder<C extends MessageStatusBean, B extends MessageStatusBean.MessageStatusBeanBuilder<C, B>> extends MessageBean.MessageBeanBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        private String messageId;
        @java.lang.SuppressWarnings("all")
        private EStatusMessage status;
        @java.lang.SuppressWarnings("all")
        private boolean errorMessage$set;
        @java.lang.SuppressWarnings("all")
        private Optional<String> errorMessage$value;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            MessageStatusBean.MessageStatusBeanBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        private static void $fillValuesFromInstanceIntoBuilder(final MessageStatusBean instance, final MessageStatusBean.MessageStatusBeanBuilder<?, ?> b) {
            b.messageId(instance.messageId);
            b.status(instance.status);
            b.errorMessage(instance.errorMessage);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public abstract C build();

        @java.lang.SuppressWarnings("all")
        public B messageId(final String messageId) {
            this.messageId = messageId;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        public B status(final EStatusMessage status) {
            this.status = status;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        public B errorMessage(final Optional<String> errorMessage) {
            this.errorMessage$value = errorMessage;
            errorMessage$set = true;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "MessageStatusBean.MessageStatusBeanBuilder(super=" + super.toString() + ", messageId=" + this.messageId + ", status=" + this.status + ", errorMessage$value=" + this.errorMessage$value + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    private static final class MessageStatusBeanBuilderImpl extends MessageStatusBean.MessageStatusBeanBuilder<MessageStatusBean, MessageStatusBean.MessageStatusBeanBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        private MessageStatusBeanBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        protected MessageStatusBean.MessageStatusBeanBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public MessageStatusBean build() {
            return new MessageStatusBean(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    protected MessageStatusBean(final MessageStatusBean.MessageStatusBeanBuilder<?, ?> b) {
        super(b);
        this.messageId = b.messageId;
        this.status = b.status;
        if (b.errorMessage$set) this.errorMessage = b.errorMessage$value;
         else this.errorMessage = MessageStatusBean.$default$errorMessage();
    }

    @java.lang.SuppressWarnings("all")
    public static MessageStatusBean.MessageStatusBeanBuilder<?, ?> builder() {
        return new MessageStatusBean.MessageStatusBeanBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    public MessageStatusBean.MessageStatusBeanBuilder<?, ?> toBuilder() {
        return new MessageStatusBean.MessageStatusBeanBuilderImpl().$fillValuesFrom(this);
    }

    @java.lang.SuppressWarnings("all")
    public String getMessageId() {
        return this.messageId;
    }

    @java.lang.SuppressWarnings("all")
    public EStatusMessage getStatus() {
        return this.status;
    }

    @java.lang.SuppressWarnings("all")
    public Optional<String> getErrorMessage() {
        return this.errorMessage;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString() {
        return "MessageStatusBean(super=" + super.toString() + ", messageId=" + this.getMessageId() + ", status=" + this.getStatus() + ", errorMessage=" + this.getErrorMessage() + ")";
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof MessageStatusBean)) return false;
        final MessageStatusBean other = (MessageStatusBean) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$messageId = this.getMessageId();
        final java.lang.Object other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !this$messageId.equals(other$messageId)) return false;
        final java.lang.Object this$status = this.getStatus();
        final java.lang.Object other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
        final java.lang.Object this$errorMessage = this.getErrorMessage();
        final java.lang.Object other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof MessageStatusBean;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $messageId = this.getMessageId();
        result = result * PRIME + ($messageId == null ? 43 : $messageId.hashCode());
        final java.lang.Object $status = this.getStatus();
        result = result * PRIME + ($status == null ? 43 : $status.hashCode());
        final java.lang.Object $errorMessage = this.getErrorMessage();
        result = result * PRIME + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        return result;
    }

    @java.lang.SuppressWarnings("all")
    public void setMessageId(@NotBlank final String messageId) {
        this.messageId = messageId;
    }

    @java.lang.SuppressWarnings("all")
    public void setStatus(@NotNull final EStatusMessage status) {
        this.status = status;
    }

    @java.lang.SuppressWarnings("all")
    public void setErrorMessage(@NotNull final Optional<String> errorMessage) {
        this.errorMessage = errorMessage;
    }
}
