/*
 * Decompiled with CFR 0.152.
 */
package cat.albirar.communications.services.impl;

import cat.albirar.communications.core.configuration.AlbirarCommunicationsConfiguration;
import cat.albirar.communications.core.messages.models.MessageBean;
import cat.albirar.communications.core.services.ICommunicationService;
import cat.albirar.communications.core.services.ServiceException;
import cat.albirar.communications.core.status.models.MessageStatusBean;
import cat.albirar.communications.test.RabbitMqContainerExtension;
import cat.albirar.communications.test.configuration.CoreCommunicationsTestConfiguration;
import cat.albirar.communications.test.configuration.TestMessagesFactory;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitOperations;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.mock.mockito.SpyBean;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ContextConfiguration(classes={AlbirarCommunicationsConfiguration.class, CoreCommunicationsTestConfiguration.class})
@ExtendWith(value={SpringExtension.class, RabbitMqContainerExtension.class})
public class CommunicationServiceExceptionTest {
    @Autowired
    private ICommunicationService communicationService;
    @SpyBean
    private RabbitOperations mockedRabbitOperations;
    private MessageBean emailMessage;

    @BeforeEach
    public void init() {
        TestMessagesFactory tm = new TestMessagesFactory();
        this.emailMessage = tm.getEmailMessage();
    }

    @Test
    public void testSendingRabbitMqException() {
        ((RabbitOperations)Mockito.doThrow(AmqpException.class).when((Object)this.mockedRabbitOperations)).send((String)ArgumentMatchers.any(String.class), (String)ArgumentMatchers.any(String.class), (Message)ArgumentMatchers.any(Message.class), (CorrelationData)ArgumentMatchers.any(CorrelationData.class));
        ServiceException ex = (ServiceException)Assertions.assertThrows(ServiceException.class, () -> this.communicationService.pushMessage(this.emailMessage));
        Assertions.assertNotNull((Object)ex.getCause());
        Assertions.assertEquals(AmqpException.class, ex.getCause().getClass());
    }

    @Test
    public void testReportRabbitMqException() {
        ((RabbitOperations)Mockito.doThrow(AmqpException.class).when((Object)this.mockedRabbitOperations)).convertAndSend((String)ArgumentMatchers.any(String.class), (String)ArgumentMatchers.any(String.class), ArgumentMatchers.any(MessageStatusBean.class), (CorrelationData)ArgumentMatchers.any(CorrelationData.class));
        String msgId = this.communicationService.pushMessage(this.emailMessage);
        Awaitility.await().atLeast(10L, TimeUnit.MILLISECONDS).and().atMost(10L, TimeUnit.SECONDS);
        Assertions.assertFalse((boolean)this.communicationService.isStatusMessage(msgId));
    }
}

